/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.map;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapView;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapPalette;

public class CraftMapCanvas
implements MapCanvas {
    private final byte[] buffer = new byte[16384];
    private final CraftMapView mapView;
    private byte[] base;
    private MapCursorCollection cursors = new MapCursorCollection();

    protected CraftMapCanvas(CraftMapView mapView) {
        this.mapView = mapView;
        Arrays.fill(this.buffer, (byte)-1);
    }

    public CraftMapView getMapView() {
        return this.mapView;
    }

    public MapCursorCollection getCursors() {
        return this.cursors;
    }

    public void setCursors(MapCursorCollection cursors) {
        this.cursors = cursors;
    }

    public void setPixelColor(int x2, int y2, Color color) {
        this.setPixel(x2, y2, color == null ? (byte)-1 : (byte)MapPalette.matchColor((Color)color));
    }

    public Color getPixelColor(int x2, int y2) {
        byte pixel = this.getPixel(x2, y2);
        if (pixel == -1) {
            return null;
        }
        return MapPalette.getColor((byte)pixel);
    }

    public Color getBasePixelColor(int x2, int y2) {
        return MapPalette.getColor((byte)this.getBasePixel(x2, y2));
    }

    public void setPixel(int x2, int y2, byte color) {
        if (x2 < 0 || y2 < 0 || x2 >= 128 || y2 >= 128) {
            return;
        }
        if (this.buffer[y2 * 128 + x2] != color) {
            this.buffer[y2 * 128 + x2] = color;
            this.mapView.worldMap.setColorsDirty(x2, y2, false);
        }
    }

    public byte getPixel(int x2, int y2) {
        if (x2 < 0 || y2 < 0 || x2 >= 128 || y2 >= 128) {
            return 0;
        }
        return this.buffer[y2 * 128 + x2];
    }

    public byte getBasePixel(int x2, int y2) {
        if (x2 < 0 || y2 < 0 || x2 >= 128 || y2 >= 128) {
            return 0;
        }
        return this.base[y2 * 128 + x2];
    }

    protected void setBase(byte[] base) {
        this.base = base;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    public void drawImage(int x2, int y2, Image image) {
        BufferedImage temp;
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        int sourceX = Math.max(-x2, 0);
        int sourceY = Math.max(-y2, 0);
        int destX = Math.max(x2, 0);
        int destY = Math.max(y2, 0);
        int effectiveWidth = Math.min(imageWidth - sourceX, 128 - destX);
        int effectiveHeight = Math.min(imageHeight - sourceY, 128 - destY);
        if (effectiveWidth <= 0 || effectiveHeight <= 0) {
            return;
        }
        if (imageWidth >= effectiveWidth && image instanceof BufferedImage) {
            BufferedImage bImage = (BufferedImage)image;
            temp = imageWidth > effectiveWidth || imageHeight > effectiveHeight ? bImage.getSubimage(sourceX, sourceY, effectiveWidth, effectiveHeight) : bImage;
        } else {
            temp = new BufferedImage(effectiveWidth, effectiveHeight, 2);
            Graphics2D graphics = temp.createGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
        }
        byte[] bytes = MapPalette.imageToBytes((Image)temp);
        if (x2 == 0 && effectiveWidth == 128) {
            System.arraycopy(bytes, 0, this.buffer, destY * effectiveWidth, effectiveWidth * effectiveHeight);
        } else {
            for (int yToCopy = 0; yToCopy < effectiveHeight; ++yToCopy) {
                int src = yToCopy * effectiveWidth;
                int dest = (destY + yToCopy) * 128 + destX;
                System.arraycopy(bytes, src, this.buffer, dest, effectiveWidth);
            }
        }
        this.mapView.worldMap.setColorsDirty(destX, destY, false);
        this.mapView.worldMap.setColorsDirty(destX + effectiveWidth - 1, destY + effectiveHeight - 1, false);
    }

    public void drawText(int x2, int y2, MapFont font, String text) {
        int xStart = x2;
        byte color = 44;
        Preconditions.checkArgument((boolean)font.isValid(text), (String)"text (%s) contains invalid characters", (Object)text);
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char ch = text.charAt(i2);
            if (ch == '\n') {
                x2 = xStart;
                y2 += font.getHeight() + 1;
                continue;
            }
            if (ch == '\u00a7') {
                int j2 = text.indexOf(59, i2);
                Preconditions.checkArgument((j2 >= 0 ? 1 : 0) != 0, (String)"text (%s) unterminated color string", (Object)text);
                try {
                    color = Byte.parseByte(text.substring(i2 + 1, j2));
                    i2 = j2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            MapFont.CharacterSprite sprite = font.getChar(text.charAt(i2));
            for (int r2 = 0; r2 < font.getHeight(); ++r2) {
                for (int c2 = 0; c2 < sprite.getWidth(); ++c2) {
                    if (!sprite.get(r2, c2)) continue;
                    this.setPixel(x2 + c2, y2 + r2, color);
                }
            }
            x2 += sprite.getWidth() + 1;
        }
    }
}

