/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.scoreboard;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.util.PaperScoreboardFormat;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;

final class CraftObjective
extends CraftScoreboardComponent
implements Objective {
    private final ScoreboardObjective objective;
    private final CraftCriteria criteria;

    CraftObjective(CraftScoreboard scoreboard, ScoreboardObjective objective) {
        super(scoreboard);
        this.objective = objective;
        this.criteria = CraftCriteria.getFromNMS(objective);
    }

    ScoreboardObjective getHandle() {
        return this.objective;
    }

    public String getName() {
        this.checkState();
        return this.objective.c();
    }

    public Component displayName() throws IllegalStateException {
        this.checkState();
        return PaperAdventure.asAdventure(this.objective.e());
    }

    public void displayName(Component displayName) throws IllegalStateException, IllegalArgumentException {
        this.checkState();
        if (displayName == null) {
            displayName = Component.empty();
        }
        this.objective.a(PaperAdventure.asVanilla(displayName));
    }

    public String getDisplayName() {
        this.checkState();
        return CraftChatMessage.fromComponent(this.objective.e());
    }

    public void setDisplayName(String displayName) {
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"Display name cannot be null");
        this.checkState();
        this.objective.a(CraftChatMessage.fromString(displayName)[0]);
    }

    public String getCriteria() {
        this.checkState();
        return this.criteria.name;
    }

    public Criteria getTrackedCriteria() {
        this.checkState();
        return this.criteria;
    }

    public boolean isModifiable() {
        this.checkState();
        return !this.criteria.criteria.e();
    }

    public void setDisplaySlot(org.bukkit.scoreboard.DisplaySlot slot) {
        this.checkState();
        Scoreboard board = this.getScoreboard().getHandle();
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            if (board.a(displaySlot) != this.objective) continue;
            board.a(displaySlot, null);
        }
        if (slot != null) {
            DisplaySlot displaySlot = CraftScoreboardTranslations.fromBukkitSlot(slot);
            board.a(displaySlot, this.getHandle());
        }
    }

    public org.bukkit.scoreboard.DisplaySlot getDisplaySlot() {
        this.checkState();
        Scoreboard board = this.getScoreboard().getHandle();
        ScoreboardObjective objective = this.objective;
        for (DisplaySlot i2 : DisplaySlot.values()) {
            if (board.a(i2) != objective) continue;
            return CraftScoreboardTranslations.toBukkitSlot(i2);
        }
        return null;
    }

    public void setRenderType(RenderType renderType) {
        Preconditions.checkArgument((renderType != null ? 1 : 0) != 0, (Object)"RenderType cannot be null");
        this.checkState();
        this.objective.a(CraftScoreboardTranslations.fromBukkitRender(renderType));
    }

    public RenderType getRenderType() {
        this.checkState();
        return CraftScoreboardTranslations.toBukkitRender(this.objective.i());
    }

    public Score getScore(OfflinePlayer player) {
        this.checkState();
        return new CraftScore(this, CraftScoreboard.getScoreHolder(player));
    }

    public Score getScore(String entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        Preconditions.checkArgument((entry.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (Object)("Score '" + entry + "' is longer than the limit of 32767 characters"));
        this.checkState();
        return new CraftScore(this, CraftScoreboard.getScoreHolder(entry));
    }

    public Score getScoreFor(Entity entity) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.checkState();
        return new CraftScore(this, ((CraftEntity)entity).getHandle());
    }

    public io.papermc.paper.scoreboard.numbers.NumberFormat numberFormat() {
        this.checkState();
        NumberFormat vanilla = this.objective.g();
        if (vanilla == null) {
            return null;
        }
        return PaperScoreboardFormat.asPaper(vanilla);
    }

    public void numberFormat(io.papermc.paper.scoreboard.numbers.NumberFormat format) {
        this.checkState();
        if (format == null) {
            this.objective.b(null);
            return;
        }
        this.objective.b(PaperScoreboardFormat.asVanilla(format));
    }

    @Override
    public void unregister() {
        this.checkState();
        this.getScoreboard().getHandle().j(this.objective);
    }

    public boolean willAutoUpdateDisplay() {
        this.checkState();
        return this.objective.f();
    }

    public void setAutoUpdateDisplay(boolean autoUpdateDisplay) {
        this.checkState();
        this.objective.a(autoUpdateDisplay);
    }

    @Override
    void checkState() {
        Preconditions.checkState((this.getScoreboard().getHandle().a(this.objective.c()) != null ? 1 : 0) != 0, (Object)"Unregistered scoreboard component");
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.objective != null ? this.objective.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftObjective other = (CraftObjective)obj;
        return Objects.equals(this.objective, other.objective);
    }
}

