/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.WorldData;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R6.util.CapturedBlock;
import org.bukkit.craftbukkit.v1_21_R6.util.DummyGeneratorAccess;

public class BlockStateListPopulator
extends DummyGeneratorAccess {
    private final GeneratorAccess level;
    private final Map<BlockPosition, CapturedBlock> blocks = new LinkedHashMap<BlockPosition, CapturedBlock>();
    private List<CraftBlockState> snapshots;

    public BlockStateListPopulator(GeneratorAccess level) {
        this.level = level;
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        CapturedBlock block = this.blocks.get(pos);
        return block != null ? block.state() : this.level.a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        CapturedBlock block = this.blocks.get(pos);
        return block != null ? block.state().y() : this.level.b_(pos);
    }

    @Override
    public TileEntity c_(BlockPosition pos) {
        CapturedBlock block = this.blocks.get(pos);
        return block != null ? block.blockEntity() : this.level.c_(pos);
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, int flags, int recursionLeft) {
        TileEntity newBlockEntity;
        pos = pos.j();
        this.blocks.remove(pos);
        Block block = state.b();
        if (block instanceof ITileEntity) {
            ITileEntity entityBlock = (ITileEntity)((Object)block);
            TileEntity currentBlockEntity = this.c_(pos);
            if (currentBlockEntity != null && currentBlockEntity.b(state)) {
                newBlockEntity = currentBlockEntity;
                currentBlockEntity.c(state);
            } else {
                newBlockEntity = entityBlock.a(pos, state);
            }
        } else {
            newBlockEntity = null;
        }
        this.blocks.put(pos, new CapturedBlock(state, flags, newBlockEntity));
        return true;
    }

    @Override
    public boolean a(BlockPosition pos, boolean dropBlock, Entity entity, int recursionLeft) {
        IBlockData blockState = this.a_(pos);
        if (blockState.l()) {
            return false;
        }
        this.a(pos, blockState.y().g(), 3, recursionLeft);
        return true;
    }

    @Override
    public WorldServer getMinecraftWorld() {
        return this.level.getMinecraftWorld();
    }

    private void iterateSnapshots(Consumer<CraftBlockState> callback) {
        for (Map.Entry<BlockPosition, CapturedBlock> entry : this.blocks.entrySet()) {
            CapturedBlock block = entry.getValue();
            CraftBlockState snapshot = CraftBlockStates.getBlockState(this.getMinecraftWorld().getWorld(), entry.getKey(), block.state(), block.blockEntity());
            snapshot.setFlags(block.flags());
            snapshot.setWorldHandle(this.level);
            callback.accept(snapshot);
        }
    }

    public void placeBlocks() {
        this.placeSomeBlocks($ -> true);
    }

    public void placeSomeBlocks(Predicate<? super BlockState> filter) {
        this.placeSomeBlocks($ -> {}, filter);
    }

    public void placeBlocks(Consumer<? super CraftBlockState> beforeRun) {
        this.placeSomeBlocks(beforeRun, $ -> true);
    }

    public void placeSomeBlocks(Consumer<? super CraftBlockState> beforeRun, Predicate<? super BlockState> filter) {
        for (CraftBlockState snapshot : this.getSnapshotBlocks()) {
            if (!filter.test(snapshot)) continue;
            beforeRun.accept(snapshot);
            snapshot.place(snapshot.getFlags());
        }
    }

    public List<CraftBlockState> getSnapshotBlocks() {
        if (this.snapshots == null) {
            ArrayList<CraftBlockState> snapshots = new ArrayList<CraftBlockState>();
            this.iterateSnapshots(snapshots::add);
            this.snapshots = snapshots;
        }
        return this.snapshots;
    }

    @Override
    public WorldServer a() {
        return this.getMinecraftWorld();
    }

    @Override
    public int M_() {
        return this.level.M_();
    }

    @Override
    public int N_() {
        return this.level.N_();
    }

    @Override
    public boolean a(BlockPosition pos, Predicate<IBlockData> state) {
        return state.test(this.a_(pos));
    }

    @Override
    public boolean b(BlockPosition pos, Predicate<Fluid> state) {
        return state.test(this.b_(pos));
    }

    @Override
    public DimensionManager H_() {
        return this.level.H_();
    }

    @Override
    public IRegistryCustom L_() {
        return this.level.L_();
    }

    @Override
    public WorldData F_() {
        return this.level.F_();
    }

    @Override
    public long K_() {
        return this.level.K_();
    }

    @Override
    public RandomSource I_() {
        return this.level.I_();
    }

    @Override
    public <T extends TileEntity> Optional<T> a(BlockPosition pos, TileEntityTypes<T> type) {
        TileEntity blockEntity = this.c_(pos);
        return blockEntity != null && blockEntity.s() == type ? Optional.of(blockEntity) : Optional.empty();
    }

    @Override
    public BlockPosition a(HeightMap.Type heightmapType, BlockPosition pos) {
        return this.level.a(heightmapType, pos);
    }

    @Override
    public int a(HeightMap.Type heightmapType, int x2, int z2) {
        return this.level.a(heightmapType, x2, z2);
    }

    @Override
    public int b(BlockPosition pos, int amount) {
        return this.level.b(pos, amount);
    }

    @Override
    public int a(EnumSkyBlock lightType, BlockPosition pos) {
        return this.level.a(lightType, pos);
    }
}

