/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.util;

import com.google.common.base.Predicates;
import com.google.common.io.ByteStreams;
import io.papermc.paper.pluginremap.reflect.ReflectionRemapper;
import io.papermc.paper.util.MappingEnvironment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R6.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R6.legacy.MaterialRerouting;
import org.bukkit.craftbukkit.v1_21_R6.legacy.MethodRerouting;
import org.bukkit.craftbukkit.v1_21_R6.legacy.enums.EnumEvil;
import org.bukkit.craftbukkit.v1_21_R6.legacy.reroute.Reroute;
import org.bukkit.craftbukkit.v1_21_R6.legacy.reroute.RerouteArgument;
import org.bukkit.craftbukkit.v1_21_R6.legacy.reroute.RerouteBuilder;
import org.bukkit.craftbukkit.v1_21_R6.legacy.reroute.RerouteMethodData;
import org.bukkit.craftbukkit.v1_21_R6.util.ApiVersion;
import org.bukkit.plugin.AuthorNagException;
import org.jetbrains.annotations.VisibleForTesting;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.RecordComponentVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;

public class Commodore {
    private static final String BUKKIT_GENERATED_METHOD_PREFIX = "BUKKIT_CUSTOM_METHOD_";
    private static final Set<String> EVIL = new HashSet<String>(Arrays.asList("org/bukkit/World (III)I getBlockTypeIdAt", "org/bukkit/World (Lorg/bukkit/Location;)I getBlockTypeIdAt", "org/bukkit/block/Block ()I getTypeId", "org/bukkit/block/Block (I)Z setTypeId", "org/bukkit/block/Block (IZ)Z setTypeId", "org/bukkit/block/Block (IBZ)Z setTypeIdAndData", "org/bukkit/block/Block (B)V setData", "org/bukkit/block/Block (BZ)V setData", "org/bukkit/inventory/ItemStack ()I getTypeId", "org/bukkit/inventory/ItemStack (I)V setTypeId", "org/bukkit/inventory/ItemStack (S)V setDurability"));
    private static final Map<String, String> ENUM_RENAMES = Map.of("java/lang/Enum", "java/lang/Object", "java/util/EnumSet", "org/bukkit/craftbukkit/legacy/enums/ImposterEnumSet", "java/util/EnumMap", "org/bukkit/craftbukkit/legacy/enums/ImposterEnumMap");
    private static final Map<String, String> RENAMES = Map.of("org/bukkit/entity/TextDisplay$TextAligment", "org/bukkit/entity/TextDisplay$TextAlignment", "org/spigotmc/event/entity/EntityMountEvent", "org/bukkit/event/entity/EntityMountEvent", "org/spigotmc/event/entity/EntityDismountEvent", "org/bukkit/event/entity/EntityDismountEvent", "org/bukkit/block/data/type/Crafter$Orientation", "org/bukkit/block/Orientation", "org/bukkit/block/data/type/Jigsaw$Orientation", "org/bukkit/block/Orientation", "org/bukkit/block/data/type/MossyCarpet$Height", "org/bukkit/block/data/type/Wall$Height");
    private static final Map<String, String> CLASS_TO_INTERFACE = Map.ofEntries(Map.entry("org/bukkit/inventory/InventoryView", "org/bukkit/craftbukkit/inventory/CraftAbstractInventoryView"), Map.entry("org/bukkit/entity/Villager$Type", "NOP"), Map.entry("org/bukkit/entity/Villager$Profession", "NOP"), Map.entry("org/bukkit/entity/Frog$Variant", "NOP"), Map.entry("org/bukkit/entity/Cat$Type", "NOP"), Map.entry("org/bukkit/map/MapCursor$Type", "NOP"), Map.entry("org/bukkit/block/banner/PatternType", "NOP"), Map.entry("org/bukkit/Art", "NOP"), Map.entry("org/bukkit/attribute/Attribute", "NOP"), Map.entry("org/bukkit/block/Biome", "NOP"), Map.entry("org/bukkit/Fluid", "NOP"), Map.entry("org/bukkit/Sound", "NOP"));
    private final List<Reroute> reroutes = new ArrayList<Reroute>();
    private Reroute materialReroute;
    private Reroute reroute;
    private static final String CB_PACKAGE_PREFIX = "org/bukkit/".concat("craftbukkit/");
    private static final String LEGACY_CB_PACKAGE_PREFIX = CB_PACKAGE_PREFIX + "v1_21_R6/";

    public Commodore() {
    }

    public Commodore(Predicate<String> compatibilityPresent) {
        this.updateReroute(compatibilityPresent);
    }

    public void updateReroute(Predicate<String> compatibilityPresent) {
        this.materialReroute = RerouteBuilder.create(compatibilityPresent).forClass(MaterialRerouting.class).build();
        this.reroute = RerouteBuilder.create(compatibilityPresent).forClass(FieldRename.class).forClass(MethodRerouting.class).forClass(EnumEvil.class).build();
        this.reroutes.clear();
        this.reroutes.add(this.materialReroute);
        this.reroutes.add(this.reroute);
    }

    @VisibleForTesting
    public List<Reroute> getReroutes() {
        return this.reroutes;
    }

    private static String runtimeCbPkgPrefix() {
        if (MappingEnvironment.reobf()) {
            return LEGACY_CB_PACKAGE_PREFIX;
        }
        return CB_PACKAGE_PREFIX;
    }

    @Nonnull
    private static String getOriginalOrRewrite(@Nonnull String original) {
        if (!MappingEnvironment.reobf() && !MappingEnvironment.hasMappings() && original.contains(LEGACY_CB_PACKAGE_PREFIX)) {
            original = original.replace(LEGACY_CB_PACKAGE_PREFIX, CB_PACKAGE_PREFIX);
        }
        return original;
    }

    public static void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec inputFlag = parser.acceptsAll(Arrays.asList("i", "input")).withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec outputFlag = parser.acceptsAll(Arrays.asList("o", "output")).withRequiredArg().ofType(File.class).required();
        OptionSet options = parser.parse(args);
        File input = (File)options.valueOf((OptionSpec)inputFlag);
        File output = (File)options.valueOf((OptionSpec)outputFlag);
        Commodore commodore = new Commodore((Predicate<String>)Predicates.alwaysTrue());
        if (input.isDirectory()) {
            if (!output.isDirectory()) {
                System.err.println("If input directory specified, output directory required too");
                return;
            }
            for (File in : input.listFiles()) {
                if (!in.getName().endsWith(".jar")) continue;
                Commodore.convert(in, new File(output, in.getName()), commodore);
            }
        } else {
            Commodore.convert(input, output, commodore);
        }
    }

    private static void convert(File in, File out, Commodore commodore) {
        System.out.println("Attempting to convert " + String.valueOf(in) + " to " + String.valueOf(out));
        try (JarFile inJar = new JarFile(in, false);){
            JarEntry entry = inJar.getJarEntry(".commodore");
            if (entry != null) {
                return;
            }
            try (JarOutputStream outJar = new JarOutputStream(new FileOutputStream(out));){
                Enumeration<JarEntry> entries = inJar.entries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    InputStream is = inJar.getInputStream(entry);
                    try {
                        byte[] b2 = ByteStreams.toByteArray((InputStream)is);
                        if (entry.getName().endsWith(".class")) {
                            b2 = commodore.convert(b2, "dummy", ApiVersion.NONE, Collections.emptySet());
                            entry = new JarEntry(entry.getName());
                        }
                        outJar.putNextEntry(entry);
                        outJar.write(b2);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                outJar.putNextEntry(new ZipEntry(".commodore"));
            }
        }
        catch (Exception ex) {
            System.err.println("Fatal error trying to convert " + String.valueOf(in));
            ex.printStackTrace();
        }
    }

    public byte[] convert(byte[] b2, final String pluginName, final ApiVersion pluginVersion, final Set<String> activeCompatibilities) {
        ClassWriter cw;
        final boolean modern = pluginVersion.isNewerThanOrSameAs(ApiVersion.FLATTENING);
        ClassReader cr = new ClassReader(b2);
        ClassWriter visitor = cw = new ClassWriter(cr, 0);
        visitor = ReflectionRemapper.visitor((ClassVisitor)visitor);
        HashMap<String, String> renames = new HashMap<String, String>(RENAMES);
        if (pluginVersion.isOlderThan(ApiVersion.ABSTRACT_COW)) {
            renames.put("org/bukkit/entity/Cow", "org/bukkit/entity/AbstractCow");
        }
        cr.accept((ClassVisitor)new ClassRemapper(new ClassVisitor(589824, (ClassVisitor)visitor){
            final Set<RerouteMethodData> rerouteMethodData;
            String className;
            boolean isInterface;
            {
                super(arg0, arg1);
                this.rerouteMethodData = new HashSet<RerouteMethodData>();
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.className = name;
                this.isInterface = (access & 0x200) != 0;
                String craftbukkitClass = CLASS_TO_INTERFACE.get(superName);
                if (craftbukkitClass != null) {
                    superName = craftbukkitClass;
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public void visitEnd() {
                for (RerouteMethodData rerouteMethodData : this.rerouteMethodData) {
                    MethodVisitor methodVisitor = super.visitMethod(4105, Commodore.buildMethodName(rerouteMethodData), Commodore.buildMethodDesc(rerouteMethodData), null, null);
                    methodVisitor.visitCode();
                    int index = 0;
                    int extraSize = 0;
                    for (RerouteArgument argument : rerouteMethodData.arguments()) {
                        if (argument.injectPluginName()) {
                            methodVisitor.visitLdcInsn((Object)pluginName);
                            continue;
                        }
                        if (argument.injectPluginVersion()) {
                            methodVisitor.visitLdcInsn((Object)pluginVersion.getVersionString());
                            methodVisitor.visitMethodInsn(184, Type.getInternalName(ApiVersion.class), "getOrCreateVersion", "(Ljava/lang/String;)L" + Type.getInternalName(ApiVersion.class) + ";", false);
                            continue;
                        }
                        if (argument.injectCompatibility() != null) {
                            methodVisitor.visitLdcInsn((Object)activeCompatibilities.contains(argument.injectCompatibility()));
                            continue;
                        }
                        methodVisitor.visitVarInsn(argument.instruction(), index);
                        ++index;
                        extraSize += argument.type().getSize() - 1;
                    }
                    methodVisitor.visitMethodInsn(184, rerouteMethodData.targetOwner(), rerouteMethodData.targetName(), rerouteMethodData.targetType().getDescriptor(), false);
                    methodVisitor.visitInsn(rerouteMethodData.rerouteReturn().instruction());
                    methodVisitor.visitMaxs(rerouteMethodData.arguments().size() + extraSize, index + extraSize);
                    methodVisitor.visitEnd();
                }
                super.visitEnd();
            }

            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                return Commodore.createAnnotationVisitor(pluginVersion, this.api, super.visitAnnotation(descriptor, visible));
            }

            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                return Commodore.createAnnotationVisitor(pluginVersion, this.api, super.visitTypeAnnotation(typeRef, typePath, descriptor, visible));
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){

                    public void visitTypeInsn(int opcode, String type) {
                        type = Commodore.getOriginalOrRewrite(type);
                        super.visitTypeInsn(opcode, type);
                    }

                    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                        int i2;
                        for (i2 = 0; i2 < local.length; ++i2) {
                            if (!(local[i2] instanceof String)) continue;
                            local[i2] = Commodore.getOriginalOrRewrite((String)local[i2]);
                        }
                        for (i2 = 0; i2 < stack.length; ++i2) {
                            if (!(stack[i2] instanceof String)) continue;
                            stack[i2] = Commodore.getOriginalOrRewrite((String)stack[i2]);
                        }
                        super.visitFrame(type, nLocal, local, nStack, stack);
                    }

                    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                        descriptor = Commodore.getOriginalOrRewrite(descriptor);
                        super.visitLocalVariable(name, descriptor, signature, start, end, index);
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        owner = Commodore.getOriginalOrRewrite(owner);
                        if (desc != null) {
                            desc = Commodore.getOriginalOrRewrite(desc);
                        }
                        name = FieldRename.rename(pluginVersion, owner, name);
                        if (modern) {
                            if (owner.equals("org/bukkit/Material")) {
                                switch (name) {
                                    case "CACTUS_GREEN": {
                                        name = "GREEN_DYE";
                                        break;
                                    }
                                    case "DANDELION_YELLOW": {
                                        name = "YELLOW_DYE";
                                        break;
                                    }
                                    case "ROSE_RED": {
                                        name = "RED_DYE";
                                        break;
                                    }
                                    case "SIGN": {
                                        name = "OAK_SIGN";
                                        break;
                                    }
                                    case "WALL_SIGN": {
                                        name = "OAK_WALL_SIGN";
                                        break;
                                    }
                                    case "ZOMBIE_PIGMAN_SPAWN_EGG": {
                                        name = "ZOMBIFIED_PIGLIN_SPAWN_EGG";
                                        break;
                                    }
                                    case "GRASS_PATH": {
                                        name = "DIRT_PATH";
                                        break;
                                    }
                                    case "GRASS": {
                                        name = "SHORT_GRASS";
                                        break;
                                    }
                                    case "SCUTE": {
                                        name = "TURTLE_SCUTE";
                                        break;
                                    }
                                    case "CHAIN": {
                                        name = "IRON_CHAIN";
                                    }
                                }
                            }
                            super.visitFieldInsn(opcode, owner, name, desc);
                            return;
                        }
                        if (owner.equals("org/bukkit/Material")) {
                            try {
                                Material.valueOf((String)("LEGACY_" + name));
                            }
                            catch (IllegalArgumentException ex) {
                                throw new AuthorNagException("No legacy enum constant for " + name + ". Did you forget to define a modern (1.13+) api-version in your plugin.yml?");
                            }
                            super.visitFieldInsn(opcode, owner, "LEGACY_" + name, desc);
                            return;
                        }
                        if (owner.equals("org/bukkit/Art")) {
                            switch (name) {
                                case "BURNINGSKULL": {
                                    super.visitFieldInsn(opcode, owner, "BURNING_SKULL", desc);
                                    return;
                                }
                                case "DONKEYKONG": {
                                    super.visitFieldInsn(opcode, owner, "DONKEY_KONG", desc);
                                    return;
                                }
                            }
                        }
                        if (owner.equals("org/bukkit/DyeColor")) {
                            switch (name) {
                                case "SILVER": {
                                    super.visitFieldInsn(opcode, owner, "LIGHT_GRAY", desc);
                                    return;
                                }
                            }
                        }
                        super.visitFieldInsn(opcode, owner, name, desc);
                    }

                    private void handleMethod(MethodPrinter visitor, int opcode, String owner, String name, String desc, boolean itf, Type samMethodType, Type instantiatedMethodType) {
                        if (this.checkReroute(visitor, Commodore.this.reroute, opcode, owner, name, desc, samMethodType, instantiatedMethodType)) {
                            return;
                        }
                        String craftbukkitClass = CLASS_TO_INTERFACE.get(owner);
                        if (craftbukkitClass != null) {
                            if (opcode == 183 || opcode == 7) {
                                owner = craftbukkitClass;
                            } else {
                                if (opcode == 182) {
                                    opcode = 185;
                                }
                                if (opcode == 5) {
                                    opcode = 9;
                                }
                                itf = true;
                            }
                        }
                        if (owner.equals("org/bukkit/map/MapView") && name.equals("getId") && desc.equals("()S")) {
                            visitor.visit(opcode, owner, name, "()I", itf, samMethodType, Type.getMethodType((String)"(Lorg/bukkit/map/MapView;)Ljava/lang/Integer;"));
                            return;
                        }
                        if ((owner.equals("org/bukkit/Bukkit") || owner.equals("org/bukkit/Server")) && name.equals("getMap") && desc.equals("(S)Lorg/bukkit/map/MapView;")) {
                            visitor.visit(opcode, owner, name, "(I)Lorg/bukkit/map/MapView;", itf, samMethodType, instantiatedMethodType);
                            return;
                        }
                        if (owner.startsWith("org/bukkit") && desc.contains("org/bukkit/util/Consumer")) {
                            visitor.visit(opcode, owner, name, desc.replace("org/bukkit/util/Consumer", "java/util/function/Consumer"), itf, samMethodType, instantiatedMethodType);
                            return;
                        }
                        owner = Commodore.getOriginalOrRewrite(owner);
                        if (desc != null) {
                            desc = Commodore.getOriginalOrRewrite(desc);
                        }
                        if ((owner.equals("org/bukkit/OfflinePlayer") || owner.equals("org/bukkit/entity/Player")) && name.equals("getPlayerProfile") && desc.equals("()Lorg/bukkit/profile/PlayerProfile;")) {
                            super.visitMethodInsn(opcode, owner, name, "()Lcom/destroystokyo/paper/profile/PlayerProfile;", itf);
                            return;
                        }
                        if (owner.equals("org/bukkit/advancement/Advancement") && name.equals("getDisplay") && desc.endsWith(")Lorg/bukkit/advancement/AdvancementDisplay;")) {
                            super.visitTypeInsn(192, Commodore.runtimeCbPkgPrefix() + "advancement/CraftAdvancement");
                            super.visitMethodInsn(182, Commodore.runtimeCbPkgPrefix() + "advancement/CraftAdvancement", "getDisplay0", desc, false);
                            return;
                        }
                        if (owner.equals("org/bukkit/WorldCreator") && name.equals("keepSpawnLoaded") && desc.equals("(Lnet/kyori/adventure/util/TriState;)V")) {
                            super.visitMethodInsn(opcode, owner, name, "(Lnet/kyori/adventure/util/TriState;)Lorg/bukkit/WorldCreator;", itf);
                            super.visitInsn(87);
                            return;
                        }
                        if (owner.equals("org/bukkit/inventory/ItemFactory") && name.equals("getSpawnEgg") && desc.equals("(Lorg/bukkit/entity/EntityType;)Lorg/bukkit/inventory/ItemStack;")) {
                            super.visitInsn(95);
                            super.visitTypeInsn(192, Commodore.runtimeCbPkgPrefix() + "inventory/CraftItemFactory");
                            super.visitInsn(95);
                            super.visitMethodInsn(182, Commodore.runtimeCbPkgPrefix() + "inventory/CraftItemFactory", "getSpawnEgg0", desc, false);
                            return;
                        }
                        if (modern) {
                            if (owner.equals("org/bukkit/Material") || instantiatedMethodType != null && instantiatedMethodType.getDescriptor().startsWith("(Lorg/bukkit/Material;)")) {
                                switch (name) {
                                    case "values": {
                                        visitor.visit(opcode, "org/bukkit/craftbukkit/util/CraftLegacy", "modern_" + name, desc, itf, samMethodType, instantiatedMethodType);
                                        return;
                                    }
                                    case "ordinal": {
                                        visitor.visit(184, "org/bukkit/craftbukkit/util/CraftLegacy", "modern_" + name, "(Lorg/bukkit/Material;)I", false, samMethodType, instantiatedMethodType);
                                        return;
                                    }
                                }
                            }
                            visitor.visit(opcode, owner, name, desc, itf, samMethodType, instantiatedMethodType);
                            return;
                        }
                        if (owner.equals("org/bukkit/Particle") && name.equals("getDataType") && desc.equals("()Ljava/lang/Class;")) {
                            visitor.visit(184, "org/bukkit/craftbukkit/legacy/CraftEvil", name, "(Lorg/bukkit/Particle;)Ljava/lang/Class;", false, samMethodType, instantiatedMethodType);
                            return;
                        }
                        if (owner.equals("org/bukkit/ChunkSnapshot") && name.equals("getBlockData") && desc.equals("(III)I")) {
                            visitor.visit(opcode, owner, "getData", desc, itf, samMethodType, instantiatedMethodType);
                            return;
                        }
                        Type retType = Type.getReturnType((String)desc);
                        if (EVIL.contains(owner + " " + desc + " " + name) || owner.startsWith("org/bukkit/block/") && (desc + " " + name).equals("()I getTypeId") || owner.startsWith("org/bukkit/block/") && (desc + " " + name).equals("(I)Z setTypeId")) {
                            Type[] args = Type.getArgumentTypes((String)desc);
                            Type[] newArgs = new Type[args.length + 1];
                            newArgs[0] = Type.getObjectType((String)owner);
                            System.arraycopy(args, 0, newArgs, 1, args.length);
                            visitor.visit(184, "org/bukkit/craftbukkit/legacy/CraftEvil", name, Type.getMethodDescriptor((Type)retType, (Type[])newArgs), false, samMethodType, instantiatedMethodType);
                            return;
                        }
                        if (owner.equals("org/bukkit/DyeColor") && name.equals("valueOf") && desc.equals("(Ljava/lang/String;)Lorg/bukkit/DyeColor;")) {
                            visitor.visit(opcode, owner, "legacyValueOf", desc, itf, samMethodType, instantiatedMethodType);
                            return;
                        }
                        if (owner.equals("org/bukkit/Material") || instantiatedMethodType != null && instantiatedMethodType.getDescriptor().startsWith("(Lorg/bukkit/Material;)")) {
                            if (name.equals("getMaterial") && desc.equals("(I)Lorg/bukkit/Material;")) {
                                visitor.visit(opcode, "org/bukkit/craftbukkit/legacy/CraftEvil", name, desc, itf, samMethodType, instantiatedMethodType);
                                return;
                            }
                            switch (name) {
                                case "values": 
                                case "valueOf": 
                                case "getMaterial": 
                                case "matchMaterial": {
                                    visitor.visit(opcode, "org/bukkit/craftbukkit/legacy/CraftLegacy", name, desc, itf, samMethodType, instantiatedMethodType);
                                    return;
                                }
                                case "ordinal": {
                                    visitor.visit(184, "org/bukkit/craftbukkit/legacy/CraftLegacy", "ordinal", "(Lorg/bukkit/Material;)I", false, samMethodType, instantiatedMethodType);
                                    return;
                                }
                                case "name": 
                                case "toString": {
                                    visitor.visit(184, "org/bukkit/craftbukkit/legacy/CraftLegacy", name, "(Lorg/bukkit/Material;)Ljava/lang/String;", false, samMethodType, instantiatedMethodType);
                                    return;
                                }
                            }
                        }
                        if (owner.startsWith("org/bukkit") && this.checkReroute(visitor, Commodore.this.materialReroute, opcode, owner, name, desc, samMethodType, instantiatedMethodType)) {
                            return;
                        }
                        visitor.visit(opcode, owner, name, desc, itf, samMethodType, instantiatedMethodType);
                    }

                    private boolean checkReroute(MethodPrinter visitor, Reroute reroute, int opcode, String owner, String name, String desc, Type samMethodType, Type instantiatedMethodType) {
                        return Commodore.rerouteMethods(pluginVersion, reroute, opcode == 184 || opcode == 6, owner, name, desc, data -> {
                            visitor.visit(184, className, Commodore.buildMethodName(data), Commodore.buildMethodDesc(data), isInterface, samMethodType, instantiatedMethodType);
                            rerouteMethodData.add((RerouteMethodData)data);
                        });
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        this.handleMethod((newOpcode, newOwner, newName, newDescription, newItf, newSam, newInstantiated) -> super.visitMethodInsn(newOpcode, newOwner, newName, newDescription, newItf), opcode, owner, name, desc, itf, null, null);
                    }

                    public void visitLdcInsn(Object value) {
                        Type type;
                        if (value instanceof Type && ((type = (Type)value).getSort() == 10 || type.getSort() == 9)) {
                            value = Type.getType((String)Commodore.getOriginalOrRewrite(type.getDescriptor()));
                        }
                        if (value instanceof String && ((String)value).equals("com.mysql.jdbc.Driver")) {
                            super.visitLdcInsn((Object)"com.mysql.cj.jdbc.Driver");
                            return;
                        }
                        super.visitLdcInsn(value);
                    }

                    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                        name = Commodore.getOriginalOrRewrite(name);
                        if (descriptor != null) {
                            descriptor = Commodore.getOriginalOrRewrite(descriptor);
                        }
                        String fName = name;
                        String fDescriptor = descriptor;
                        if (bootstrapMethodHandle.getOwner().equals("java/lang/invoke/LambdaMetafactory") && bootstrapMethodHandle.getName().equals("metafactory") && bootstrapMethodArguments.length == 3) {
                            Type samMethodType = (Type)bootstrapMethodArguments[0];
                            Handle implMethod = (Handle)bootstrapMethodArguments[1];
                            Type instantiatedMethodType = (Type)bootstrapMethodArguments[2];
                            this.handleMethod((newOpcode, newOwner, newName, newDescription, newItf, newSam, newInstantiated) -> {
                                if (newOpcode == 184) {
                                    newOpcode = 6;
                                }
                                ArrayList<Object> methodArgs = new ArrayList<Object>();
                                methodArgs.add(newSam);
                                methodArgs.add(new Handle(newOpcode, newOwner, newName, newDescription, newItf));
                                methodArgs.add(newInstantiated);
                                super.visitInvokeDynamicInsn(fName, fDescriptor, bootstrapMethodHandle, (Object[])methodArgs.toArray(Object[]::new));
                            }, implMethod.getTag(), implMethod.getOwner(), implMethod.getName(), implMethod.getDesc(), implMethod.isInterface(), samMethodType, instantiatedMethodType);
                            return;
                        }
                        super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
                    }

                    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        return Commodore.createAnnotationVisitor(pluginVersion, this.api, super.visitAnnotation(descriptor, visible));
                    }

                    public AnnotationVisitor visitAnnotationDefault() {
                        return Commodore.createAnnotationVisitor(pluginVersion, this.api, super.visitAnnotationDefault());
                    }

                    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                        return Commodore.createAnnotationVisitor(pluginVersion, this.api, super.visitInsnAnnotation(typeRef, typePath, descriptor, visible));
                    }

                    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
                        return Commodore.createAnnotationVisitor(pluginVersion, this.api, super.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, descriptor, visible));
                    }

                    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
                        return Commodore.createAnnotationVisitor(pluginVersion, this.api, super.visitParameterAnnotation(parameter, descriptor, visible));
                    }

                    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                        return Commodore.createAnnotationVisitor(pluginVersion, this.api, super.visitTryCatchAnnotation(typeRef, typePath, descriptor, visible));
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                        return Commodore.createAnnotationVisitor(pluginVersion, this.api, super.visitTypeAnnotation(typeRef, typePath, descriptor, visible));
                    }
                };
            }

            public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                descriptor = Commodore.getOriginalOrRewrite(descriptor);
                if (signature != null) {
                    signature = Commodore.getOriginalOrRewrite(signature);
                }
                return new FieldVisitor(this.api, super.visitField(access, name, descriptor, signature, value)){

                    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        return Commodore.createAnnotationVisitor(pluginVersion, this.api, super.visitAnnotation(descriptor, visible));
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                        return Commodore.createAnnotationVisitor(pluginVersion, this.api, super.visitTypeAnnotation(typeRef, typePath, descriptor, visible));
                    }
                };
            }

            public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
                return new RecordComponentVisitor(this.api, super.visitRecordComponent(name, descriptor, signature)){

                    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        return Commodore.createAnnotationVisitor(pluginVersion, this.api, super.visitAnnotation(descriptor, visible));
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
                        return Commodore.createAnnotationVisitor(pluginVersion, this.api, super.visitTypeAnnotation(typeRef, typePath, descriptor, visible));
                    }
                };
            }
        }, (Remapper)new SimpleRemapper(renames)), 0);
        return cw.toByteArray();
    }

    private static AnnotationVisitor createAnnotationVisitor(final ApiVersion apiVersion, int api, AnnotationVisitor delegate) {
        return new AnnotationVisitor(api, delegate){

            public void visitEnum(String name, String descriptor, String value) {
                super.visitEnum(name, descriptor, FieldRename.rename(apiVersion, Type.getType((String)descriptor).getInternalName(), value));
            }

            public AnnotationVisitor visitArray(String name) {
                return Commodore.createAnnotationVisitor(apiVersion, this.api, super.visitArray(name));
            }

            public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                return Commodore.createAnnotationVisitor(apiVersion, this.api, super.visitAnnotation(name, descriptor));
            }
        };
    }

    public static boolean rerouteMethods(ApiVersion pluginVersion, Reroute reroute, boolean staticCall, String owner, String name, String desc, Consumer<RerouteMethodData> consumer) {
        return reroute.apply(pluginVersion, owner, name, desc, staticCall, consumer);
    }

    private static List<String> getMethodSignatures(byte[] clazz) {
        final ArrayList<String> methods = new ArrayList<String>();
        ClassReader cr = new ClassReader(clazz);
        cr.accept(new ClassVisitor(589824){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                methods.add(descriptor + " " + name);
                return null;
            }
        }, 0);
        return methods;
    }

    private static String buildMethodName(RerouteMethodData rerouteMethodData) {
        return BUKKIT_GENERATED_METHOD_PREFIX + rerouteMethodData.targetOwner().replace('/', '_') + "_" + rerouteMethodData.targetName();
    }

    private static String buildMethodDesc(RerouteMethodData rerouteMethodData) {
        return Type.getMethodDescriptor((Type)rerouteMethodData.sourceDesc().getReturnType(), (Type[])((Type[])rerouteMethodData.arguments().stream().filter(a2 -> !a2.injectPluginName()).filter(a2 -> !a2.injectPluginVersion()).filter(a2 -> a2.injectCompatibility() == null).map(RerouteArgument::sourceType).toArray(Type[]::new)));
    }

    @FunctionalInterface
    private static interface MethodPrinter {
        public void visit(int var1, String var2, String var3, String var4, boolean var5, Type var6, Type var7);
    }
}

