/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.util;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CraftRayTraceResult {
    private CraftRayTraceResult() {
    }

    public static @Nullable RayTraceResult convertFromInternal(GeneratorAccess world, @Nullable MovingObjectPosition hitResult) {
        if (hitResult == null || hitResult.d() == MovingObjectPosition.EnumMovingObjectType.a) {
            return null;
        }
        Vector hitPos = CraftVector.toBukkit(hitResult.g());
        BlockFace hitBlockFace = null;
        if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            CraftEntity hitEntity = ((MovingObjectPositionEntity)hitResult).a().getBukkitEntity();
            return new RayTraceResult(hitPos, (Entity)hitEntity, null);
        }
        BlockPosition pos = null;
        if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock blockHitResult = (MovingObjectPositionBlock)hitResult;
            hitBlockFace = CraftBlock.notchToBlockFace(blockHitResult.c());
            pos = blockHitResult.b();
        }
        CraftBlock hitBlock = null;
        if (pos != null) {
            hitBlock = CraftBlock.at(world, pos);
        }
        return new RayTraceResult(hitPos, (Block)hitBlock, hitBlockFace);
    }
}

