/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.command;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.purpurmc.purpur.PurpurConfig;

public class PurpurCommand
extends Command {
    public PurpurCommand(String name) {
        super(name);
        this.description = "Purpur related commands";
        this.usageMessage = "/purpur [reload | version]";
        this.setPermission("bukkit.command.purpur");
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        if (args.length == 1) {
            return Stream.of("reload", "version").filter(arg -> arg.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        Command verCmd;
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            Command.broadcastCommandMessage((CommandSender)sender, (String)(String.valueOf(ChatColor.RED) + "Please note that this command is not supported and may cause issues."));
            Command.broadcastCommandMessage((CommandSender)sender, (String)(String.valueOf(ChatColor.RED) + "If you encounter any issues please use the /stop command to restart your server."));
            MinecraftServer console = MinecraftServer.getServer();
            PurpurConfig.init((File)console.options.valueOf("purpur-settings"));
            for (WorldServer level : console.Q()) {
                level.purpurConfig.init();
                level.resetBreedingCooldowns();
            }
            ++console.server.reloadCount;
            Command.broadcastCommandMessage((CommandSender)sender, (String)(String.valueOf(ChatColor.GREEN) + "Purpur config reload complete."));
        } else if (args[0].equalsIgnoreCase("version") && (verCmd = Bukkit.getServer().getCommandMap().getCommand("version")) != null) {
            return verCmd.execute(sender, commandLabel, new String[0]);
        }
        return true;
    }
}

