/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.entity;

import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.block.EntityBlockStorage;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.entity.Bee;
import org.bukkit.entity.EntityType;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.purpurmc.purpur.entity.StoredEntity;
import org.slf4j.Logger;

public class PurpurStoredBee
implements StoredEntity<Bee> {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private final EntityBlockStorage<Bee> blockStorage;
    private final TileEntityBeehive.HiveBee handle;
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private Component customName;

    public PurpurStoredBee(TileEntityBeehive.HiveBee data, EntityBlockStorage<Bee> blockStorage, TileEntityBeehive blockEntity) {
        this.handle = data;
        this.blockStorage = blockStorage;
        NBTTagCompound customData = this.handle.a.a().copyTagWithEntityId();
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(blockEntity.v(), LOGGER);){
            ValueInput valueInput = TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)IRegistryCustom.b, customData);
            IChatBaseComponent customNameMinecraft = TileEntity.a(valueInput, "CustomName");
            this.customName = customNameMinecraft == null ? null : PaperAdventure.asAdventure(customNameMinecraft);
            NBTBase nBTBase = customData.a("BukkitValues");
            if (nBTBase instanceof NBTTagCompound) {
                NBTTagCompound compoundTag = (NBTTagCompound)nBTBase;
                this.persistentDataContainer.putAll(compoundTag);
            }
        }
    }

    public TileEntityBeehive.HiveBee getHandle() {
        return this.handle;
    }

    @Nullable
    public Component customName() {
        return this.customName;
    }

    public void customName(@Nullable Component customName) {
        this.customName = customName;
    }

    @Nullable
    public String getCustomName() {
        return PaperAdventure.asPlain(this.customName, Locale.US);
    }

    public void setCustomName(@Nullable String name) {
        this.customName((Component)(name != null ? Component.text((String)name) : null));
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public boolean hasBeenReleased() {
        return !this.blockStorage.getEntities().contains(this);
    }

    @Nullable
    public Bee release() {
        return (Bee)this.blockStorage.releaseEntity((StoredEntity)this);
    }

    @Nullable
    public EntityBlockStorage<Bee> getBlockStorage() {
        if (this.hasBeenReleased()) {
            return null;
        }
        return this.blockStorage;
    }

    @NotNull
    public EntityType getType() {
        return EntityType.BEE;
    }

    public void update() {
        this.handle.a.a().copyTagWithEntityId().a("BukkitValues", this.persistentDataContainer.toTagCompound());
        if (this.customName == null) {
            this.handle.a.a().copyTagWithEntityId().r("CustomName");
        } else {
            this.handle.a.a().copyTagWithEntityId().a("CustomName", CraftChatMessage.toJSON(PaperAdventure.asVanilla(this.customName)));
        }
    }
}

