/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.gui;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.purpurmc.purpur.gui.GUIColor;

public class JColorTextPane
extends JTextPane {
    private static final GUIColor DEFAULT_COLOR = UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel") ? GUIColor.WHITE : GUIColor.BLACK;
    private static final Set<Blink> BLINKS = Sets.newHashSet();
    private static boolean SYNC_BLINK;

    public void append(String msg) {
        BaseComponent[] components;
        for (BaseComponent component : components = TextComponent.fromLegacyText((String)(DEFAULT_COLOR.getCode() + msg), (ChatColor)DEFAULT_COLOR.getChatColor())) {
            String text = component.toPlainText();
            if (text == null || text.isEmpty()) continue;
            GUIColor guiColor = GUIColor.getColor(component.getColor());
            StyleContext context = StyleContext.getDefaultStyleContext();
            AttributeSet attr = context.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, guiColor.getColor());
            attr = context.addAttribute(attr, StyleConstants.CharacterConstants.Bold, component.isBold() || guiColor != DEFAULT_COLOR);
            attr = context.addAttribute(attr, StyleConstants.CharacterConstants.Italic, component.isItalic());
            attr = context.addAttribute(attr, StyleConstants.CharacterConstants.Underline, component.isUnderlined());
            attr = context.addAttribute(attr, StyleConstants.CharacterConstants.StrikeThrough, component.isStrikethrough());
            try {
                int pos = this.getDocument().getLength();
                this.getDocument().insertString(pos, text, attr);
                if (!component.isObfuscated()) continue;
                Blink blink = new Blink(pos, text.length(), attr, context.addAttribute(attr, StyleConstants.Foreground, this.getBackground()));
                BLINKS.add(blink);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    static {
        new Timer(500, e2 -> {
            SYNC_BLINK = !SYNC_BLINK;
            BLINKS.forEach(Blink::blink);
        }).start();
    }

    public class Blink {
        private final int start;
        private final int length;
        private final AttributeSet attr1;
        private final AttributeSet attr2;

        private Blink(int start, int length, AttributeSet attr1, AttributeSet attr2) {
            this.start = start;
            this.length = length;
            this.attr1 = attr1;
            this.attr2 = attr2;
        }

        private void blink() {
            JColorTextPane.this.getStyledDocument().setCharacterAttributes(this.start, this.length, SYNC_BLINK ? this.attr1 : this.attr2, true);
        }
    }
}

