/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.task;

import io.netty.buffer.Unpooled;
import net.minecraft.core.IPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginBase;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import org.purpurmc.purpur.network.ClientboundBeehivePayload;
import org.purpurmc.purpur.network.ServerboundBeehivePayload;
import org.purpurmc.purpur.util.MinecraftInternalPlugin;

public class BeehiveTask
implements PluginMessageListener {
    private static BeehiveTask instance;
    private final PluginBase plugin = new MinecraftInternalPlugin();

    public static BeehiveTask instance() {
        if (instance == null) {
            instance = new BeehiveTask();
        }
        return instance;
    }

    private BeehiveTask() {
    }

    public void register() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, ClientboundBeehivePayload.TYPE.a().toString());
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, ServerboundBeehivePayload.TYPE.a().toString(), (PluginMessageListener)this);
    }

    public void unregister() {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)this.plugin, ClientboundBeehivePayload.TYPE.a().toString());
        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)this.plugin, ServerboundBeehivePayload.TYPE.a().toString());
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte[] bytes) {
        PacketDataSerializer byteBuf = new PacketDataSerializer(Unpooled.copiedBuffer((byte[])bytes));
        ServerboundBeehivePayload payload = (ServerboundBeehivePayload)ServerboundBeehivePayload.STREAM_CODEC.decode(byteBuf);
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        if (!payload.pos().b().a((IPosition)serverPlayer.dD(), 20.0)) {
            return;
        }
        if (serverPlayer.A().getChunkIfLoaded(payload.pos()) == null) {
            return;
        }
        TileEntity blockEntity = serverPlayer.A().c_(payload.pos());
        if (!(blockEntity instanceof TileEntityBeehive)) {
            return;
        }
        TileEntityBeehive beehive = (TileEntityBeehive)blockEntity;
        ClientboundBeehivePayload customPacketPayload = new ClientboundBeehivePayload(payload.pos(), beehive.f());
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
        ClientboundBeehivePayload.STREAM_CODEC.encode(friendlyByteBuf, customPacketPayload);
        byte[] byteArray = new byte[friendlyByteBuf.readableBytes()];
        friendlyByteBuf.b(byteArray);
        player.sendPluginMessage((Plugin)this.plugin, customPacketPayload.a().a().toString(), byteArray);
    }
}

