/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.events;

import java.time.LocalDate;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.milkteamc.autotreechop.AutoTreeChop;
import org.milkteamc.autotreechop.PlayerConfig;
import org.milkteamc.autotreechop.database.DatabaseManager;

public class PlayerJoinListener
implements Listener {
    private final AutoTreeChop plugin;

    public PlayerJoinListener(AutoTreeChop plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        ((CompletableFuture)this.plugin.getDatabaseManager().loadPlayerDataAsync(playerUUID, this.plugin.getPluginConfig().getDefaultTreeChop()).thenAccept(data -> {
            PlayerConfig playerConfig = new PlayerConfig(playerUUID, (DatabaseManager.PlayerData)data);
            this.plugin.getAllPlayerConfigs().put(playerUUID, playerConfig);
        })).exceptionally(ex -> {
            this.plugin.getLogger().warning("Failed to load data for player " + player.getName() + ": " + ex.getMessage());
            DatabaseManager.PlayerData defaultData = new DatabaseManager.PlayerData(playerUUID, this.plugin.getPluginConfig().getDefaultTreeChop(), 0, 0, LocalDate.now());
            this.plugin.getAllPlayerConfigs().put(playerUUID, new PlayerConfig(playerUUID, defaultData));
            return null;
        });
    }
}

