/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations;

import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.milkteamc.autotreechop.libs.tinytranslations.Message;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.Component;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.ComponentLike;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.JoinConfiguration;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.Context;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.ParsingException;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.internal.parser.node.TagNode;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.internal.parser.node.TagPart;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.internal.parser.node.TextNode;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.Modifying;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.Tag;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tree.Node;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.InsertedObject;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.TinyObjectMapping;
import org.milkteamc.autotreechop.libs.tinytranslations.util.ListSection;

public interface Formattable<ReturnT extends Formattable<ReturnT>> {
    public static final String[] LIST_PLACEHOLDERS = new String[]{"has-pages", "page", "pages", "next-page", "prev-page", "offset", "range"};
    public static final String[] DYNAMIC_LIST_PLACEHOLDERS = new String[]{"page", "next-page", "prev-page", "offset", "range"};

    public Collection<TagResolver> getResolvers();

    public ReturnT formatted(TagResolver ... var1);

    default public ReturnT insertParsed(@NotNull String key, String minimessage) {
        return this.formatted(Placeholder.parsed(key, minimessage));
    }

    default public ReturnT insertString(@NotNull String key, String value) {
        return this.formatted(Placeholder.unparsed(key, value));
    }

    default public ReturnT insertString(@NotNull String key, Supplier<String> value) {
        return this.formatted(new PlaceholderTag(key, () -> Component.text((String)value.get())));
    }

    default public ReturnT insertComponent(@NotNull String key, ComponentLike value) {
        return this.formatted(Placeholder.component(key, value));
    }

    default public ReturnT insertComponent(@NotNull String key, Supplier<ComponentLike> value) {
        return this.formatted(new PlaceholderTag(key, value));
    }

    default public ReturnT insertNumber(@NotNull String key, Number value) {
        return this.formatted(Formatter.number(key, value));
    }

    default public ReturnT insertNumber(final @NotNull String key, final Supplier<Number> value) {
        return this.formatted(TagResolver.resolver(key, new BiFunction<ArgumentQueue, Context, Tag>(){
            Number cached = null;

            @Override
            public Tag apply(ArgumentQueue argumentQueue, Context context) {
                if (this.cached == null) {
                    this.cached = (Number)value.get();
                }
                return Formatter.number(key, this.cached).resolve(key, argumentQueue, context);
            }
        }));
    }

    default public ReturnT insertTemporal(@NotNull String key, Temporal value) {
        return this.formatted(Formatter.date(key, value));
    }

    default public ReturnT insertBool(@NotNull String key, Boolean value) {
        return this.formatted(Placeholder.parsed(key, value.toString()));
    }

    default public ReturnT insertTag(@NotNull String key, Tag tag) {
        return this.formatted(TagResolver.resolver(key, tag));
    }

    default public ReturnT insertTag(@NotNull String key, @NotNull BiFunction<ArgumentQueue, Context, Tag> handler) {
        return this.formatted(TagResolver.resolver(key, handler));
    }

    public Map<String, InsertedObject> insertedObjects();

    default public <T> ReturnT insertObject(@NotNull String key, T obj) {
        return this.insertObject(key, obj, Collections.emptyList());
    }

    public <T> ReturnT insertObject(@NotNull String var1, T var2, Collection<TinyObjectMapping> var3);

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="5.0")
    default public <E> ReturnT insertList(@NotNull String key, List<E> elements, Function<E, ComponentLike> renderer) {
        return this.insertList(key, elements, ListSection.paged(0, elements.size()), renderer);
    }

    default public <E> ReturnT insertList(@NotNull String key, Collection<E> elements) {
        return this.insertList(key, elements, ListSection.paged(0, elements.size()));
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="5.0")
    default public <E> ReturnT insertList(@NotNull String key, List<E> elements, ListSection section, Function<E, ComponentLike> renderer) {
        return this.formatted(Formatter.choice("has-pages", section.getMaxPages(elements.size())), Formatter.number("page", section.getPage() + 1), Formatter.number("pages", section.getMaxPages(elements.size())), Formatter.number("next-page", Math.min(section.getMaxPages(elements.size()), section.getPage() + 2)), Formatter.number("prev-page", Math.max(1, section.getPage())), Formatter.number("offset", section.getOffset()), Formatter.number("range", section.getRange()), TagResolver.resolver(key, (argumentQueue, context) -> {
            String separator = argumentQueue.hasNext() ? argumentQueue.pop().value() : null;
            Component separatorParsed = separator == null ? Component.text(", ") : context.deserialize(separator);
            List sublist = section.apply(elements);
            Component content = Component.join(JoinConfiguration.separator(separatorParsed), (Iterable<? extends ComponentLike>)sublist.stream().map(renderer).collect(Collectors.toList()));
            return Tag.selfClosingInserting(content);
        }));
    }

    default public <E> ReturnT insertList(@NotNull String key, Collection<E> elements, ListSection section) {
        return this.insertList(key, elements, section, Collections.emptyList(), Collections.emptyList());
    }

    default public <E> ReturnT insertList(@NotNull String key, Collection<E> elements, ListSection section, final Collection<TagResolver> tagResolvers, Collection<TinyObjectMapping> objectResolvers) {
        return this.formatted(Formatter.choice("has-pages", section.getMaxPages(elements.size())), Formatter.number("page", section.getPage() + 1), Formatter.number("pages", section.getMaxPages(elements.size())), Formatter.number("next-page", Math.min(section.getMaxPages(elements.size()), section.getPage() + 2)), Formatter.number("prev-page", Math.max(1, section.getPage())), Formatter.number("offset", section.getOffset()), Formatter.number("range", section.getRange()), TagResolver.resolver(key, (argumentQueue, context) -> {
            String separator = argumentQueue.hasNext() ? argumentQueue.pop().value() : null;
            final Component separatorParsed = separator == null ? Component.text(", ") : context.deserialize(separator);
            final List sublist = section.apply(Formattable.formList(elements));
            final AtomicInteger index = new AtomicInteger(section.getOffset());
            final AtomicReference<String> format = new AtomicReference<String>("");
            return new Modifying(){

                @Override
                public void visit(@NotNull Node current, int depth) {
                    if (depth != 0) {
                        return;
                    }
                    if (current.children().isEmpty()) {
                        return;
                    }
                    format.set(Formattable.serializeChildren(current));
                }

                @Override
                public Component apply(@NotNull Component current, int depth) {
                    if (depth != 0) {
                        return Component.empty();
                    }
                    return Component.join(JoinConfiguration.separator(separatorParsed), sublist.stream().map(e -> (Message)((Message)((Message)((Message)Message.temporary((String)format.get()).insertObject("element", e)).insertObject("el", e)).insertNumber("index", index.incrementAndGet())).formatted((TagResolver[])tagResolvers.toArray(TagResolver[]::new))).toList());
                }
            };
        }));
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="5.0")
    default public <E> ReturnT insertList(@NotNull String key, Function<ListSection, List<E>> elementSupplier, ListSection section, Function<E, ComponentLike> renderer) {
        return this.formatted(Formatter.number("page", section.getPage() + 1), Formatter.number("next-page", section.getPage() + 2), Formatter.number("prev-page", Math.max(0, section.getPage())), Formatter.number("offset", section.getOffset()), Formatter.number("range", section.getRange()), TagResolver.resolver(key, (argumentQueue, context) -> {
            String separator = argumentQueue.hasNext() ? argumentQueue.pop().value() : null;
            Component separatorParsed = separator == null ? Component.text(", ") : context.deserialize(separator);
            AtomicInteger startIndex = new AtomicInteger(section.getOffset());
            List sublist = (List)elementSupplier.apply(section);
            Component content = Component.join(JoinConfiguration.separator(separatorParsed), (Iterable<? extends ComponentLike>)sublist.stream().map(renderer).map(componentLike -> {
                if (componentLike instanceof Message) {
                    Message m = (Message)componentLike;
                    return (ComponentLike)m.insertNumber("index", startIndex.incrementAndGet());
                }
                return componentLike;
            }).collect(Collectors.toList()));
            return Tag.selfClosingInserting(content);
        }));
    }

    default public <E> ReturnT insertList(@NotNull String key, Function<ListSection, Collection<E>> elementSupplier, ListSection section) {
        return this.insertList(key, elementSupplier, section, Collections.emptyList(), Collections.emptyList());
    }

    default public <E> ReturnT insertList(@NotNull String key, Function<ListSection, Collection<E>> elementSupplier, ListSection section, Collection<TinyObjectMapping> objectResolvers, final Collection<TagResolver> tagResolvers) {
        return this.formatted(Formatter.number("page", section.getPage() + 1), Formatter.number("next-page", section.getPage() + 2), Formatter.number("prev-page", Math.max(0, section.getPage())), Formatter.number("offset", section.getOffset()), Formatter.number("range", section.getRange()), TagResolver.resolver(key, (argumentQueue, context) -> {
            String separator = argumentQueue.hasNext() ? argumentQueue.pop().value() : null;
            final Component separatorParsed = separator == null ? Component.text(", ") : context.deserialize(separator);
            final AtomicInteger startIndex = new AtomicInteger(section.getOffset());
            final List sublist = Formattable.formList((Collection)elementSupplier.apply(section));
            final AtomicReference<String> format = new AtomicReference<String>("");
            return new Modifying(){

                @Override
                public void visit(@NotNull Node current, int depth) {
                    if (depth != 0) {
                        return;
                    }
                    if (current.children().isEmpty()) {
                        return;
                    }
                    format.set(Formattable.serializeChildren(current));
                }

                @Override
                public Component apply(@NotNull Component current, int depth) {
                    if (depth != 0) {
                        return Component.empty();
                    }
                    return Component.join(JoinConfiguration.separator(separatorParsed), sublist.stream().map(e -> (Message)((Message)((Message)((Message)Message.temporary((String)format.get()).insertObject("element", e)).insertObject("el", e)).insertNumber("index", startIndex.incrementAndGet())).formatted((TagResolver[])tagResolvers.toArray(TagResolver[]::new))).toList());
                }
            };
        }));
    }

    private static <E> List<E> formList(Collection<E> collection) {
        if (collection instanceof List) {
            List list = (List)collection;
            return list;
        }
        if (collection instanceof SortedSet) {
            SortedSet set = (SortedSet)collection;
            return new ArrayList(set);
        }
        ArrayList<Object> val = new ArrayList<Object>(collection);
        val.sort(Comparator.comparing(Object::toString));
        return val;
    }

    private static String serializeChildren(Node node) {
        return node.children().stream().map(Formattable::serialize).collect(Collectors.joining(""));
    }

    private static String serialize(Node node) {
        StringBuilder s = new StringBuilder();
        if (node instanceof TagNode) {
            TagNode t = (TagNode)node;
            s.append("<").append(t.name());
            for (TagPart part : t.parts().subList(1, t.parts().size())) {
                s.append(":'").append(part.value()).append("'");
            }
            s.append(">");
        } else if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            s.append(textNode.value());
        }
        for (Node node2 : node.children()) {
            s.append(Formattable.serialize(node2));
        }
        return s.toString();
    }

    public static class PlaceholderTag
    implements TagResolver {
        private final String key;
        private final Supplier<ComponentLike> supplier;
        private Tag tag;

        public PlaceholderTag(String key, ComponentLike value) {
            this.key = key;
            this.supplier = null;
            this.tag = Tag.inserting(value);
        }

        public PlaceholderTag(String key, Supplier<ComponentLike> value) {
            this.key = key;
            this.supplier = value;
        }

        @Override
        @Nullable
        public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
            if (this.tag == null) {
                this.tag = Tag.inserting(this.supplier.get());
            }
            return this.tag;
        }

        @Override
        public boolean has(@NotNull String name) {
            return name.equals(this.key);
        }
    }
}

