/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.libs.tinytranslations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.milkteamc.autotreechop.libs.tinytranslations.Message;
import org.milkteamc.autotreechop.libs.tinytranslations.MessageEncoding;
import org.milkteamc.autotreechop.libs.tinytranslations.TinyTranslations;
import org.milkteamc.autotreechop.libs.tinytranslations.TranslationKey;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.Component;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.ComponentLike;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.TranslatableComponent;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.TranslationArgument;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.format.Style;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.milkteamc.autotreechop.libs.tinytranslations.libs.kyori.adventure.translation.GlobalTranslator;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.InsertedObject;
import org.milkteamc.autotreechop.libs.tinytranslations.tinyobject.TinyObjectMapping;

class MessageImpl
implements Message {
    private final TranslationKey key;
    private final List<TranslationArgument> arguments = Collections.emptyList();
    private final Collection<TagResolver> resolvers = new LinkedList<TagResolver>();
    private Style style = Style.empty();
    private List<Component> children = new ArrayList<Component>();
    private Map<Locale, String> dictionary;
    private String fallback;
    private final Map<String, InsertedObject> insertedObjects = new HashMap<String, InsertedObject>();
    private Collection<Message.PlaceholderDescription> placeholderDescriptions;
    private String comment;

    public MessageImpl(TranslationKey key) {
        this(key, key.asTranslationKey());
    }

    public MessageImpl(TranslationKey key, String fallback) {
        this.key = key;
        this.dictionary = new ConcurrentHashMap<Locale, String>();
        this.dictionary.put(TinyTranslations.FALLBACK_DEFAULT_LOCALE, fallback);
        this.placeholderDescriptions = new LinkedList<Message.PlaceholderDescription>();
    }

    public MessageImpl(TranslationKey key, MessageImpl other) {
        this.key = key;
        this.style = other.style.color(other.style.color());
        this.children = other.children().stream().map(c -> c.children(c.children())).toList();
        this.dictionary = new HashMap<Locale, String>(other.dictionary);
        this.fallback = other.fallback;
        this.placeholderDescriptions = new LinkedList<Message.PlaceholderDescription>(other.placeholderDescriptions);
        this.comment = other.comment;
        this.resolvers.addAll(other.resolvers);
        this.insertedObjects.putAll(other.insertedObjects);
    }

    @Override
    public Map<String, InsertedObject> insertedObjects() {
        return this.insertedObjects;
    }

    public String toString() {
        return "Message{key=\"" + this.getKey().asNamespacedKey() + "\"}";
    }

    @Override
    public String toString(MessageEncoding format) {
        return format.format(GlobalTranslator.render(this.asComponent(), Locale.ENGLISH));
    }

    @Override
    public String toString(MessageEncoding format, Locale locale) {
        return this.toString(format);
    }

    @Override
    public Collection<TagResolver> getResolvers() {
        return List.copyOf(this.resolvers);
    }

    @Override
    public Message formatted(TagResolver ... resolver) {
        MessageImpl message = new MessageImpl(this.key, this);
        message.resolvers.addAll(List.of(resolver));
        return message;
    }

    @Override
    public <T> Message insertObject(@NotNull String key, T obj, Collection<TinyObjectMapping> resolvers) {
        MessageImpl message = new MessageImpl(this.key, this);
        message.insertedObjects.put(key, new InsertedObject(key, obj, resolvers));
        return message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageImpl message = (MessageImpl)o;
        return Objects.equals(this.key, message.key) && Objects.equals(this.arguments, message.arguments) && Objects.equals(this.style, message.style) && Objects.equals(this.children, message.children) && Objects.equals(this.dictionary, message.dictionary) && Objects.equals(this.fallback, message.fallback) && Objects.equals(this.placeholderDescriptions, message.placeholderDescriptions) && Objects.equals(this.comment, message.comment);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public Message clone() {
        return new MessageImpl(this.key, this);
    }

    @Override
    public int compareTo(@NotNull Message o) {
        return this.key().compareTo(o.key());
    }

    @Override
    @NotNull
    public String translationKey() {
        return this.key.asTranslationKey();
    }

    @Override
    @NotNull
    public String key() {
        return this.translationKey();
    }

    @Override
    @NotNull
    public TranslatableComponent key(@NotNull String key) {
        throw new IllegalArgumentException("Cannot change message key.");
    }

    @Override
    @NotNull
    public List<Component> args() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<TranslationArgument> arguments() {
        return this.arguments;
    }

    @Override
    @NotNull
    public TranslatableComponent arguments(ComponentLike ... args) {
        return new MessageImpl(this.key, this);
    }

    @Override
    @NotNull
    public TranslatableComponent arguments(@NotNull List<? extends ComponentLike> args) {
        return new MessageImpl(this.key, this);
    }

    @Override
    @Nullable
    public String fallback() {
        return this.fallback;
    }

    @Override
    @NotNull
    public TranslatableComponent fallback(@Nullable String fallback) {
        MessageImpl clone = new MessageImpl(this.key, this);
        clone.fallback = fallback;
        return clone;
    }

    @Override
    @NotNull
    public TranslatableComponent.Builder toBuilder() {
        return null;
    }

    @Override
    public @Unmodifiable @NotNull List<Component> children() {
        return new ArrayList<Component>(this.children);
    }

    @Override
    @NotNull
    public TranslatableComponent children(@NotNull List<? extends ComponentLike> children) {
        MessageImpl clone = new MessageImpl(this.key, this);
        clone.children = children.stream().map(ComponentLike::asComponent).toList();
        return clone;
    }

    @Override
    @NotNull
    public Style style() {
        return this.style;
    }

    @Override
    @NotNull
    public TranslatableComponent style(@NotNull Style style) {
        MessageImpl clone = new MessageImpl(this.key, this);
        clone.style = style;
        return clone;
    }

    @Override
    public Map<String, Optional<String>> getPlaceholderDescriptions() {
        HashMap<String, Optional<String>> var = new HashMap<String, Optional<String>>();
        this.placeholderDescriptions.forEach(placeholderDescription -> var.put(placeholderDescription.names()[0], Optional.ofNullable(placeholderDescription.description())));
        return var;
    }

    @Override
    public void setPlaceholderDescriptions(Map<String, Optional<String>> placeholderDescriptions) {
        placeholderDescriptions.forEach((s, s2) -> this.placeholderDescriptions.add(new Message.PlaceholderDescription(new String[]{s}, s2.orElse(null), Object.class)));
    }

    @Override
    public Message comment(@Nullable String comment) {
        MessageImpl clone = new MessageImpl(this.key, this);
        clone.comment = comment;
        return clone;
    }

    @Override
    @Nullable
    public String comment() {
        if (this.comment == null) {
            if (this.placeholderDescriptions.isEmpty()) {
                return null;
            }
            this.comment = "";
        }
        String[] splits = this.comment.split("(?<!\\\\)\n");
        for (Message.PlaceholderDescription d : this.placeholderDescriptions) {
            boolean match = false;
            for (String split : splits) {
                if (!split.startsWith("<" + Arrays.toString(d.names()))) continue;
                match = true;
                break;
            }
            if (match) continue;
            Object[] names = d.names();
            Object key = names.length == 1 ? names[0] : Arrays.toString(names);
            String type = d.type() == null ? "" : " (" + d.type().getSimpleName() + ")";
            String desc = d.description() == null || d.description().isEmpty() ? "" : ": " + d.description();
            this.comment = this.comment + "\n<" + (String)key + ">" + type + desc;
        }
        return this.comment;
    }

    @Override
    public Message dictionary(Map<Locale, String> dictionary) {
        MessageImpl clone = new MessageImpl(this.key, this);
        clone.dictionary.clear();
        clone.dictionary.putAll(dictionary);
        return clone;
    }

    @Override
    public Map<Locale, String> dictionary() {
        return Collections.unmodifiableMap(this.dictionary);
    }

    @Override
    public Message placeholderDescriptions(Collection<Message.PlaceholderDescription> descriptions) {
        MessageImpl clone = new MessageImpl(this.key, this);
        clone.placeholderDescriptions.clear();
        clone.placeholderDescriptions.addAll(descriptions);
        return clone;
    }

    @Override
    public Collection<Message.PlaceholderDescription> placeholderDescriptions() {
        return Collections.unmodifiableCollection(this.placeholderDescriptions);
    }

    public List<TranslationArgument> getArguments() {
        return this.arguments;
    }

    public Style getStyle() {
        return this.style;
    }

    public List<Component> getChildren() {
        return this.children;
    }

    @Override
    public Map<Locale, String> getDictionary() {
        return this.dictionary;
    }

    public String getFallback() {
        return this.fallback;
    }

    public Map<String, InsertedObject> getInsertedObjects() {
        return this.insertedObjects;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public void setChildren(List<Component> children) {
        this.children = children;
    }

    public void setDictionary(Map<Locale, String> dictionary) {
        this.dictionary = dictionary;
    }

    public void setFallback(String fallback) {
        this.fallback = fallback;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public TranslationKey getKey() {
        return this.key;
    }
}

