/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.tasks;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.scheduler.BukkitRunnable;
import org.milkteamc.autotreechop.AutoTreeChop;
import org.milkteamc.autotreechop.PlayerConfig;
import org.milkteamc.autotreechop.database.DatabaseManager;

public class PlayerDataSaveTask
extends BukkitRunnable {
    private final AutoTreeChop plugin;
    private final int saveThreshold;
    private int dirtyCount = 0;

    public PlayerDataSaveTask(AutoTreeChop plugin, int saveThreshold) {
        this.plugin = plugin;
        this.saveThreshold = saveThreshold;
    }

    public void run() {
        this.saveAllDirtyData();
    }

    public void checkThreshold() {
        this.dirtyCount = this.countDirtyData();
        if (this.dirtyCount >= this.saveThreshold) {
            this.saveAllDirtyData();
        }
    }

    private int countDirtyData() {
        int count = 0;
        for (PlayerConfig config : this.plugin.getAllPlayerConfigs().values()) {
            if (!config.isDirty()) continue;
            ++count;
        }
        return count;
    }

    private void saveAllDirtyData() {
        HashMap<UUID, DatabaseManager.PlayerData> dirtyDataMap = new HashMap<UUID, DatabaseManager.PlayerData>();
        for (Map.Entry<UUID, PlayerConfig> entry : this.plugin.getAllPlayerConfigs().entrySet()) {
            PlayerConfig config = entry.getValue();
            if (!config.isDirty()) continue;
            dirtyDataMap.put(entry.getKey(), config.getData());
            config.clearDirty();
        }
        if (!dirtyDataMap.isEmpty()) {
            ((CompletableFuture)this.plugin.getDatabaseManager().savePlayerDataBatchAsync(dirtyDataMap).thenRun(() -> {
                this.dirtyCount = 0;
            })).exceptionally(ex -> {
                this.plugin.getLogger().warning("Failed to save player data: " + ex.getMessage());
                for (UUID uuid : dirtyDataMap.keySet()) {
                    PlayerConfig config = this.plugin.getPlayerConfig(uuid);
                    if (config == null) continue;
                    config.markDirty();
                }
                return null;
            });
        }
    }
}

