/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.utils;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.milkteamc.autotreechop.AutoTreeChop;
import org.milkteamc.autotreechop.Config;

public class AsyncTaskScheduler {
    private final AutoTreeChop plugin;
    private final boolean isFolia;

    public AsyncTaskScheduler(AutoTreeChop plugin) {
        this.plugin = plugin;
        this.isFolia = AutoTreeChop.isFolia();
    }

    public void runTask(Location location, Runnable task) {
        if (this.isFolia) {
            this.plugin.getServer().getRegionScheduler().run((Plugin)this.plugin, location, scheduledTask -> task.run());
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, task);
        }
    }

    public void runTaskAsync(Config config, Runnable task) {
        if (config.isChopTreeAsync() && !this.isFolia) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, task);
        } else {
            task.run();
        }
    }

    public void runTaskLater(Location location, Runnable task, long delayTicks) {
        if (this.isFolia) {
            this.plugin.getServer().getRegionScheduler().runDelayed((Plugin)this.plugin, location, scheduledTask -> task.run(), delayTicks);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, task, delayTicks);
        }
    }

    public void scheduleDiscoveryAndValidation(Config config, Location location, Runnable discoveryTask, Runnable validationTask) {
        Runnable wrappedDiscovery = () -> {
            discoveryTask.run();
            this.runTask(location, validationTask);
        };
        this.runTaskAsync(config, wrappedDiscovery);
    }

    public void scheduleDelayed(Location location, Runnable task, long delayTicks) {
        this.runTaskLater(location, task, delayTicks);
    }

    public boolean isFolia() {
        return this.isFolia;
    }
}

