/*
 * Decompiled with CFR 0.152.
 */
package org.milkteamc.autotreechop.utils;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.milkteamc.autotreechop.AutoTreeChop;
import org.milkteamc.autotreechop.Config;

public class CooldownManager {
    private final HashMap<UUID, Long> cooldowns = new HashMap();
    private final AutoTreeChop plugin;

    public CooldownManager(AutoTreeChop plugin) {
        this.plugin = plugin;
    }

    public void setCooldown(Player player, UUID playerUUID, Config config) {
        if (player.hasPermission("autotreechop.vip")) {
            this.cooldowns.put(playerUUID, System.currentTimeMillis() + (long)config.getVipCooldownTime() * 1000L);
        } else {
            this.cooldowns.put(playerUUID, System.currentTimeMillis() + (long)config.getCooldownTime() * 1000L);
        }
    }

    public boolean isInCooldown(UUID playerUUID) {
        Long cooldownEnd = this.cooldowns.get(playerUUID);
        if (cooldownEnd == null) {
            return false;
        }
        return System.currentTimeMillis() < cooldownEnd;
    }

    public long getRemainingCooldown(UUID playerUUID) {
        Long cooldownEnd = this.cooldowns.get(playerUUID);
        if (cooldownEnd == null) {
            return 0L;
        }
        long remainingTime = cooldownEnd - System.currentTimeMillis();
        return Math.max(0L, remainingTime / 1000L);
    }
}

