/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.chunk;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.HelperBlockFlatteningV1450;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.HelperItemNameV102;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.datafix.PackedBitStorage;
import org.slf4j.Logger;

public final class ConverterFlattenChunk
extends DataConverter<MapType, MapType> {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final BitSet VIRTUAL_SET = new BitSet(256);
    static final BitSet IDS_NEEDING_FIX_SET = new BitSet(256);
    static final boolean[] VIRTUAL;
    static final boolean[] IDS_NEEDING_FIX;
    static final MapType PUMPKIN;
    static final MapType SNOWY_PODZOL;
    static final MapType SNOWY_GRASS;
    static final MapType SNOWY_MYCELIUM;
    static final MapType UPPER_SUNFLOWER;
    static final MapType UPPER_LILAC;
    static final MapType UPPER_TALL_GRASS;
    static final MapType UPPER_LARGE_FERN;
    static final MapType UPPER_ROSE_BUSH;
    static final MapType UPPER_PEONY;
    static final Map<String, MapType> FLOWER_POT_MAP;
    static final Map<String, MapType> SKULL_MAP;
    static final Map<String, MapType> DOOR_MAP;
    static final Map<String, MapType> NOTE_BLOCK_MAP;
    static final Int2ObjectOpenHashMap<String> DYE_COLOR_MAP;
    static final Map<String, MapType> BED_BLOCK_MAP;
    static final Map<String, MapType> BANNER_BLOCK_MAP;
    static final MapType AIR;

    private static boolean[] toBooleanArray(BitSet set) {
        boolean[] ret = new boolean[4096];
        for (int i = 0; i < 4096; ++i) {
            ret[i] = set.get(i);
        }
        return ret;
    }

    private static void mapSkull(Map<String, MapType> into, int oldId, String newId, String skullType) {
        into.put(oldId + "north", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + newId + "_wall_" + skullType + "',Properties:{facing:'north'}}"));
        into.put(oldId + "east", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + newId + "_wall_" + skullType + "',Properties:{facing:'east'}}"));
        into.put(oldId + "south", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + newId + "_wall_" + skullType + "',Properties:{facing:'south'}}"));
        into.put(oldId + "west", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + newId + "_wall_" + skullType + "',Properties:{facing:'west'}}"));
        for (int rotation = 0; rotation < 16; ++rotation) {
            into.put("" + oldId + rotation, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + newId + "_" + skullType + "',Properties:{rotation:'" + rotation + "'}}"));
        }
    }

    private static void mapDoor(Map<String, MapType> into, String type, int oldId) {
        into.put("minecraft:" + type + "eastlowerleftfalsefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        into.put("minecraft:" + type + "eastlowerleftfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "eastlowerlefttruefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        into.put("minecraft:" + type + "eastlowerlefttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'east',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "eastlowerrightfalsefalse", Objects.requireNonNull(HelperBlockFlatteningV1450.getNBTForId(oldId)));
        into.put("minecraft:" + type + "eastlowerrightfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'east',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "eastlowerrighttruefalse", Objects.requireNonNull(HelperBlockFlatteningV1450.getNBTForId(oldId + 4)));
        into.put("minecraft:" + type + "eastlowerrighttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'east',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "eastupperleftfalsefalse", Objects.requireNonNull(HelperBlockFlatteningV1450.getNBTForId(oldId + 8)));
        into.put("minecraft:" + type + "eastupperleftfalsetrue", Objects.requireNonNull(HelperBlockFlatteningV1450.getNBTForId(oldId + 10)));
        into.put("minecraft:" + type + "eastupperlefttruefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        into.put("minecraft:" + type + "eastupperlefttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'east',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "eastupperrightfalsefalse", Objects.requireNonNull(HelperBlockFlatteningV1450.getNBTForId(oldId + 9)));
        into.put("minecraft:" + type + "eastupperrightfalsetrue", Objects.requireNonNull(HelperBlockFlatteningV1450.getNBTForId(oldId + 11)));
        into.put("minecraft:" + type + "eastupperrighttruefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'east',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        into.put("minecraft:" + type + "eastupperrighttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'east',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "northlowerleftfalsefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        into.put("minecraft:" + type + "northlowerleftfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "northlowerlefttruefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        into.put("minecraft:" + type + "northlowerlefttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "northlowerrightfalsefalse", Objects.requireNonNull(HelperBlockFlatteningV1450.getNBTForId(oldId + 3)));
        into.put("minecraft:" + type + "northlowerrightfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "northlowerrighttruefalse", Objects.requireNonNull(HelperBlockFlatteningV1450.getNBTForId(oldId + 7)));
        into.put("minecraft:" + type + "northlowerrighttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "northupperleftfalsefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        into.put("minecraft:" + type + "northupperleftfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "northupperlefttruefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        into.put("minecraft:" + type + "northupperlefttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "northupperrightfalsefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        into.put("minecraft:" + type + "northupperrightfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "northupperrighttruefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        into.put("minecraft:" + type + "northupperrighttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'north',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "southlowerleftfalsefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        into.put("minecraft:" + type + "southlowerleftfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "southlowerlefttruefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        into.put("minecraft:" + type + "southlowerlefttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "southlowerrightfalsefalse", Objects.requireNonNull(HelperBlockFlatteningV1450.getNBTForId(oldId + 1)));
        into.put("minecraft:" + type + "southlowerrightfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "southlowerrighttruefalse", Objects.requireNonNull(HelperBlockFlatteningV1450.getNBTForId(oldId + 5)));
        into.put("minecraft:" + type + "southlowerrighttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "southupperleftfalsefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        into.put("minecraft:" + type + "southupperleftfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "southupperlefttruefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        into.put("minecraft:" + type + "southupperlefttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "southupperrightfalsefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        into.put("minecraft:" + type + "southupperrightfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "southupperrighttruefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        into.put("minecraft:" + type + "southupperrighttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'south',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "westlowerleftfalsefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'false',powered:'false'}}"));
        into.put("minecraft:" + type + "westlowerleftfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "westlowerlefttruefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'true',powered:'false'}}"));
        into.put("minecraft:" + type + "westlowerlefttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'lower',hinge:'left',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "westlowerrightfalsefalse", Objects.requireNonNull(HelperBlockFlatteningV1450.getNBTForId(oldId + 2)));
        into.put("minecraft:" + type + "westlowerrightfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'lower',hinge:'right',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "westlowerrighttruefalse", Objects.requireNonNull(HelperBlockFlatteningV1450.getNBTForId(oldId + 6)));
        into.put("minecraft:" + type + "westlowerrighttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'lower',hinge:'right',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "westupperleftfalsefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'false',powered:'false'}}"));
        into.put("minecraft:" + type + "westupperleftfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "westupperlefttruefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'false'}}"));
        into.put("minecraft:" + type + "westupperlefttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'upper',hinge:'left',open:'true',powered:'true'}}"));
        into.put("minecraft:" + type + "westupperrightfalsefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'false',powered:'false'}}"));
        into.put("minecraft:" + type + "westupperrightfalsetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'false',powered:'true'}}"));
        into.put("minecraft:" + type + "westupperrighttruefalse", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'true',powered:'false'}}"));
        into.put("minecraft:" + type + "westupperrighttruetrue", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + type + "',Properties:{facing:'west',half:'upper',hinge:'right',open:'true',powered:'true'}}"));
    }

    private static void addBeds(Map<String, MapType> into, int colourId, String colourName) {
        into.put("southfalsefoot" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_bed',Properties:{facing:'south',occupied:'false',part:'foot'}}"));
        into.put("westfalsefoot" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_bed',Properties:{facing:'west',occupied:'false',part:'foot'}}"));
        into.put("northfalsefoot" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_bed',Properties:{facing:'north',occupied:'false',part:'foot'}}"));
        into.put("eastfalsefoot" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_bed',Properties:{facing:'east',occupied:'false',part:'foot'}}"));
        into.put("southfalsehead" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_bed',Properties:{facing:'south',occupied:'false',part:'head'}}"));
        into.put("westfalsehead" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_bed',Properties:{facing:'west',occupied:'false',part:'head'}}"));
        into.put("northfalsehead" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_bed',Properties:{facing:'north',occupied:'false',part:'head'}}"));
        into.put("eastfalsehead" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_bed',Properties:{facing:'east',occupied:'false',part:'head'}}"));
        into.put("southtruehead" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_bed',Properties:{facing:'south',occupied:'true',part:'head'}}"));
        into.put("westtruehead" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_bed',Properties:{facing:'west',occupied:'true',part:'head'}}"));
        into.put("northtruehead" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_bed',Properties:{facing:'north',occupied:'true',part:'head'}}"));
        into.put("easttruehead" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_bed',Properties:{facing:'east',occupied:'true',part:'head'}}"));
    }

    private static void addBanners(Map<String, MapType> into, int colourId, String colourName) {
        for (int rotation = 0; rotation < 16; ++rotation) {
            into.put(rotation + "_" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_banner',Properties:{rotation:'" + rotation + "'}}"));
        }
        into.put("north_" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_wall_banner',Properties:{facing:'north'}}"));
        into.put("south_" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_wall_banner',Properties:{facing:'south'}}"));
        into.put("west_" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_wall_banner',Properties:{facing:'west'}}"));
        into.put("east_" + colourId, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:" + colourName + "_wall_banner',Properties:{facing:'east'}}"));
    }

    public ConverterFlattenChunk() {
        super(1451, 1);
    }

    static String getName(MapType blockState) {
        return blockState.getString("Name");
    }

    static String getProperty(MapType blockState, String propertyName) {
        MapType properties = blockState.getMap("Properties");
        if (properties == null) {
            return "";
        }
        return properties.getString(propertyName, "");
    }

    static int getSideMask(boolean noLeft, boolean noRight, boolean noBack, boolean noForward) {
        if (noBack) {
            if (noRight) {
                return 2;
            }
            if (noLeft) {
                return 128;
            }
            return 1;
        }
        if (noForward) {
            if (noLeft) {
                return 32;
            }
            if (noRight) {
                return 8;
            }
            return 16;
        }
        if (noRight) {
            return 4;
        }
        if (noLeft) {
            return 64;
        }
        return 0;
    }

    @Override
    public MapType convert(MapType data, long sourceVersion, long toVersion) {
        MapType level = data.getMap("Level");
        if (level == null) {
            return null;
        }
        if (!level.hasKey("Sections", ObjectType.LIST)) {
            return null;
        }
        data.setMap("Level", new UpgradeChunk(level).writeBackToLevel());
        return null;
    }

    static {
        IDS_NEEDING_FIX_SET.set(2);
        IDS_NEEDING_FIX_SET.set(3);
        IDS_NEEDING_FIX_SET.set(110);
        IDS_NEEDING_FIX_SET.set(140);
        IDS_NEEDING_FIX_SET.set(144);
        IDS_NEEDING_FIX_SET.set(25);
        IDS_NEEDING_FIX_SET.set(86);
        IDS_NEEDING_FIX_SET.set(26);
        IDS_NEEDING_FIX_SET.set(176);
        IDS_NEEDING_FIX_SET.set(177);
        IDS_NEEDING_FIX_SET.set(175);
        IDS_NEEDING_FIX_SET.set(64);
        IDS_NEEDING_FIX_SET.set(71);
        IDS_NEEDING_FIX_SET.set(193);
        IDS_NEEDING_FIX_SET.set(194);
        IDS_NEEDING_FIX_SET.set(195);
        IDS_NEEDING_FIX_SET.set(196);
        IDS_NEEDING_FIX_SET.set(197);
        VIRTUAL_SET.set(54);
        VIRTUAL_SET.set(146);
        VIRTUAL_SET.set(25);
        VIRTUAL_SET.set(26);
        VIRTUAL_SET.set(51);
        VIRTUAL_SET.set(53);
        VIRTUAL_SET.set(67);
        VIRTUAL_SET.set(108);
        VIRTUAL_SET.set(109);
        VIRTUAL_SET.set(114);
        VIRTUAL_SET.set(128);
        VIRTUAL_SET.set(134);
        VIRTUAL_SET.set(135);
        VIRTUAL_SET.set(136);
        VIRTUAL_SET.set(156);
        VIRTUAL_SET.set(163);
        VIRTUAL_SET.set(164);
        VIRTUAL_SET.set(180);
        VIRTUAL_SET.set(203);
        VIRTUAL_SET.set(55);
        VIRTUAL_SET.set(85);
        VIRTUAL_SET.set(113);
        VIRTUAL_SET.set(188);
        VIRTUAL_SET.set(189);
        VIRTUAL_SET.set(190);
        VIRTUAL_SET.set(191);
        VIRTUAL_SET.set(192);
        VIRTUAL_SET.set(93);
        VIRTUAL_SET.set(94);
        VIRTUAL_SET.set(101);
        VIRTUAL_SET.set(102);
        VIRTUAL_SET.set(160);
        VIRTUAL_SET.set(106);
        VIRTUAL_SET.set(107);
        VIRTUAL_SET.set(183);
        VIRTUAL_SET.set(184);
        VIRTUAL_SET.set(185);
        VIRTUAL_SET.set(186);
        VIRTUAL_SET.set(187);
        VIRTUAL_SET.set(132);
        VIRTUAL_SET.set(139);
        VIRTUAL_SET.set(199);
        VIRTUAL = ConverterFlattenChunk.toBooleanArray(VIRTUAL_SET);
        IDS_NEEDING_FIX = ConverterFlattenChunk.toBooleanArray(IDS_NEEDING_FIX_SET);
        PUMPKIN = HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:pumpkin'}");
        SNOWY_PODZOL = HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:podzol',Properties:{snowy:'true'}}");
        SNOWY_GRASS = HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:grass_block',Properties:{snowy:'true'}}");
        SNOWY_MYCELIUM = HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:mycelium',Properties:{snowy:'true'}}");
        UPPER_SUNFLOWER = HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:sunflower',Properties:{half:'upper'}}");
        UPPER_LILAC = HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:lilac',Properties:{half:'upper'}}");
        UPPER_TALL_GRASS = HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:tall_grass',Properties:{half:'upper'}}");
        UPPER_LARGE_FERN = HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:large_fern',Properties:{half:'upper'}}");
        UPPER_ROSE_BUSH = HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:rose_bush',Properties:{half:'upper'}}");
        UPPER_PEONY = HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:peony',Properties:{half:'upper'}}");
        FLOWER_POT_MAP = new HashMap<String, MapType>();
        FLOWER_POT_MAP.put("minecraft:air0", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:flower_pot'}"));
        FLOWER_POT_MAP.put("minecraft:red_flower0", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_poppy'}"));
        FLOWER_POT_MAP.put("minecraft:red_flower1", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_blue_orchid'}"));
        FLOWER_POT_MAP.put("minecraft:red_flower2", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_allium'}"));
        FLOWER_POT_MAP.put("minecraft:red_flower3", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_azure_bluet'}"));
        FLOWER_POT_MAP.put("minecraft:red_flower4", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_red_tulip'}"));
        FLOWER_POT_MAP.put("minecraft:red_flower5", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_orange_tulip'}"));
        FLOWER_POT_MAP.put("minecraft:red_flower6", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_white_tulip'}"));
        FLOWER_POT_MAP.put("minecraft:red_flower7", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_pink_tulip'}"));
        FLOWER_POT_MAP.put("minecraft:red_flower8", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_oxeye_daisy'}"));
        FLOWER_POT_MAP.put("minecraft:yellow_flower0", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_dandelion'}"));
        FLOWER_POT_MAP.put("minecraft:sapling0", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_oak_sapling'}"));
        FLOWER_POT_MAP.put("minecraft:sapling1", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_spruce_sapling'}"));
        FLOWER_POT_MAP.put("minecraft:sapling2", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_birch_sapling'}"));
        FLOWER_POT_MAP.put("minecraft:sapling3", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_jungle_sapling'}"));
        FLOWER_POT_MAP.put("minecraft:sapling4", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_acacia_sapling'}"));
        FLOWER_POT_MAP.put("minecraft:sapling5", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_dark_oak_sapling'}"));
        FLOWER_POT_MAP.put("minecraft:red_mushroom0", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_red_mushroom'}"));
        FLOWER_POT_MAP.put("minecraft:brown_mushroom0", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_brown_mushroom'}"));
        FLOWER_POT_MAP.put("minecraft:deadbush0", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_dead_bush'}"));
        FLOWER_POT_MAP.put("minecraft:tallgrass2", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_fern'}"));
        FLOWER_POT_MAP.put("minecraft:cactus0", HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:potted_cactus'}"));
        SKULL_MAP = new HashMap<String, MapType>();
        ConverterFlattenChunk.mapSkull(SKULL_MAP, 0, "skeleton", "skull");
        ConverterFlattenChunk.mapSkull(SKULL_MAP, 1, "wither_skeleton", "skull");
        ConverterFlattenChunk.mapSkull(SKULL_MAP, 2, "zombie", "head");
        ConverterFlattenChunk.mapSkull(SKULL_MAP, 3, "player", "head");
        ConverterFlattenChunk.mapSkull(SKULL_MAP, 4, "creeper", "head");
        ConverterFlattenChunk.mapSkull(SKULL_MAP, 5, "dragon", "head");
        DOOR_MAP = new HashMap<String, MapType>();
        ConverterFlattenChunk.mapDoor(DOOR_MAP, "oak_door", 1024);
        ConverterFlattenChunk.mapDoor(DOOR_MAP, "iron_door", 1136);
        ConverterFlattenChunk.mapDoor(DOOR_MAP, "spruce_door", 3088);
        ConverterFlattenChunk.mapDoor(DOOR_MAP, "birch_door", 3104);
        ConverterFlattenChunk.mapDoor(DOOR_MAP, "jungle_door", 3120);
        ConverterFlattenChunk.mapDoor(DOOR_MAP, "acacia_door", 3136);
        ConverterFlattenChunk.mapDoor(DOOR_MAP, "dark_oak_door", 3152);
        NOTE_BLOCK_MAP = new HashMap<String, MapType>();
        for (int note = 0; note < 26; ++note) {
            NOTE_BLOCK_MAP.put("true" + note, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:note_block',Properties:{powered:'true',note:'" + note + "'}}"));
            NOTE_BLOCK_MAP.put("false" + note, HelperBlockFlatteningV1450.parseTag("{Name:'minecraft:note_block',Properties:{powered:'false',note:'" + note + "'}}"));
        }
        DYE_COLOR_MAP = new Int2ObjectOpenHashMap();
        DYE_COLOR_MAP.put(0, (Object)"white");
        DYE_COLOR_MAP.put(1, (Object)"orange");
        DYE_COLOR_MAP.put(2, (Object)"magenta");
        DYE_COLOR_MAP.put(3, (Object)"light_blue");
        DYE_COLOR_MAP.put(4, (Object)"yellow");
        DYE_COLOR_MAP.put(5, (Object)"lime");
        DYE_COLOR_MAP.put(6, (Object)"pink");
        DYE_COLOR_MAP.put(7, (Object)"gray");
        DYE_COLOR_MAP.put(8, (Object)"light_gray");
        DYE_COLOR_MAP.put(9, (Object)"cyan");
        DYE_COLOR_MAP.put(10, (Object)"purple");
        DYE_COLOR_MAP.put(11, (Object)"blue");
        DYE_COLOR_MAP.put(12, (Object)"brown");
        DYE_COLOR_MAP.put(13, (Object)"green");
        DYE_COLOR_MAP.put(14, (Object)"red");
        DYE_COLOR_MAP.put(15, (Object)"black");
        BED_BLOCK_MAP = new HashMap<String, MapType>();
        for (Int2ObjectMap.Entry entry : DYE_COLOR_MAP.int2ObjectEntrySet()) {
            if (Objects.equals(entry.getValue(), "red")) continue;
            ConverterFlattenChunk.addBeds(BED_BLOCK_MAP, entry.getIntKey(), (String)entry.getValue());
        }
        BANNER_BLOCK_MAP = new HashMap<String, MapType>();
        for (Int2ObjectMap.Entry entry : DYE_COLOR_MAP.int2ObjectEntrySet()) {
            if (Objects.equals(entry.getValue(), "white")) continue;
            ConverterFlattenChunk.addBanners(BANNER_BLOCK_MAP, 15 - entry.getIntKey(), (String)entry.getValue());
        }
        AIR = Objects.requireNonNull(HelperBlockFlatteningV1450.getNBTForId(0));
    }

    static final class UpgradeChunk {
        int sides;
        final Section[] sections = new Section[16];
        final MapType level;
        final int blockX;
        final int blockZ;
        final Int2ObjectLinkedOpenHashMap<MapType> tileEntities = new Int2ObjectLinkedOpenHashMap(16);

        public UpgradeChunk(MapType level) {
            this.level = level;
            this.blockX = level.getInt("xPos") << 4;
            this.blockZ = level.getInt("zPos") << 4;
            ListType tileEntities = level.getList("TileEntities", ObjectType.MAP);
            if (tileEntities != null) {
                int len = tileEntities.size();
                for (int i = 0; i < len; ++i) {
                    int z;
                    MapType tileEntity = tileEntities.getMap(i);
                    int x = tileEntity.getInt("x") - this.blockX & 0xF;
                    int y = tileEntity.getInt("y");
                    int index = y << 8 | (z = tileEntity.getInt("z") - this.blockZ & 0xF) << 4 | x;
                    if (this.tileEntities.put(index, (Object)tileEntity) == null) continue;
                    LOGGER.warn("In chunk: {}x{} found a duplicate block entity at position (ConverterFlattenChunk): [{}, {}, {}]", new Object[]{this.blockX, this.blockZ, x, y, z});
                }
            }
            boolean convertedFromAlphaFormat = level.getBoolean("convertedFromAlphaFormat");
            ListType sections = level.getList("Sections", ObjectType.MAP);
            if (sections != null) {
                int len = sections.size();
                for (int i = 0; i < len; ++i) {
                    MapType sectionData = sections.getMap(i);
                    Section section = new Section(sectionData);
                    if (section.y < 0 || section.y > 15) {
                        LOGGER.warn("In chunk: {}x{} found an invalid chunk section y (ConverterFlattenChunk): {}", new Object[]{this.blockX, this.blockZ, section.y});
                        continue;
                    }
                    if (this.sections[section.y] != null) {
                        LOGGER.warn("In chunk: {}x{} found a duplicate chunk section (ConverterFlattenChunk): {}", new Object[]{this.blockX, this.blockZ, section.y});
                    }
                    this.sides = section.upgrade(this.sides);
                    this.sections[section.y] = section;
                }
            }
            for (Section section : this.sections) {
                if (section == null) continue;
                int yIndex = section.y << 12;
                ObjectBidirectionalIterator iterator = section.toFix.int2ObjectEntrySet().fastIterator();
                while (iterator.hasNext()) {
                    Int2ObjectMap.Entry fixEntry = (Int2ObjectMap.Entry)iterator.next();
                    IntListIterator positionIterator = ((IntArrayList)fixEntry.getValue()).iterator();
                    switch (fixEntry.getIntKey()) {
                        case 2: {
                            MapType blockState;
                            int position;
                            while (positionIterator.hasNext()) {
                                String blockAbove;
                                position = positionIterator.nextInt() | yIndex;
                                blockState = this.getBlock(position);
                                if (!"minecraft:grass_block".equals(ConverterFlattenChunk.getName(blockState)) || !"minecraft:snow".equals(blockAbove = ConverterFlattenChunk.getName(this.getBlock(UpgradeChunk.relative(position, Direction.UP)))) && !"minecraft:snow_layer".equals(blockAbove)) continue;
                                this.setBlock(position, SNOWY_GRASS);
                            }
                            break;
                        }
                        case 3: {
                            MapType blockState;
                            int position;
                            while (positionIterator.hasNext()) {
                                String blockAbove;
                                position = positionIterator.nextInt() | yIndex;
                                blockState = this.getBlock(position);
                                if (!"minecraft:podzol".equals(ConverterFlattenChunk.getName(blockState)) || !"minecraft:snow".equals(blockAbove = ConverterFlattenChunk.getName(this.getBlock(UpgradeChunk.relative(position, Direction.UP)))) && !"minecraft:snow_layer".equals(blockAbove)) continue;
                                this.setBlock(position, SNOWY_PODZOL);
                            }
                            break;
                        }
                        case 25: {
                            MapType tile;
                            int position;
                            while (positionIterator.hasNext()) {
                                position = positionIterator.nextInt() | yIndex;
                                tile = this.removeBlockEntity(position);
                                if (tile == null) continue;
                                String state = Boolean.toString(tile.getBoolean("powered")) + (byte)Math.min(Math.max(tile.getInt("note"), 0), 24);
                                this.setBlock(position, NOTE_BLOCK_MAP.getOrDefault(state, NOTE_BLOCK_MAP.get("false0")));
                            }
                            break;
                        }
                        case 26: {
                            Object state;
                            MapType tile;
                            int position;
                            while (positionIterator.hasNext()) {
                                MapType update;
                                position = positionIterator.nextInt() | yIndex;
                                tile = this.getBlockEntity(position);
                                if (tile == null) continue;
                                MapType blockState = this.getBlock(position);
                                int colour = tile.getInt("color");
                                if (colour == 14 || colour < 0 || colour >= 16 || (update = BED_BLOCK_MAP.get(state = ConverterFlattenChunk.getProperty(blockState, "facing") + ConverterFlattenChunk.getProperty(blockState, "occupied") + ConverterFlattenChunk.getProperty(blockState, "part") + colour)) == null) continue;
                                this.setBlock(position, update);
                            }
                            break;
                        }
                        case 64: 
                        case 71: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: {
                            MapType blockState;
                            int position;
                            while (positionIterator.hasNext()) {
                                position = positionIterator.nextInt() | yIndex;
                                blockState = this.getBlock(position);
                                if (!ConverterFlattenChunk.getName(blockState).endsWith("_door") || !"lower".equals(ConverterFlattenChunk.getProperty(blockState, "half"))) continue;
                                int positionAbove = UpgradeChunk.relative(position, Direction.UP);
                                MapType blockStateAbove = this.getBlock(positionAbove);
                                String name = ConverterFlattenChunk.getName(blockState);
                                if (!name.equals(ConverterFlattenChunk.getName(blockStateAbove))) continue;
                                String facingBelow = ConverterFlattenChunk.getProperty(blockState, "facing");
                                String openBelow = ConverterFlattenChunk.getProperty(blockState, "open");
                                String hingeAbove = convertedFromAlphaFormat ? "left" : ConverterFlattenChunk.getProperty(blockStateAbove, "hinge");
                                String poweredAbove = convertedFromAlphaFormat ? "false" : ConverterFlattenChunk.getProperty(blockStateAbove, "powered");
                                this.setBlock(position, DOOR_MAP.get(name + facingBelow + "lower" + hingeAbove + openBelow + poweredAbove));
                                this.setBlock(positionAbove, DOOR_MAP.get(name + facingBelow + "upper" + hingeAbove + openBelow + poweredAbove));
                            }
                            break;
                        }
                        case 86: {
                            MapType blockState;
                            int position;
                            while (positionIterator.hasNext()) {
                                String downName;
                                position = positionIterator.nextInt() | yIndex;
                                blockState = this.getBlock(position);
                                if (!"minecraft:carved_pumpkin".equals(ConverterFlattenChunk.getName(blockState)) || !"minecraft:grass_block".equals(downName = ConverterFlattenChunk.getName(this.getBlock(UpgradeChunk.relative(position, Direction.DOWN)))) && !"minecraft:dirt".equals(downName)) continue;
                                this.setBlock(position, PUMPKIN);
                            }
                            break;
                        }
                        case 110: {
                            MapType blockState;
                            int position;
                            while (positionIterator.hasNext()) {
                                String nameAbove;
                                position = positionIterator.nextInt() | yIndex;
                                blockState = this.getBlock(position);
                                if (!"minecraft:mycelium".equals(ConverterFlattenChunk.getName(blockState)) || !"minecraft:snow".equals(nameAbove = ConverterFlattenChunk.getName(this.getBlock(UpgradeChunk.relative(position, Direction.UP)))) && !"minecraft:snow_layer".equals(nameAbove)) continue;
                                this.setBlock(position, SNOWY_MYCELIUM);
                            }
                            break;
                        }
                        case 140: {
                            MapType tile;
                            int position;
                            while (positionIterator.hasNext()) {
                                position = positionIterator.nextInt() | yIndex;
                                tile = this.removeBlockEntity(position);
                                if (tile == null) continue;
                                String item = tile.hasKey("Item", ObjectType.NUMBER) ? HelperItemNameV102.getNameFromId(tile.getInt("Item")) : tile.getString("Item", "");
                                String state = item + tile.getInt("Data");
                                this.setBlock(position, FLOWER_POT_MAP.getOrDefault(state, FLOWER_POT_MAP.get("minecraft:air0")));
                            }
                            break;
                        }
                        case 144: {
                            Object state;
                            MapType tile;
                            int position;
                            while (positionIterator.hasNext()) {
                                position = positionIterator.nextInt() | yIndex;
                                tile = this.getBlockEntity(position);
                                if (tile == null) continue;
                                String typeString = Integer.toString(tile.getInt("SkullType"));
                                String facing = ConverterFlattenChunk.getProperty(this.getBlock(position), "facing");
                                state = !"up".equals(facing) && !"down".equals(facing) ? typeString + facing : typeString + tile.getInt("Rot");
                                tile.remove("SkullType");
                                tile.remove("facing");
                                tile.remove("Rot");
                                this.setBlock(position, SKULL_MAP.getOrDefault(state, SKULL_MAP.get("0north")));
                            }
                            break;
                        }
                        case 175: {
                            MapType blockState;
                            int position;
                            while (positionIterator.hasNext()) {
                                position = positionIterator.nextInt() | yIndex;
                                blockState = this.getBlock(position);
                                if (!"upper".equals(ConverterFlattenChunk.getProperty(blockState, "half"))) continue;
                                MapType blockStateBelow = this.getBlock(UpgradeChunk.relative(position, Direction.DOWN));
                                String nameBelow = ConverterFlattenChunk.getName(blockStateBelow);
                                switch (nameBelow) {
                                    case "minecraft:sunflower": {
                                        this.setBlock(position, UPPER_SUNFLOWER);
                                        break;
                                    }
                                    case "minecraft:lilac": {
                                        this.setBlock(position, UPPER_LILAC);
                                        break;
                                    }
                                    case "minecraft:tall_grass": {
                                        this.setBlock(position, UPPER_TALL_GRASS);
                                        break;
                                    }
                                    case "minecraft:large_fern": {
                                        this.setBlock(position, UPPER_LARGE_FERN);
                                        break;
                                    }
                                    case "minecraft:rose_bush": {
                                        this.setBlock(position, UPPER_ROSE_BUSH);
                                        break;
                                    }
                                    case "minecraft:peony": {
                                        this.setBlock(position, UPPER_PEONY);
                                    }
                                }
                            }
                            break;
                        }
                        case 176: 
                        case 177: {
                            Object state;
                            MapType tile;
                            int position;
                            while (positionIterator.hasNext()) {
                                MapType update;
                                position = positionIterator.nextInt() | yIndex;
                                tile = this.getBlockEntity(position);
                                if (tile == null) continue;
                                MapType blockState = this.getBlock(position);
                                int base = tile.getInt("Base");
                                if (base == 15 || base < 0 || base >= 16 || (update = BANNER_BLOCK_MAP.get(state = ConverterFlattenChunk.getProperty(blockState, fixEntry.getIntKey() == 176 ? "rotation" : "facing") + "_" + base)) == null) continue;
                                this.setBlock(position, update);
                            }
                            break;
                        }
                    }
                }
            }
        }

        private MapType getBlockEntity(int index) {
            return (MapType)this.tileEntities.get(index);
        }

        private MapType removeBlockEntity(int index) {
            return (MapType)this.tileEntities.remove(index);
        }

        public static int relative(int index, Direction direction) {
            switch (direction.getAxis().ordinal()) {
                case 0: {
                    int j = (index & 0xF) + direction.getAxisDirection().getStep();
                    return j >= 0 && j <= 15 ? index & 0xFFFFFFF0 | j : -1;
                }
                case 1: {
                    int k = (index >> 8) + direction.getAxisDirection().getStep();
                    return k >= 0 && k <= 255 ? index & 0xFF | k << 8 : -1;
                }
                case 2: {
                    int l = (index >> 4 & 0xF) + direction.getAxisDirection().getStep();
                    return l >= 0 && l <= 15 ? index & 0xFFFFFF0F | l << 4 : -1;
                }
            }
            return -1;
        }

        private void setBlock(int index, MapType blockState) {
            Section section;
            if (index >= 0 && index <= 65535 && (section = this.getSection(index)) != null) {
                section.setBlock(index & 0xFFF, blockState);
            }
        }

        private Section getSection(int index) {
            int y = index >> 12;
            return y < this.sections.length ? this.sections[y] : null;
        }

        public MapType getBlock(int i) {
            if (i >= 0 && i <= 65535) {
                Section section = this.getSection(i);
                return section == null ? AIR : section.getBlock(i & 0xFFF);
            }
            return AIR;
        }

        public MapType writeBackToLevel() {
            if (this.tileEntities.isEmpty()) {
                this.level.remove("TileEntities");
            } else {
                ListType tileEntities = Types.NBT.createEmptyList();
                this.tileEntities.values().forEach(tileEntities::addMap);
                this.level.setList("TileEntities", tileEntities);
            }
            MapType indices = Types.NBT.createEmptyMap();
            ListType sections = Types.NBT.createEmptyList();
            for (Section section : this.sections) {
                if (section == null) continue;
                sections.addMap(section.writeBackToSection());
                indices.setInts(Integer.toString(section.y), Arrays.copyOf(section.update.elements(), section.update.size()));
            }
            this.level.setList("Sections", sections);
            MapType upgradeData = Types.NBT.createEmptyMap();
            upgradeData.setByte("Sides", (byte)this.sides);
            upgradeData.setMap("Indices", indices);
            this.level.setMap("UpgradeData", upgradeData);
            return this.level;
        }
    }

    static class Section {
        final Palette palette = new Palette();
        final MapType section;
        final boolean hasData;
        final Int2ObjectLinkedOpenHashMap<IntArrayList> toFix = new Int2ObjectLinkedOpenHashMap();
        final IntArrayList update = new IntArrayList();
        final int y;
        final int[] buffer = new int[4096];

        public Section(MapType section) {
            this.section = section;
            this.y = section.getInt("Y");
            this.hasData = section.hasKey("Blocks", ObjectType.BYTE_ARRAY);
        }

        public MapType getBlock(int index) {
            if (index >= 0 && index <= 4095) {
                MapType state = this.palette.byId[this.buffer[index]];
                return state == null ? AIR : state;
            }
            return AIR;
        }

        public void setBlock(int index, MapType blockState) {
            this.buffer[index] = this.palette.getOrCreateId(blockState);
        }

        public int upgrade(int sides) {
            if (!this.hasData) {
                return sides;
            }
            byte[] blocks = this.section.getBytes("Blocks");
            DataLayer data = DataLayer.getOrNull(this.section.getBytes("Data"));
            DataLayer add = DataLayer.getOrNull(this.section.getBytes("Add"));
            this.palette.getOrCreateId(AIR);
            for (int index = 0; index < 4096; ++index) {
                int x = index & 0xF;
                int z = index >> 4 & 0xF;
                int blockStateId = (blocks[index] & 0xFF) << 4;
                if (data != null) {
                    blockStateId |= data.get(index);
                }
                if (add != null) {
                    blockStateId |= add.get(index) << 12;
                }
                if (IDS_NEEDING_FIX[blockStateId >>> 4]) {
                    this.addFix(blockStateId >>> 4, index);
                }
                if (VIRTUAL[blockStateId >>> 4]) {
                    int additionalSides = ConverterFlattenChunk.getSideMask(x == 0, x == 15, z == 0, z == 15);
                    if (additionalSides == 0) {
                        this.update.add(index);
                    } else {
                        sides |= additionalSides;
                    }
                }
                this.setBlock(index, HelperBlockFlatteningV1450.getNBTForId(blockStateId));
            }
            return sides;
        }

        private void addFix(int block, int index) {
            ((IntArrayList)this.toFix.computeIfAbsent(block, keyInMap -> new IntArrayList())).add(index);
        }

        public MapType writeBackToSection() {
            if (!this.hasData) {
                return this.section;
            }
            this.section.setList("Palette", this.palette.paletteStates.copy());
            int bitSize = Math.max(4, DataFixUtils.ceillog2((int)this.palette.size()));
            PackedBitStorage packedIds = new PackedBitStorage(bitSize, 4096);
            for (int index = 0; index < this.buffer.length; ++index) {
                packedIds.set(index, this.buffer[index]);
            }
            this.section.setLongs("BlockStates", packedIds.getRaw());
            this.section.remove("Blocks");
            this.section.remove("Data");
            this.section.remove("Add");
            return this.section;
        }

        static final class Palette
        extends Reference2IntOpenHashMap<MapType> {
            final ListType paletteStates = Types.NBT.createEmptyList();
            private MapType[] byId = new MapType[4];
            private MapType last = null;

            Palette() {
            }

            private int find(MapType k) {
                if (k == null) {
                    return this.containsNullKey ? this.n : -(this.n + 1);
                }
                Object[] key = this.key;
                int pos = HashCommon.mix((int)System.identityHashCode(k)) & this.mask;
                MapType curr = (MapType)key[pos];
                if (curr == null) {
                    return -(pos + 1);
                }
                if (k == curr) {
                    return pos;
                }
                do {
                    if ((curr = (MapType)key[pos = pos + 1 & this.mask]) != null) continue;
                    return -(pos + 1);
                } while (k != curr);
                return pos;
            }

            private void insert(int pos, MapType k, int v) {
                if (pos == this.n) {
                    this.containsNullKey = true;
                }
                this.key[pos] = k;
                this.value[pos] = v;
                if (this.size++ >= this.maxFill) {
                    this.rehash(HashCommon.arraySize((int)(this.size + 1), (float)this.f));
                }
            }

            public int getOrCreateId(MapType k) {
                if (k == this.last) {
                    return this.size - 1;
                }
                int pos = this.find(k);
                if (pos >= 0) {
                    return this.value[pos];
                }
                int insert = this.size;
                MapType inPalette = k;
                if ("%%FILTER_ME%%".equals(ConverterFlattenChunk.getName(k))) {
                    inPalette = AIR;
                }
                if (insert >= this.byId.length) {
                    this.byId = Arrays.copyOf(this.byId, this.byId.length * 2);
                    this.byId[insert] = k;
                } else {
                    this.byId[insert] = k;
                }
                this.paletteStates.addMap(inPalette);
                this.last = k;
                this.insert(-pos - 1, k, insert);
                return insert;
            }
        }
    }

    static class DataLayer {
        private final byte[] data;

        public DataLayer() {
            this.data = new byte[2048];
        }

        public DataLayer(byte[] data) {
            this.data = data;
            if (data.length != 2048) {
                throw new IllegalArgumentException("ChunkNibbleArrays should be 2048 bytes not: " + data.length);
            }
        }

        public static DataLayer getOrNull(byte[] data) {
            return data == null ? null : new DataLayer(data);
        }

        public static DataLayer getOrCreate(byte[] data) {
            return data == null ? new DataLayer() : new DataLayer(data);
        }

        public int get(int index) {
            byte value = this.data[index >>> 1];
            return value >>> ((index & 1) << 2) & 0xF;
        }

        public int get(int x, int y, int z) {
            int index = y << 8 | z << 4 | x;
            byte value = this.data[index >>> 1];
            return value >>> ((index & 1) << 2) & 0xF;
        }
    }

    static enum Direction {
        DOWN(AxisDirection.NEGATIVE, Axis.Y),
        UP(AxisDirection.POSITIVE, Axis.Y),
        NORTH(AxisDirection.NEGATIVE, Axis.Z),
        SOUTH(AxisDirection.POSITIVE, Axis.Z),
        WEST(AxisDirection.NEGATIVE, Axis.X),
        EAST(AxisDirection.POSITIVE, Axis.X);

        private final Axis axis;
        private final AxisDirection axisDirection;

        private Direction(AxisDirection axisDirection, Axis axis) {
            this.axis = axis;
            this.axisDirection = axisDirection;
        }

        public AxisDirection getAxisDirection() {
            return this.axisDirection;
        }

        public Axis getAxis() {
            return this.axis;
        }

        public static enum Axis {
            X,
            Y,
            Z;

        }

        public static enum AxisDirection {
            POSITIVE(1),
            NEGATIVE(-1);

            private final int step;

            private AxisDirection(int step) {
                this.step = step;
            }

            public int getStep() {
                return this.step;
            }
        }
    }
}

