/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.helpers;

import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class CopyHelper {
    public static boolean copy(MapType src, String srcPath, MapType dst, String dstPath) {
        Object val = src.getGeneric(srcPath);
        if (val == null) {
            dst.remove(dstPath);
            return false;
        }
        dst.setGeneric(dstPath, CopyHelper.copyGeneric(val));
        return true;
    }

    public static boolean move(MapType src, String srcPath, MapType dst, String dstPath) {
        Object val = src.getGeneric(srcPath);
        src.remove(srcPath);
        if (val == null) {
            dst.remove(dstPath);
            return false;
        }
        dst.setGeneric(dstPath, val);
        return true;
    }

    public static Number sanitizeNumber(Number input) {
        Number number = input;
        Objects.requireNonNull(number);
        Number number2 = number;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class}, (Object)number2, n)) {
            case 0 -> {
                Byte b;
                yield b = (Byte)number2;
            }
            case 1 -> {
                Short s = (Short)number2;
                yield s;
            }
            case 2 -> {
                Integer i = (Integer)number2;
                yield i;
            }
            case 3 -> {
                Long l = (Long)number2;
                yield l;
            }
            case 4 -> {
                Float f = (Float)number2;
                yield f;
            }
            case 5 -> {
                Double d = (Double)number2;
                yield d;
            }
            default -> null;
        };
    }

    public static Object copyGeneric(Object value) {
        if (value == null || value instanceof String || value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (CopyHelper.sanitizeNumber(number) == null) {
                throw new IllegalArgumentException("Unknown type: " + String.valueOf(value.getClass()));
            }
            return number;
        }
        if (value instanceof MapType) {
            MapType mapType = (MapType)value;
            return mapType.copy();
        }
        if (value instanceof ListType) {
            ListType listType = (ListType)value;
            return listType.copy();
        }
        if (value.getClass().isArray()) {
            if (value instanceof byte[]) {
                byte[] bytes = (byte[])value;
                return bytes.clone();
            }
            if (value instanceof short[]) {
                short[] shorts = (short[])value;
                return shorts.clone();
            }
            if (value instanceof int[]) {
                int[] ints = (int[])value;
                return ints.clone();
            }
            if (value instanceof long[]) {
                long[] longs = (long[])value;
                return longs.clone();
            }
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(value.getClass()));
    }
}

