/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.datatypes;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.converters.datatypes.DataHook;
import ca.spottedleaf.dataconverter.converters.datatypes.DataType;
import ca.spottedleaf.dataconverter.converters.datatypes.DataWalker;
import ca.spottedleaf.dataconverter.minecraft.MCVersionRegistry;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.util.Long2ObjectArraySortedMap;
import java.util.ArrayList;
import java.util.List;

public class MCDataType
extends DataType<MapType, MapType> {
    public final String name;
    protected final ArrayList<DataConverter<MapType, MapType>> structureConverters = new ArrayList();
    protected final Long2ObjectArraySortedMap<List<DataWalker<MapType>>> structureWalkers = new Long2ObjectArraySortedMap();
    protected final Long2ObjectArraySortedMap<List<DataHook<MapType, MapType>>> structureHooks = new Long2ObjectArraySortedMap();

    public MCDataType(String name) {
        this.name = name;
    }

    public void addStructureConverter(DataConverter<MapType, MapType> converter) {
        MCVersionRegistry.checkVersion(converter.getEncodedVersion());
        boolean sort = !this.structureConverters.isEmpty() && DataConverter.LOWEST_VERSION_COMPARATOR.compare(this.structureConverters.getLast(), converter) > 0;
        this.structureConverters.add(converter);
        if (sort) {
            this.structureConverters.sort(DataConverter.LOWEST_VERSION_COMPARATOR);
        }
    }

    public void addStructureWalker(int minVersion, DataWalker<MapType> walker) {
        this.addStructureWalker(minVersion, 0, walker);
    }

    public void addStructureWalker(int minVersion, int versionStep, DataWalker<MapType> walker) {
        this.structureWalkers.computeIfAbsent(DataConverter.encodeVersions(minVersion, versionStep), keyInMap -> new ArrayList()).add(walker);
    }

    public void addStructureHook(int minVersion, DataHook<MapType, MapType> hook) {
        this.addStructureHook(minVersion, 0, hook);
    }

    public void addStructureHook(int minVersion, int versionStep, DataHook<MapType, MapType> hook) {
        this.structureHooks.computeIfAbsent(DataConverter.encodeVersions(minVersion, versionStep), keyInMap -> new ArrayList()).add(hook);
    }

    @Override
    public MapType convert(MapType data, long fromVersion, long toVersion) {
        List<DataWalker<MapType>> walkers;
        List<DataHook<MapType, MapType>> hooks;
        MapType ret = null;
        ArrayList<DataConverter<MapType, MapType>> converters = this.structureConverters;
        int len = converters.size();
        for (int i = 0; i < len; ++i) {
            MapType replace;
            int klen;
            DataConverter converter = (DataConverter)converters.get(i);
            long converterVersion = converter.getEncodedVersion();
            if (converterVersion <= fromVersion) continue;
            if (converterVersion > toVersion) break;
            List<DataHook<MapType, MapType>> hooks2 = this.structureHooks.getFloor(converterVersion);
            if (hooks2 != null) {
                klen = hooks2.size();
                for (int k = 0; k < klen; ++k) {
                    MapType replace2 = hooks2.get(k).preHook(data, fromVersion, toVersion);
                    if (replace2 == null) continue;
                    ret = data = replace2;
                }
            }
            if ((replace = (MapType)converter.convert(data, fromVersion, toVersion)) != null) {
                ret = data = replace;
            }
            if ((hooks2 = this.structureHooks.getFloor(toVersion)) == null) continue;
            klen = hooks2.size();
            for (int k = klen - 1; k >= 0; --k) {
                MapType postReplace = hooks2.get(k).postHook(data, fromVersion, toVersion);
                if (postReplace == null) continue;
                ret = data = postReplace;
            }
        }
        if ((hooks = this.structureHooks.getFloor(toVersion)) != null) {
            int klen = hooks.size();
            for (int k = 0; k < klen; ++k) {
                MapType replace = hooks.get(k).preHook(data, fromVersion, toVersion);
                if (replace == null) continue;
                ret = data = replace;
            }
        }
        if ((walkers = this.structureWalkers.getFloor(toVersion)) != null) {
            int len2 = walkers.size();
            for (int i = 0; i < len2; ++i) {
                MapType replace = walkers.get(i).walk(data, fromVersion, toVersion);
                if (replace == null) continue;
                ret = data = replace;
            }
        }
        if (hooks != null) {
            int klen = hooks.size();
            for (int k = klen - 1; k >= 0; --k) {
                MapType postReplace = hooks.get(k).postHook(data, fromVersion, toVersion);
                if (postReplace == null) continue;
                ret = data = postReplace;
            }
        }
        return ret;
    }
}

