/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.blockname.ConverterAbstractBlockRename;
import ca.spottedleaf.dataconverter.minecraft.converters.itemname.ConverterAbstractItemRename;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.versions.V1458;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.DataWalkerTypePaths;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;

public final class V1488 {
    private static final int VERSION = 1488;

    private static boolean isIglooPiece(MapType piece) {
        return "Iglu".equals(piece.getString("id"));
    }

    public static void register() {
        ConverterAbstractBlockRename.register(1488, new HashMap(ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant"))::get);
        ConverterAbstractItemRename.register(1488, new HashMap(ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp"))::get);
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:command_block", new DataConverter<MapType, MapType>(1488){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                return V1458.updateCustomName(data);
            }
        });
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:commandblock_minecart", new DataConverter<MapType, MapType>(1488){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                return V1458.updateCustomName(data);
            }
        });
        MCTypeRegistry.STRUCTURE_FEATURE.addStructureConverter(new DataConverter<MapType, MapType>(1488){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                int i;
                boolean isIgloo;
                ListType children = data.getList("Children", ObjectType.MAP);
                if (children != null) {
                    isIgloo = true;
                    int len = children.size();
                    for (i = 0; i < len; ++i) {
                        if (V1488.isIglooPiece(children.getMap(i))) continue;
                        isIgloo = false;
                        break;
                    }
                } else {
                    isIgloo = false;
                }
                if (isIgloo) {
                    data.remove("Children");
                    data.setString("id", "Igloo");
                    return null;
                }
                if (children != null) {
                    i = 0;
                    while (i < children.size()) {
                        MapType child = children.getMap(i);
                        if (V1488.isIglooPiece(child)) {
                            children.remove(i);
                            continue;
                        }
                        ++i;
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.TILE_ENTITY.addWalker(1488, "minecraft:command_block", new DataWalkerTypePaths<Object, Object>(MCTypeRegistry.DATACONVERTER_CUSTOM_TYPE_COMMAND, "Command"));
        MCTypeRegistry.TILE_ENTITY.addWalker(1488, "minecraft:command_block", new DataWalkerTypePaths<Object, Object>(MCTypeRegistry.TEXT_COMPONENT, "CustomName", "LastOutput"));
    }

    private V1488() {
    }
}

