/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public final class V1494 {
    private static final int VERSION = 1494;
    private static final Int2ObjectOpenHashMap<String> ENCH_ID_TO_NAME = new Int2ObjectOpenHashMap();

    public static void register() {
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType, MapType>(1494){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                ListType storedEnchants;
                MapType tag = data.getMap("tag");
                if (tag == null) {
                    return null;
                }
                ListType enchants = tag.getList("ench", ObjectType.MAP);
                if (enchants != null) {
                    tag.remove("ench");
                    tag.setList("Enchantments", enchants);
                    int len = enchants.size();
                    for (int i = 0; i < len; ++i) {
                        MapType enchant = enchants.getMap(i);
                        enchant.setString("id", (String)ENCH_ID_TO_NAME.getOrDefault(enchant.getInt("id"), (Object)"null"));
                    }
                }
                if ((storedEnchants = tag.getList("StoredEnchantments", ObjectType.MAP)) != null) {
                    int len = storedEnchants.size();
                    for (int i = 0; i < len; ++i) {
                        MapType enchant = storedEnchants.getMap(i);
                        enchant.setString("id", (String)ENCH_ID_TO_NAME.getOrDefault(enchant.getInt("id"), (Object)"null"));
                    }
                }
                return null;
            }
        });
    }

    private V1494() {
    }

    static {
        ENCH_ID_TO_NAME.put(0, (Object)"minecraft:protection");
        ENCH_ID_TO_NAME.put(1, (Object)"minecraft:fire_protection");
        ENCH_ID_TO_NAME.put(2, (Object)"minecraft:feather_falling");
        ENCH_ID_TO_NAME.put(3, (Object)"minecraft:blast_protection");
        ENCH_ID_TO_NAME.put(4, (Object)"minecraft:projectile_protection");
        ENCH_ID_TO_NAME.put(5, (Object)"minecraft:respiration");
        ENCH_ID_TO_NAME.put(6, (Object)"minecraft:aqua_affinity");
        ENCH_ID_TO_NAME.put(7, (Object)"minecraft:thorns");
        ENCH_ID_TO_NAME.put(8, (Object)"minecraft:depth_strider");
        ENCH_ID_TO_NAME.put(9, (Object)"minecraft:frost_walker");
        ENCH_ID_TO_NAME.put(10, (Object)"minecraft:binding_curse");
        ENCH_ID_TO_NAME.put(16, (Object)"minecraft:sharpness");
        ENCH_ID_TO_NAME.put(17, (Object)"minecraft:smite");
        ENCH_ID_TO_NAME.put(18, (Object)"minecraft:bane_of_arthropods");
        ENCH_ID_TO_NAME.put(19, (Object)"minecraft:knockback");
        ENCH_ID_TO_NAME.put(20, (Object)"minecraft:fire_aspect");
        ENCH_ID_TO_NAME.put(21, (Object)"minecraft:looting");
        ENCH_ID_TO_NAME.put(22, (Object)"minecraft:sweeping");
        ENCH_ID_TO_NAME.put(32, (Object)"minecraft:efficiency");
        ENCH_ID_TO_NAME.put(33, (Object)"minecraft:silk_touch");
        ENCH_ID_TO_NAME.put(34, (Object)"minecraft:unbreaking");
        ENCH_ID_TO_NAME.put(35, (Object)"minecraft:fortune");
        ENCH_ID_TO_NAME.put(48, (Object)"minecraft:power");
        ENCH_ID_TO_NAME.put(49, (Object)"minecraft:punch");
        ENCH_ID_TO_NAME.put(50, (Object)"minecraft:flame");
        ENCH_ID_TO_NAME.put(51, (Object)"minecraft:infinity");
        ENCH_ID_TO_NAME.put(61, (Object)"minecraft:luck_of_the_sea");
        ENCH_ID_TO_NAME.put(62, (Object)"minecraft:lure");
        ENCH_ID_TO_NAME.put(65, (Object)"minecraft:loyalty");
        ENCH_ID_TO_NAME.put(66, (Object)"minecraft:impaling");
        ENCH_ID_TO_NAME.put(67, (Object)"minecraft:riptide");
        ENCH_ID_TO_NAME.put(68, (Object)"minecraft:channeling");
        ENCH_ID_TO_NAME.put(70, (Object)"minecraft:mending");
        ENCH_ID_TO_NAME.put(71, (Object)"minecraft:vanishing_curse");
    }
}

