/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.Types;

public final class V2501 {
    private static final int VERSION = 2501;

    private static void registerFurnace(String id) {
        MCTypeRegistry.TILE_ENTITY.addWalker(2501, id, (data, fromVersion, toVersion) -> {
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, data, "Items", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, data, "CustomName", fromVersion, toVersion);
            WalkerUtils.convertKeys(MCTypeRegistry.RECIPE, data, "RecipesUsed", fromVersion, toVersion);
            return null;
        });
    }

    public static void register() {
        DataConverter<MapType, MapType> converter = new DataConverter<MapType, MapType>(2501){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                int recipesUsedSize = data.getInt("RecipesUsedSize");
                data.remove("RecipesUsedSize");
                if (recipesUsedSize <= 0) {
                    return null;
                }
                MapType newRecipes = Types.NBT.createEmptyMap();
                data.setMap("RecipesUsed", newRecipes);
                for (int i = 0; i < recipesUsedSize; ++i) {
                    String recipeKey = data.getString("RecipeLocation" + i);
                    data.remove("RecipeLocation" + i);
                    int recipeAmount = data.getInt("RecipeAmount" + i);
                    data.remove("RecipeAmount" + i);
                    if (i <= 0 || recipeKey == null) continue;
                    newRecipes.setInt(recipeKey, recipeAmount);
                }
                return null;
            }
        };
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:furnace", converter);
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:blast_furnace", converter);
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:smoker", converter);
        V2501.registerFurnace("minecraft:furnace");
        V2501.registerFurnace("minecraft:smoker");
        V2501.registerFurnace("minecraft:blast_furnace");
    }

    private V2501() {
    }
}

