/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.ConverterAbstractStringValueTypeRename;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;
import java.util.HashMap;
import java.util.Map;

public final class V2843 {
    private static final int VERSION = 2843;

    public static void register() {
        ConverterAbstractStringValueTypeRename.register(2843, MCTypeRegistry.BIOME, new HashMap<String, String>(Map.of("minecraft:deep_warm_ocean", "minecraft:warm_ocean"))::get);
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType, MapType>(2843){

            private static void moveOutOfBoundTicks(ListType ticks, MapType chunkRoot, int chunkX, int chunkZ, String intoKey) {
                if (ticks == null) {
                    return;
                }
                ListType outOfBounds = null;
                int len = ticks.size();
                for (int i = 0; i < len; ++i) {
                    MapType tick = ticks.getMap(i);
                    int x = tick.getInt("x");
                    int z = tick.getInt("z");
                    if (Math.max(Math.abs(chunkX - (x >> 4)), Math.abs(chunkZ - (z >> 4))) != 1) continue;
                    if (outOfBounds == null) {
                        outOfBounds = Types.NBT.createEmptyList();
                    }
                    outOfBounds.addMap(tick.copy());
                }
                if (outOfBounds != null) {
                    MapType upgradeData = chunkRoot.getMap("UpgradeData");
                    if (upgradeData == null) {
                        upgradeData = Types.NBT.createEmptyMap();
                        chunkRoot.setMap("UpgradeData", upgradeData);
                    }
                    upgradeData.setList(intoKey, outOfBounds);
                }
            }

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                int x = data.getInt("xPos");
                int z = data.getInt("zPos");
                1.moveOutOfBoundTicks(data.getList("block_ticks", ObjectType.MAP), data, x, z, "neighbor_block_ticks");
                1.moveOutOfBoundTicks(data.getList("fluid_ticks", ObjectType.MAP), data, x, z, "neighbor_fluid_ticks");
                return null;
            }
        });
        MCTypeRegistry.CHUNK.addStructureWalker(2843, (data, fromVersion, toVersion) -> {
            WalkerUtils.convertList(MCTypeRegistry.ENTITY, data, "entities", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.TILE_ENTITY, data, "block_entities", fromVersion, toVersion);
            WalkerUtils.convertListPath(MCTypeRegistry.BLOCK_NAME, data, "block_ticks", "i", fromVersion, toVersion);
            WalkerUtils.convertListPath(MCTypeRegistry.BLOCK_NAME, data.getMap("UpgradeData"), "neighbor_block_ticks", "i", fromVersion, toVersion);
            ListType sections = data.getListUnchecked("sections");
            if (sections != null) {
                int len = sections.size();
                for (int i = 0; i < len; ++i) {
                    MapType section = sections.getMap(i, null);
                    if (section == null) continue;
                    WalkerUtils.convertList(MCTypeRegistry.BIOME, section.getMap("biomes"), "palette", fromVersion, toVersion);
                    WalkerUtils.convertList(MCTypeRegistry.BLOCK_STATE, section.getMap("block_states"), "palette", fromVersion, toVersion);
                }
            }
            WalkerUtils.convertValues(MCTypeRegistry.STRUCTURE_FEATURE, data.getMap("structures"), "starts", fromVersion, toVersion);
            return null;
        });
    }

    private V2843() {
    }
}

