/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.itemstack.ConverterItemStackToDataComponents;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.DataWalkerTypePaths;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V3820 {
    private static final int VERSION = 3820;

    public static void register() {
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:skull", new DataConverter<MapType, MapType>(3820){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                Object skullOwner = data.getGeneric("SkullOwner");
                Object extraType = data.getGeneric("ExtraType");
                if (skullOwner == null && extraType == null) {
                    return null;
                }
                data.remove("SkullOwner");
                data.remove("ExtraType");
                data.setMap("profile", ConverterItemStackToDataComponents.convertProfile(skullOwner == null ? extraType : skullOwner, data.getTypeUtil()));
                return null;
            }
        });
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType, MapType>(3820){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType components = data.getMap("components");
                if (components == null) {
                    return null;
                }
                MapType oldTarget = components.getMap("minecraft:lodestone_target");
                if (oldTarget == null) {
                    return null;
                }
                components.remove("minecraft:lodestone_target");
                components.setMap("minecraft:lodestone_tracker", oldTarget);
                Object pos = oldTarget.getGeneric("pos");
                Object dim = oldTarget.getGeneric("dimension");
                if (pos == null || dim == null) {
                    return null;
                }
                oldTarget.remove("pos");
                oldTarget.remove("dimension");
                MapType target = oldTarget.getTypeUtil().createEmptyMap();
                oldTarget.setMap("target", target);
                target.setGeneric("pos", pos);
                target.setGeneric("dimension", dim);
                return null;
            }
        });
        MCTypeRegistry.TILE_ENTITY.addWalker(3820, "minecraft:skull", new DataWalkerTypePaths<Object, Object>(MCTypeRegistry.TEXT_COMPONENT, "custom_name"));
    }

    private V3820() {
    }
}

