/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.util.ComponentUtils;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItems;
import ca.spottedleaf.dataconverter.types.MapType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class V3825 {
    private static final int VERSION = 3825;
    private static final Set<String> BANNER_NAMES = new HashSet<String>(Arrays.asList("block.minecraft.ominous_banner"));
    private static final Set<String> MAP_NAMES = new HashSet<String>(Arrays.asList("filled_map.buried_treasure", "filled_map.explorer_jungle", "filled_map.explorer_swamp", "filled_map.mansion", "filled_map.monument", "filled_map.trial_chambers", "filled_map.village_desert", "filled_map.village_plains", "filled_map.village_savanna", "filled_map.village_snowy", "filled_map.village_taiga"));

    public static void register() {
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType, MapType>(3825){

            private static void convertName(MapType components, Set<String> standardNames) {
                String customName = components.getString("minecraft:custom_name");
                if (customName == null) {
                    return;
                }
                String translation = ComponentUtils.retrieveTranslationString(customName);
                if (translation == null) {
                    return;
                }
                if (standardNames.contains(translation)) {
                    components.remove("minecraft:custom_name");
                    components.setString("minecraft:item_name", customName);
                }
            }

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType components = data.getMap("components");
                if (components == null) {
                    return null;
                }
                String id = data.getString("id");
                if (id == null) {
                    return null;
                }
                switch (id) {
                    case "minecraft:white_banner": {
                        1.convertName(components, BANNER_NAMES);
                        break;
                    }
                    case "minecraft:filled_map": {
                        1.convertName(components, MAP_NAMES);
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:banner", new DataConverter<MapType, MapType>(3825){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                String customName = data.getString("CustomName");
                if (customName == null || !"block.minecraft.ominous_banner".equals(ComponentUtils.retrieveTranslationString(customName))) {
                    return null;
                }
                data.remove("CustomName");
                MapType components = data.getOrCreateMap("components");
                components.setString("minecraft:item_name", customName);
                components.setMap("minecraft:hide_additional_tooltip", components.getTypeUtil().createEmptyMap());
                return null;
            }
        });
        MCTypeRegistry.TILE_ENTITY.addWalker(3825, "minecraft:trial_spawner", (data, fromVersion, toVersion) -> {
            MapType ominousConfig;
            MapType normalConfig = data.getMap("normal_config");
            if (normalConfig != null) {
                WalkerUtils.convertListPath(MCTypeRegistry.ENTITY, normalConfig, "spawn_potentials", "data", "entity", fromVersion, toVersion);
            }
            if ((ominousConfig = data.getMap("ominous_config")) != null) {
                WalkerUtils.convertListPath(MCTypeRegistry.ENTITY, ominousConfig, "spawn_potentials", "data", "entity", fromVersion, toVersion);
            }
            WalkerUtils.convert(MCTypeRegistry.ENTITY, data.getMap("spawn_data"), "entity", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:trial_spawner", new DataConverter<MapType, MapType>(3825){
            private static final String[] NORMAL_CONFIG_KEYS = new String[]{"spawn_range", "total_mobs", "simultaneous_mobs", "total_mobs_added_per_player", "simultaneous_mobs_added_per_player", "ticks_between_spawn", "spawn_potentials", "loot_tables_to_eject", "items_to_drop_when_ominous"};

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType normalConfig = data.getTypeUtil().createEmptyMap();
                for (String normalKey : NORMAL_CONFIG_KEYS) {
                    Object normalValue = data.getGeneric(normalKey);
                    if (normalValue == null) continue;
                    data.remove(normalKey);
                    normalConfig.setGeneric(normalKey, normalValue);
                }
                if (!normalConfig.isEmpty()) {
                    data.setMap("normal_config", normalConfig);
                }
                return null;
            }
        });
        MCTypeRegistry.ENTITY.addWalker(3825, "minecraft:ominous_item_spawner", new DataWalkerItems("item"));
    }

    private V3825() {
    }
}

