/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.minecraft.converters.attributes.ConverterAbstractAttributesRename;
import ca.spottedleaf.dataconverter.util.NamespaceUtil;

public final class V4055 {
    private static final int VERSION = 4055;
    private static final Prefix[] PREFIXES_TO_REMOVE = new Prefix[]{new Prefix("generic."), new Prefix("horse."), new Prefix("player."), new Prefix("zombie.")};

    public static void register() {
        ConverterAbstractAttributesRename.register(4055, input -> {
            String namespacedInput = NamespaceUtil.correctNamespace(input);
            for (Prefix prefix : PREFIXES_TO_REMOVE) {
                if (!namespacedInput.startsWith(prefix.namespaced())) continue;
                return "minecraft:".concat(namespacedInput.substring(prefix.namespaced().length()));
            }
            return null;
        });
    }

    private V4055() {
    }

    private record Prefix(String raw, String namespaced) {
        public Prefix(String raw) {
            this(raw, NamespaceUtil.correctNamespace(raw));
        }
    }
}

