/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import ca.spottedleaf.dataconverter.types.Types;
import ca.spottedleaf.dataconverter.types.nbt.NBTMapType;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.nbt.TagParser;
import org.slf4j.Logger;

public final class V4290 {
    public static final int VERSION = 4290;
    private static final Logger LOGGER = LogUtils.getLogger();

    private static void convertNestedList(ListType components) {
        if (components == null) {
            return;
        }
        int len = components.size();
        for (int i = 0; i < len; ++i) {
            V4290.convertNested(components.getGeneric(i));
        }
    }

    private static void convertNested(Object component) {
        if (component instanceof ListType) {
            ListType listType = (ListType)component;
            V4290.convertNestedList(listType);
        } else if (component instanceof MapType) {
            MapType root = (MapType)component;
            V4290.convertLegacyHover(root);
            V4290.convertNestedList(root.getListUnchecked("extra"));
            V4290.convertNested(root.getGeneric("separator"));
            MapType hoverEvent = root.getMap("hoverEvent");
            if (hoverEvent != null) {
                switch (hoverEvent.getString("action", "")) {
                    case "show_text": {
                        V4290.convertNested(hoverEvent.getGeneric("contents"));
                        break;
                    }
                    case "show_item": {
                        break;
                    }
                    case "show_entity": {
                        V4290.convertNested(hoverEvent.getGeneric("name"));
                    }
                }
            }
        }
    }

    private static void convertLegacyHover(MapType textComponent) {
        TypeUtil<?> typeUtil = textComponent.getTypeUtil();
        MapType hoverEvent = textComponent.getMap("hoverEvent");
        if (hoverEvent == null) {
            return;
        }
        Object legacyValue = hoverEvent.getGeneric("value");
        if (legacyValue == null) {
            return;
        }
        switch (hoverEvent.getString("action", "")) {
            case "show_text": {
                hoverEvent.remove("value");
                hoverEvent.setGeneric("contents", legacyValue);
                break;
            }
            case "show_item": {
                NBTMapType legacyItem;
                hoverEvent.remove("value");
                if (!(legacyValue instanceof String)) {
                    LOGGER.error("Legacy HoverEvent with action=show_item has invalid value, expected string: " + String.valueOf(legacyValue));
                    break;
                }
                String legacyItemStr = (String)legacyValue;
                try {
                    legacyItem = new NBTMapType(TagParser.parseCompoundFully(legacyItemStr));
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to parse SNBT for legacy item HoverEvent: " + legacyItemStr, (Throwable)ex);
                    break;
                }
                hoverEvent.setMap("contents", legacyItem);
                break;
            }
            case "show_entity": {
                String id;
                String type;
                NBTMapType legacyEntity;
                hoverEvent.remove("value");
                if (!(legacyValue instanceof String)) {
                    LOGGER.error("Legacy HoverEvent with action=show_entity has invalid value, expected string: " + String.valueOf(legacyValue));
                    break;
                }
                String legacyEntityStr = (String)legacyValue;
                try {
                    legacyEntity = new NBTMapType(TagParser.parseCompoundFully(legacyEntityStr));
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to parse SNBT for legacy entity HoverEvent: " + legacyEntityStr, (Throwable)ex);
                    break;
                }
                MapType newContents = typeUtil.createEmptyMap();
                hoverEvent.setMap("contents", newContents);
                String name = legacyEntity.getString("name");
                if (name != null) {
                    newContents.setString("name", name);
                }
                if ((type = legacyEntity.getString("type")) != null) {
                    newContents.setString("type", type);
                }
                if ((id = legacyEntity.getString("id")) == null) break;
                newContents.setString("id", id);
                break;
            }
        }
    }

    private static void directWalkComponentList(ListType list, long fromVersion, long toVersion) {
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            V4290.directWalkComponent(list.getGeneric(i), fromVersion, toVersion);
        }
    }

    private static void directWalkComponent(Object input, long fromVersion, long toVersion) {
        if (input instanceof ListType) {
            ListType listType = (ListType)input;
            V4290.directWalkComponentList(listType, fromVersion, toVersion);
        } else if (input instanceof MapType) {
            MapType hoverEvent;
            MapType clickEvent;
            Object separator;
            MapType root = (MapType)input;
            ListType extra = root.getListUnchecked("extra");
            if (extra != null) {
                V4290.directWalkComponentList(extra, fromVersion, toVersion);
            }
            if ((separator = root.getGeneric("separator")) != null) {
                V4290.directWalkComponent(separator, fromVersion, toVersion);
            }
            if ((clickEvent = root.getMap("clickEvent")) != null) {
                switch (clickEvent.getString("action", "")) {
                    case "run_command": 
                    case "suggest_command": {
                        WalkerUtils.convert(MCTypeRegistry.DATACONVERTER_CUSTOM_TYPE_COMMAND, clickEvent, "value", fromVersion, toVersion);
                    }
                }
            }
            if ((hoverEvent = root.getMap("hoverEvent")) != null) {
                switch (hoverEvent.getString("action", "")) {
                    case "show_text": {
                        Object contents = hoverEvent.getGeneric("contents");
                        if (contents == null) break;
                        V4290.directWalkComponent(contents, fromVersion, toVersion);
                        break;
                    }
                    case "show_item": {
                        if (hoverEvent.hasKey("contents", ObjectType.STRING)) {
                            WalkerUtils.convert(MCTypeRegistry.ITEM_NAME, hoverEvent, "contents", fromVersion, toVersion);
                            break;
                        }
                        WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, hoverEvent, "contents", fromVersion, toVersion);
                        break;
                    }
                    case "show_entity": {
                        WalkerUtils.convert(MCTypeRegistry.ENTITY_NAME, hoverEvent, "type", fromVersion, toVersion);
                        Object name = hoverEvent.getGeneric("name");
                        if (name == null) break;
                        V4290.directWalkComponent(name, fromVersion, toVersion);
                        break;
                    }
                }
            }
        }
    }

    public static void register() {
        MCTypeRegistry.TEXT_COMPONENT.addStructureConverter(new DataConverter<Object, Object>(4290){

            @Override
            public Object convert(Object data, long sourceVersion, long toVersion) {
                if (data instanceof ListType) {
                    return null;
                }
                if (data instanceof MapType) {
                    return null;
                }
                if (data instanceof Number) {
                    Number number = (Number)data;
                    return number.toString();
                }
                if (data instanceof Boolean) {
                    Boolean bool = (Boolean)data;
                    return bool.toString();
                }
                if (!(data instanceof String)) {
                    throw new IllegalArgumentException("Wrong type for text component: " + String.valueOf(data));
                }
                String unparsedJson = (String)data;
                try {
                    JsonElement json = JsonParser.parseString((String)unparsedJson);
                    if (!json.isJsonNull()) {
                        Object generic;
                        Object object = generic = Types.JSON.convertFromBaseToGeneric(json, (TypeUtil<?>)Types.NBT);
                        Objects.requireNonNull(object);
                        Object object2 = object;
                        int n = 0;
                        Object ret = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, Boolean.class, String.class, ListType.class, MapType.class, byte[].class, int[].class, long[].class}, (Object)object2, n)) {
                            case 0 -> {
                                Number nt = (Number)object2;
                                yield nt.toString();
                            }
                            case 1 -> {
                                Boolean bt = (Boolean)object2;
                                yield bt.toString();
                            }
                            case 2 -> {
                                String s = (String)object2;
                                yield s;
                            }
                            case 3 -> {
                                ListType lt = (ListType)object2;
                                yield lt;
                            }
                            case 4 -> {
                                MapType ct = (MapType)object2;
                                yield ct;
                            }
                            case 5 -> {
                                byte[] bt = (byte[])object2;
                                throw new IllegalStateException("Unexpected byte[] output from JsonTypeUtil");
                            }
                            case 6 -> {
                                int[] it = (int[])object2;
                                throw new IllegalStateException("Unexpected int[] output from JsonTypeUtil");
                            }
                            case 7 -> {
                                long[] lt = (long[])object2;
                                throw new IllegalStateException("Unexpected long[] output from JsonTypeUtil");
                            }
                            default -> throw new IllegalStateException("Unknown nbt type: " + String.valueOf(generic));
                        };
                        V4290.convertNested(ret);
                        V4290.directWalkComponent(ret, sourceVersion, toVersion);
                        return ret;
                    }
                }
                catch (JsonParseException ex) {
                    LOGGER.error("Failed to convert json to nbt: " + unparsedJson, (Throwable)ex);
                }
                return null;
            }
        });
        MCTypeRegistry.TEXT_COMPONENT.addStructureWalker(4290, 1, (input, fromVersion, toVersion) -> {
            if (input instanceof ListType) {
                ListType listType = (ListType)input;
                WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, listType, fromVersion, toVersion);
            } else if (input instanceof MapType) {
                MapType hoverEvent;
                MapType root = (MapType)input;
                WalkerUtils.convertList(MCTypeRegistry.TEXT_COMPONENT, root, "extra", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, root, "separator", fromVersion, toVersion);
                MapType clickEvent = root.getMap("clickEvent");
                if (clickEvent != null) {
                    switch (clickEvent.getString("action", "")) {
                        case "run_command": 
                        case "suggest_command": {
                            WalkerUtils.convert(MCTypeRegistry.DATACONVERTER_CUSTOM_TYPE_COMMAND, clickEvent, "value", fromVersion, toVersion);
                        }
                    }
                }
                if ((hoverEvent = root.getMap("hoverEvent")) != null) {
                    switch (hoverEvent.getString("action", "")) {
                        case "show_text": {
                            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, hoverEvent, "contents", fromVersion, toVersion);
                            break;
                        }
                        case "show_item": {
                            if (hoverEvent.hasKey("contents", ObjectType.STRING)) {
                                WalkerUtils.convert(MCTypeRegistry.ITEM_NAME, hoverEvent, "contents", fromVersion, toVersion);
                                break;
                            }
                            WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, hoverEvent, "contents", fromVersion, toVersion);
                            break;
                        }
                        case "show_entity": {
                            WalkerUtils.convert(MCTypeRegistry.ENTITY_NAME, hoverEvent, "type", fromVersion, toVersion);
                            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, hoverEvent, "name", fromVersion, toVersion);
                        }
                    }
                }
            }
            return null;
        });
    }

    private V4290() {
    }
}

