/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V4301 {
    private static final int VERSION = 4301;

    public static void register() {
        MCTypeRegistry.ENTITY_EQUIPMENT.addStructureConverter(new DataConverter<MapType, MapType>(4301){
            private static final String[] ARMOR_SLOTS = new String[]{"feet", "legs", "chest", "head"};
            private static final String[] HAND_SLOTS = new String[]{"mainhand", "offhand"};

            private static MapType filterItem(MapType item) {
                return item == null || item.hasKey("id") ? item : null;
            }

            private static void setIfNonNull(MapType dst, String dstKey, MapType value) {
                if (value != null) {
                    dst.setMap(dstKey, value);
                }
            }

            private static void moveItems(MapType src, String srcPath, String[] names, MapType dst) {
                ListType items = src.getListUnchecked(srcPath);
                if (items == null) {
                    return;
                }
                int len = Math.min(items.size(), names.length);
                for (int i = 0; i < len; ++i) {
                    MapType item = 1.filterItem(items.getMap(i, null));
                    if (item == null) continue;
                    dst.setMap(names[i], item);
                }
            }

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType equipment = data.getTypeUtil().createEmptyMap();
                1.setIfNonNull(equipment, "body", 1.filterItem(data.getMap("body_armor_item")));
                1.setIfNonNull(equipment, "saddle", 1.filterItem(data.getMap("saddle")));
                1.moveItems(data, "ArmorItems", ARMOR_SLOTS, equipment);
                1.moveItems(data, "HandItems", HAND_SLOTS, equipment);
                data.remove("ArmorItems");
                data.remove("HandItems");
                data.remove("body_armor_item");
                data.remove("saddle");
                if (!equipment.isEmpty()) {
                    data.setMap("equipment", equipment);
                }
                return null;
            }
        });
        MCTypeRegistry.ENTITY_EQUIPMENT.addStructureWalker(4301, (data, fromVersion, toVersion) -> {
            MapType equipment = data.getMap("equipment");
            if (equipment != null) {
                WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, equipment, "mainhand", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, equipment, "offhand", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, equipment, "feet", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, equipment, "legs", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, equipment, "chest", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, equipment, "head", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, equipment, "body", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, equipment, "saddle", fromVersion, toVersion);
            }
            return null;
        });
    }

    private V4301() {
    }
}

