/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.minecraft.converters.helpers.HelperItemNameV102;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.hooks.DataHookEnforceNamespacedID;
import ca.spottedleaf.dataconverter.minecraft.hooks.DataHookValueTypeEnforceNamespaced;
import ca.spottedleaf.dataconverter.minecraft.walkers.block_name.DataWalkerBlockNames;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.DataWalkerTypePaths;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.minecraft.walkers.item_name.DataWalkerItemNames;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItemLists;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItems;
import ca.spottedleaf.dataconverter.minecraft.walkers.tile_entity.DataWalkerTileEntities;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public final class V99 {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int VERSION = 99;
    private static final Map<String, String> ITEM_ID_TO_TILE_ENTITY_ID = new HashMap<String, String>();

    private static void registerProjectile(String id) {
        MCTypeRegistry.ENTITY.addWalker(99, id, new DataWalkerBlockNames("inTile"));
    }

    private static void registerInventory(String id) {
        MCTypeRegistry.TILE_ENTITY.addWalker(99, id, new DataWalkerItemLists("Items"));
    }

    static void registerSign(int version, String id) {
        MCTypeRegistry.TILE_ENTITY.addWalker(version, id, (data, fromVersion, toVersion) -> {
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, data, "Text1", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, data, "Text2", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, data, "Text3", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, data, "Text4", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, data, "FilteredText1", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, data, "FilteredText2", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, data, "FilteredText3", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, data, "FilteredText4", fromVersion, toVersion);
            return null;
        });
    }

    public static void register() {
        MCTypeRegistry.ENTITY.addStructureWalker(99, (data, fromVersion, toVersion) -> {
            WalkerUtils.convert(MCTypeRegistry.ENTITY, data, "Riding", fromVersion, toVersion);
            return MCTypeRegistry.ENTITY_EQUIPMENT.convert((MapType)data, fromVersion, toVersion);
        });
        MCTypeRegistry.ENTITY_EQUIPMENT.addStructureWalker(99, new DataWalkerItemLists("Equipment"));
        MCTypeRegistry.ENTITY.addWalker(99, "Item", new DataWalkerItems("Item"));
        V99.registerProjectile("ThrownEgg");
        MCTypeRegistry.ENTITY.addWalker(99, "Arrow", new DataWalkerBlockNames("inTile"));
        MCTypeRegistry.ENTITY.addWalker(99, "TippedArrow", new DataWalkerBlockNames("inTile"));
        MCTypeRegistry.ENTITY.addWalker(99, "SpectralArrow", new DataWalkerBlockNames("inTile"));
        V99.registerProjectile("Snowball");
        V99.registerProjectile("Fireball");
        V99.registerProjectile("SmallFireball");
        V99.registerProjectile("ThrownEnderpearl");
        MCTypeRegistry.ENTITY.addWalker(99, "ThrownPotion", new DataWalkerBlockNames("inTile"));
        MCTypeRegistry.ENTITY.addWalker(99, "ThrownPotion", new DataWalkerItems("Potion"));
        V99.registerProjectile("ThrownExpBottle");
        MCTypeRegistry.ENTITY.addWalker(99, "ItemFrame", new DataWalkerItems("Item"));
        V99.registerProjectile("WitherSkull");
        MCTypeRegistry.ENTITY.addWalker(99, "FallingSand", new DataWalkerBlockNames("Block"));
        MCTypeRegistry.ENTITY.addWalker(99, "FallingSand", new DataWalkerTileEntities("TileEntityData"));
        MCTypeRegistry.ENTITY.addWalker(99, "FireworksRocketEntity", new DataWalkerItems("FireworksItem"));
        MCTypeRegistry.ENTITY.addWalker(99, "Minecart", new DataWalkerBlockNames("DisplayTile"));
        MCTypeRegistry.ENTITY.addWalker(99, "Minecart", new DataWalkerItemLists("Items"));
        MCTypeRegistry.ENTITY.addWalker(99, "Minecart", (data, fromVersion, toVersion) -> MCTypeRegistry.UNTAGGED_SPAWNER.convert((MapType)data, fromVersion, toVersion));
        MCTypeRegistry.ENTITY.addWalker(99, "MinecartRideable", new DataWalkerBlockNames("DisplayTile"));
        MCTypeRegistry.ENTITY.addWalker(99, "MinecartChest", new DataWalkerBlockNames("DisplayTile"));
        MCTypeRegistry.ENTITY.addWalker(99, "MinecartChest", new DataWalkerItemLists("Items"));
        MCTypeRegistry.ENTITY.addWalker(99, "MinecartFurnace", new DataWalkerBlockNames("DisplayTile"));
        MCTypeRegistry.ENTITY.addWalker(99, "MinecartTNT", new DataWalkerBlockNames("DisplayTile"));
        MCTypeRegistry.ENTITY.addWalker(99, "MinecartSpawner", new DataWalkerBlockNames("DisplayTile"));
        MCTypeRegistry.ENTITY.addWalker(99, "MinecartSpawner", (data, fromVersion, toVersion) -> MCTypeRegistry.UNTAGGED_SPAWNER.convert((MapType)data, fromVersion, toVersion));
        MCTypeRegistry.ENTITY.addWalker(99, "MinecartHopper", new DataWalkerBlockNames("DisplayTile"));
        MCTypeRegistry.ENTITY.addWalker(99, "MinecartHopper", new DataWalkerItemLists("Items"));
        MCTypeRegistry.ENTITY.addWalker(99, "MinecartCommandBlock", new DataWalkerBlockNames("DisplayTile"));
        MCTypeRegistry.ENTITY.addWalker(99, "MinecartCommandBlock", new DataWalkerTypePaths<Object, Object>(MCTypeRegistry.TEXT_COMPONENT, "LastOutput"));
        MCTypeRegistry.ENTITY.addWalker(99, "Enderman", new DataWalkerBlockNames("carried"));
        MCTypeRegistry.ENTITY.addWalker(99, "EntityHorse", new DataWalkerItemLists("Items"));
        MCTypeRegistry.ENTITY.addWalker(99, "EntityHorse", new DataWalkerItems("ArmorItem", "SaddleItem"));
        MCTypeRegistry.ENTITY.addWalker(99, "Villager", new DataWalkerItemLists("Inventory"));
        MCTypeRegistry.ENTITY.addWalker(99, "Villager", (data, fromVersion, toVersion) -> {
            WalkerUtils.convertList(MCTypeRegistry.VILLAGER_TRADE, data.getMap("Offers"), "Recipes", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.ENTITY.addWalker(99, "AreaEffectCloud", new DataWalkerTypePaths<Object, Object>(MCTypeRegistry.PARTICLE, "Particle"));
        MCTypeRegistry.TILE_ENTITY.addStructureWalker(99, (data, fromVersion, toVersion) -> {
            WalkerUtils.convert(MCTypeRegistry.DATA_COMPONENTS, data, "components", fromVersion, toVersion);
            return null;
        });
        V99.registerInventory("Furnace");
        V99.registerInventory("Chest");
        MCTypeRegistry.TILE_ENTITY.addWalker(99, "RecordPlayer", new DataWalkerItems("RecordItem"));
        V99.registerInventory("Trap");
        V99.registerInventory("Dropper");
        V99.registerSign(99, "Sign");
        MCTypeRegistry.TILE_ENTITY.addWalker(99, "MobSpawner", (data, fromVersion, toVersion) -> MCTypeRegistry.UNTAGGED_SPAWNER.convert((MapType)data, fromVersion, toVersion));
        V99.registerInventory("Cauldron");
        MCTypeRegistry.TILE_ENTITY.addWalker(99, "Control", new DataWalkerTypePaths<Object, Object>(MCTypeRegistry.DATACONVERTER_CUSTOM_TYPE_COMMAND, "Command"));
        MCTypeRegistry.TILE_ENTITY.addWalker(99, "Control", new DataWalkerTypePaths<Object, Object>(MCTypeRegistry.TEXT_COMPONENT, "LastOutput"));
        V99.registerInventory("Hopper");
        MCTypeRegistry.TILE_ENTITY.addWalker(99, "FlowerPot", new DataWalkerItemNames("Item"));
        MCTypeRegistry.LEVEL.addStructureWalker(99, (data, fromVersion, toVersion) -> {
            WalkerUtils.convertListPath(MCTypeRegistry.TEXT_COMPONENT, data, "CustomBossEvents", "Name", fromVersion, toVersion);
            return MCTypeRegistry.LIGHTWEIGHT_LEVEL.convert((MapType)data, fromVersion, toVersion);
        });
        MCTypeRegistry.ITEM_STACK.addStructureWalker(99, (data, fromVersion, toVersion) -> {
            MapType blockEntityTag;
            MapType entityTag;
            WalkerUtils.convert(MCTypeRegistry.ITEM_NAME, data, "id", fromVersion, toVersion);
            MapType tag = data.getMap("tag");
            if (tag == null) {
                return null;
            }
            String itemId = V99.getStringId(data.getGeneric("id"));
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, tag, "Items", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, tag, "ChargedProjectiles", fromVersion, toVersion);
            if ("minecraft:written_book".equals(itemId)) {
                WalkerUtils.convertList(MCTypeRegistry.TEXT_COMPONENT, tag, "pages", fromVersion, toVersion);
                WalkerUtils.convertList(MCTypeRegistry.TEXT_COMPONENT, tag, "filtered_pages", fromVersion, toVersion);
            }
            if ((entityTag = tag.getMap("EntityTag")) != null) {
                boolean removeId;
                String entityId = "minecraft:armor_stand".equals(itemId) ? "ArmorStand" : ("minecraft:item_frame".equals(itemId) ? "ItemFrame" : ("minecraft:painting".equals(itemId) ? "Painting" : entityTag.getString("id")));
                if (entityId == null) {
                    if (!"minecraft:air".equals(itemId)) {
                        LOGGER.warn("Unable to resolve Entity for ItemStack (V99): " + String.valueOf(data.getGeneric("id")));
                    }
                    removeId = false;
                } else {
                    boolean bl = removeId = !entityTag.hasKey("id", ObjectType.STRING);
                    if (removeId) {
                        entityTag.setString("id", entityId);
                    }
                }
                MapType replace = MCTypeRegistry.ENTITY.convert(entityTag, fromVersion, toVersion);
                if (replace != null) {
                    entityTag = replace;
                    tag.setMap("EntityTag", entityTag);
                }
                if (removeId) {
                    entityTag.remove("id");
                }
            }
            if ((blockEntityTag = tag.getMap("BlockEntityTag")) != null) {
                boolean removeId;
                String entityId = ITEM_ID_TO_TILE_ENTITY_ID.get(itemId);
                if (entityId == null) {
                    if (!"minecraft:air".equals(itemId)) {
                        LOGGER.warn("Unable to resolve BlockEntity for ItemStack (V99): " + String.valueOf(data.getGeneric("id")));
                    }
                    removeId = false;
                } else {
                    removeId = !blockEntityTag.hasKey("id", ObjectType.STRING);
                    blockEntityTag.setString("id", entityId);
                }
                MapType replace = MCTypeRegistry.TILE_ENTITY.convert(blockEntityTag, fromVersion, toVersion);
                if (replace != null) {
                    blockEntityTag = replace;
                    tag.setMap("BlockEntityTag", blockEntityTag);
                }
                if (removeId) {
                    blockEntityTag.remove("id");
                }
            }
            WalkerUtils.convertList(MCTypeRegistry.BLOCK_NAME, tag, "CanDestroy", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.BLOCK_NAME, tag, "CanPlaceOn", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.PLAYER.addStructureWalker(99, new DataWalkerItemLists("Inventory", "EnderItems"));
        MCTypeRegistry.CHUNK.addStructureWalker(99, (data, fromVersion, toVersion) -> {
            MapType level = data.getMap("Level");
            if (level == null) {
                return null;
            }
            WalkerUtils.convertList(MCTypeRegistry.ENTITY, level, "Entities", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.TILE_ENTITY, level, "TileEntities", fromVersion, toVersion);
            ListType tileTicks = level.getList("TileTicks", ObjectType.MAP);
            if (tileTicks != null) {
                int len = tileTicks.size();
                for (int i = 0; i < len; ++i) {
                    MapType tileTick = tileTicks.getMap(i);
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_NAME, tileTick, "i", fromVersion, toVersion);
                }
            }
            return null;
        });
        MCTypeRegistry.ENTITY_CHUNK.addStructureWalker(99, (data, fromVersion, toVersion) -> {
            WalkerUtils.convertList(MCTypeRegistry.ENTITY, data, "Entities", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.SAVED_DATA_MAP_DATA.addStructureWalker(99, (root, fromVersion, toVersion) -> {
            WalkerUtils.convertListPath(MCTypeRegistry.TEXT_COMPONENT, root, "banners", "Name", fromVersion, toVersion);
            WalkerUtils.convertListPath(MCTypeRegistry.TEXT_COMPONENT, root.getMap("data"), "banners", "Name", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.SAVED_DATA_SCOREBOARD.addStructureWalker(99, (root, fromVersion, toVersion) -> {
            MapType data = root.getMap("data");
            if (data == null) {
                return null;
            }
            WalkerUtils.convertList(MCTypeRegistry.OBJECTIVE, data, "Objectives", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.TEAM, data, "Teams", fromVersion, toVersion);
            WalkerUtils.convertListPath(MCTypeRegistry.TEXT_COMPONENT, data, "PlayerScores", "display", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.SAVED_DATA_STRUCTURE_FEATURE_INDICES.addStructureWalker(99, (root, fromVersion, toVersion) -> {
            MapType data = root.getMap("data");
            if (data == null) {
                return null;
            }
            WalkerUtils.convertValues(MCTypeRegistry.STRUCTURE_FEATURE, data, "Features", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.TEAM.addStructureWalker(99, (root, fromVersion, toVersion) -> {
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, root, "MemberNamePrefix", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, root, "MemberNameSuffix", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, root, "DisplayName", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.VILLAGER_TRADE.addStructureWalker(99, (root, fromVersion, toVersion) -> {
            WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, root, "buy", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, root, "buyB", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, root, "sell", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.STRUCTURE.addStructureWalker(99, (root, fromVersion, toVersion) -> {
            WalkerUtils.convertListPath(MCTypeRegistry.ENTITY, root, "entities", "nbt", fromVersion, toVersion);
            WalkerUtils.convertListPath(MCTypeRegistry.TILE_ENTITY, root, "blocks", "nbt", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.BLOCK_STATE, root, "palette", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.BLOCK_NAME.addStructureHook(99, new DataHookValueTypeEnforceNamespaced());
        MCTypeRegistry.ITEM_NAME.addStructureHook(99, new DataHookValueTypeEnforceNamespaced());
        MCTypeRegistry.ITEM_STACK.addStructureHook(99, new DataHookEnforceNamespacedID());
    }

    private static String getStringId(Object id) {
        if (id instanceof String) {
            String string = (String)id;
            return string;
        }
        if (id instanceof Number) {
            Number number = (Number)id;
            return HelperItemNameV102.getNameFromId(number.intValue());
        }
        return null;
    }

    private V99() {
    }

    static {
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:furnace", "Furnace");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:lit_furnace", "Furnace");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:chest", "Chest");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:trapped_chest", "Chest");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:ender_chest", "EnderChest");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:jukebox", "RecordPlayer");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:dispenser", "Trap");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:dropper", "Dropper");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:sign", "Sign");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:mob_spawner", "MobSpawner");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:noteblock", "Music");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:brewing_stand", "Cauldron");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:enhanting_table", "EnchantTable");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:command_block", "CommandBlock");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:beacon", "Beacon");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:skull", "Skull");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:daylight_detector", "DLDetector");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:hopper", "Hopper");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:banner", "Banner");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:flower_pot", "FlowerPot");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:repeating_command_block", "CommandBlock");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:chain_command_block", "CommandBlock");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:standing_sign", "Sign");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:wall_sign", "Sign");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:piston_head", "Piston");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:daylight_detector_inverted", "DLDetector");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:unpowered_comparator", "Comparator");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:powered_comparator", "Comparator");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:wall_banner", "Banner");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:standing_banner", "Banner");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:structure_block", "Structure");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:end_portal", "Airportal");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:end_gateway", "EndGateway");
        ITEM_ID_TO_TILE_ENTITY_ID.put("minecraft:shield", "Banner");
    }
}

