/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types;

import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import java.util.Set;

public interface MapType {
    public TypeUtil<?> getTypeUtil();

    public int hashCode();

    public boolean equals(Object var1);

    public int size();

    public boolean isEmpty();

    public void clear();

    public Set<String> keys();

    public MapType copy();

    public boolean hasKey(String var1);

    public boolean hasKey(String var1, ObjectType var2);

    public void remove(String var1);

    public Object getGeneric(String var1);

    public Number getNumber(String var1);

    public Number getNumber(String var1, Number var2);

    public boolean getBoolean(String var1);

    public boolean getBoolean(String var1, boolean var2);

    public void setBoolean(String var1, boolean var2);

    public byte getByte(String var1);

    public byte getByte(String var1, byte var2);

    public void setByte(String var1, byte var2);

    public short getShort(String var1);

    public short getShort(String var1, short var2);

    public void setShort(String var1, short var2);

    public int getInt(String var1);

    public int getInt(String var1, int var2);

    public void setInt(String var1, int var2);

    public long getLong(String var1);

    public long getLong(String var1, long var2);

    public void setLong(String var1, long var2);

    public float getFloat(String var1);

    public float getFloat(String var1, float var2);

    public void setFloat(String var1, float var2);

    public double getDouble(String var1);

    public double getDouble(String var1, double var2);

    public void setDouble(String var1, double var2);

    public byte[] getBytes(String var1);

    public byte[] getBytes(String var1, byte[] var2);

    public void setBytes(String var1, byte[] var2);

    public short[] getShorts(String var1);

    public short[] getShorts(String var1, short[] var2);

    public void setShorts(String var1, short[] var2);

    public int[] getInts(String var1);

    public int[] getInts(String var1, int[] var2);

    public void setInts(String var1, int[] var2);

    public long[] getLongs(String var1);

    public long[] getLongs(String var1, long[] var2);

    public void setLongs(String var1, long[] var2);

    public ListType getListUnchecked(String var1);

    public ListType getListUnchecked(String var1, ListType var2);

    default public ListType getList(String key, ObjectType type) {
        return this.getList(key, type, null);
    }

    default public ListType getOrCreateList(String key, ObjectType type) {
        ListType ret = this.getList(key, type);
        if (ret == null) {
            ret = this.getTypeUtil().createEmptyList();
            this.setList(key, ret);
        }
        return ret;
    }

    default public ListType getList(String key, ObjectType type, ListType dfl) {
        ObjectType retType;
        ListType ret = this.getListUnchecked(key, null);
        if (ret != null && ((retType = ret.getUniformType()) == type || retType == ObjectType.UNDEFINED || retType == ObjectType.NONE)) {
            return ret;
        }
        return dfl;
    }

    public void setList(String var1, ListType var2);

    public MapType getMap(String var1);

    default public MapType getOrCreateMap(String key) {
        MapType ret = this.getMap(key);
        if (ret == null) {
            ret = this.getTypeUtil().createEmptyMap();
            this.setMap(key, ret);
        }
        return ret;
    }

    public MapType getMap(String var1, MapType var2);

    public void setMap(String var1, MapType var2);

    public String getString(String var1);

    public String getString(String var1, String var2);

    public void setString(String var1, String var2);

    default public void setGeneric(String key, Object value) {
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            this.setBoolean(key, bool);
            return;
        }
        if (value instanceof Number) {
            if (value instanceof Byte) {
                Byte b = (Byte)value;
                this.setByte(key, b);
                return;
            }
            if (value instanceof Short) {
                Short s = (Short)value;
                this.setShort(key, s);
                return;
            }
            if (value instanceof Integer) {
                Integer i = (Integer)value;
                this.setInt(key, i);
                return;
            }
            if (value instanceof Long) {
                Long l = (Long)value;
                this.setLong(key, l);
                return;
            }
            if (value instanceof Float) {
                Float f = (Float)value;
                this.setFloat(key, f.floatValue());
                return;
            }
            if (value instanceof Double) {
                Double d = (Double)value;
                this.setDouble(key, d);
                return;
            }
        } else {
            if (value instanceof MapType) {
                MapType map = (MapType)value;
                this.setMap(key, map);
                return;
            }
            if (value instanceof ListType) {
                ListType list = (ListType)value;
                this.setList(key, list);
                return;
            }
            if (value instanceof String) {
                String string = (String)value;
                this.setString(key, string);
                return;
            }
            if (value.getClass().isArray()) {
                if (value instanceof byte[]) {
                    byte[] bytes = (byte[])value;
                    this.setBytes(key, bytes);
                    return;
                }
                if (value instanceof short[]) {
                    short[] shorts = (short[])value;
                    this.setShorts(key, shorts);
                    return;
                }
                if (value instanceof int[]) {
                    int[] ints = (int[])value;
                    this.setInts(key, ints);
                    return;
                }
                if (value instanceof long[]) {
                    long[] longs = (long[])value;
                    this.setLongs(key, longs);
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Object " + String.valueOf(value) + " is not a valid type!");
    }
}

