/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types.nbt;

import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import ca.spottedleaf.dataconverter.types.Types;
import ca.spottedleaf.dataconverter.types.nbt.NBTMapType;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public final class NBTListType
implements ListType {
    final ListTag list;

    public NBTListType() {
        this.list = new ListTag();
    }

    public NBTListType(ListTag tag) {
        this.list = tag;
    }

    public TypeUtil<Tag> getTypeUtil() {
        return Types.NBT;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != NBTListType.class) {
            return false;
        }
        return this.list.equals(((NBTListType)obj).list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public String toString() {
        return "NBTListType{list=" + String.valueOf(this.list) + "}";
    }

    public ListTag getTag() {
        return this.list;
    }

    @Override
    public ListType copy() {
        return new NBTListType(this.list.copy());
    }

    static ObjectType getType(byte id) {
        switch (id) {
            case 0: {
                return ObjectType.NONE;
            }
            case 1: {
                return ObjectType.BYTE;
            }
            case 2: {
                return ObjectType.SHORT;
            }
            case 3: {
                return ObjectType.INT;
            }
            case 4: {
                return ObjectType.LONG;
            }
            case 5: {
                return ObjectType.FLOAT;
            }
            case 6: {
                return ObjectType.DOUBLE;
            }
            case 7: {
                return ObjectType.BYTE_ARRAY;
            }
            case 8: {
                return ObjectType.STRING;
            }
            case 9: {
                return ObjectType.LIST;
            }
            case 10: {
                return ObjectType.MAP;
            }
            case 11: {
                return ObjectType.INT_ARRAY;
            }
            case 12: {
                return ObjectType.LONG_ARRAY;
            }
        }
        throw new IllegalStateException("Unknown type: " + id);
    }

    @Override
    public ObjectType getUniformType() {
        ObjectType curr = null;
        int len = this.list.size();
        for (int i = 0; i < len; ++i) {
            Tag tag = this.list.get(i);
            ObjectType tagType = NBTListType.getType(tag.getId());
            if (curr == null) {
                curr = tagType;
                continue;
            }
            if (tagType == curr) continue;
            return ObjectType.MIXED;
        }
        return curr == null ? ObjectType.NONE : curr;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void remove(int index) {
        this.list.remove(index);
    }

    @Override
    public Object getGeneric(int index) {
        return Types.NBT.baseToGeneric(this.list.get(index));
    }

    @Override
    public Number getNumber(int index) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            throw new IllegalStateException();
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.box();
    }

    @Override
    public Number getNumber(int index, Number dfl) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            return dfl;
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.box();
    }

    @Override
    public byte getByte(int index) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            throw new IllegalStateException();
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.byteValue();
    }

    @Override
    public byte getByte(int index, byte dfl) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            return dfl;
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.byteValue();
    }

    @Override
    public void setByte(int index, byte to) {
        this.list.set(index, ByteTag.valueOf(to));
    }

    @Override
    public short getShort(int index) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            throw new IllegalStateException();
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.shortValue();
    }

    @Override
    public short getShort(int index, short dfl) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            return dfl;
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.shortValue();
    }

    @Override
    public void setShort(int index, short to) {
        this.list.set(index, ShortTag.valueOf(to));
    }

    @Override
    public int getInt(int index) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            throw new IllegalStateException();
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.intValue();
    }

    @Override
    public int getInt(int index, int dfl) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            return dfl;
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.intValue();
    }

    @Override
    public void setInt(int index, int to) {
        this.list.set(index, IntTag.valueOf(to));
    }

    @Override
    public long getLong(int index) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            throw new IllegalStateException();
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.longValue();
    }

    @Override
    public long getLong(int index, long dfl) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            return dfl;
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.longValue();
    }

    @Override
    public void setLong(int index, long to) {
        this.list.set(index, LongTag.valueOf(to));
    }

    @Override
    public float getFloat(int index) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            throw new IllegalStateException();
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.floatValue();
    }

    @Override
    public float getFloat(int index, float dfl) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            return dfl;
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.floatValue();
    }

    @Override
    public void setFloat(int index, float to) {
        this.list.set(index, FloatTag.valueOf(to));
    }

    @Override
    public double getDouble(int index) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            throw new IllegalStateException();
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.doubleValue();
    }

    @Override
    public double getDouble(int index, double dfl) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof NumericTag)) {
            return dfl;
        }
        NumericTag numericTag = (NumericTag)tag;
        return numericTag.doubleValue();
    }

    @Override
    public void setDouble(int index, double to) {
        this.list.set(index, DoubleTag.valueOf(to));
    }

    @Override
    public byte[] getBytes(int index) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof ByteArrayTag)) {
            throw new IllegalStateException();
        }
        ByteArrayTag bytes = (ByteArrayTag)tag;
        return bytes.getAsByteArray();
    }

    @Override
    public byte[] getBytes(int index, byte[] dfl) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof ByteArrayTag)) {
            return dfl;
        }
        ByteArrayTag bytes = (ByteArrayTag)tag;
        return bytes.getAsByteArray();
    }

    @Override
    public void setBytes(int index, byte[] to) {
        this.list.set(index, new ByteArrayTag(to));
    }

    @Override
    public short[] getShorts(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short[] getShorts(int index, short[] dfl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setShorts(int index, short[] to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getInts(int index) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof IntArrayTag)) {
            throw new IllegalStateException();
        }
        IntArrayTag ints = (IntArrayTag)tag;
        return ints.getAsIntArray();
    }

    @Override
    public int[] getInts(int index, int[] dfl) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof IntArrayTag)) {
            return dfl;
        }
        IntArrayTag ints = (IntArrayTag)tag;
        return ints.getAsIntArray();
    }

    @Override
    public void setInts(int index, int[] to) {
        this.list.set(index, new IntArrayTag(to));
    }

    @Override
    public long[] getLongs(int index) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof LongArrayTag)) {
            throw new IllegalStateException();
        }
        LongArrayTag longs = (LongArrayTag)tag;
        return longs.getAsLongArray();
    }

    @Override
    public long[] getLongs(int index, long[] dfl) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof LongArrayTag)) {
            return dfl;
        }
        LongArrayTag longs = (LongArrayTag)tag;
        return longs.getAsLongArray();
    }

    @Override
    public void setLongs(int index, long[] to) {
        this.list.set(index, new LongArrayTag(to));
    }

    @Override
    public ListType getList(int index) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof ListTag)) {
            throw new IllegalStateException();
        }
        ListTag list = (ListTag)tag;
        return new NBTListType(list);
    }

    @Override
    public ListType getList(int index, ListType dfl) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof ListTag)) {
            return dfl;
        }
        ListTag list = (ListTag)tag;
        return new NBTListType(list);
    }

    @Override
    public void setList(int index, ListType list) {
        this.list.set(index, ((NBTListType)list).getTag());
    }

    @Override
    public MapType getMap(int index) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof CompoundTag)) {
            throw new IllegalStateException();
        }
        CompoundTag compoundTag = (CompoundTag)tag;
        return new NBTMapType(compoundTag);
    }

    @Override
    public MapType getMap(int index, MapType dfl) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof CompoundTag)) {
            return dfl;
        }
        CompoundTag compoundTag = (CompoundTag)tag;
        return new NBTMapType(compoundTag);
    }

    @Override
    public void setMap(int index, MapType to) {
        this.list.set(index, ((NBTMapType)to).getTag());
    }

    @Override
    public String getString(int index) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof StringTag)) {
            throw new IllegalStateException();
        }
        StringTag stringTag = (StringTag)tag;
        return stringTag.value();
    }

    @Override
    public String getString(int index, String dfl) {
        Tag tag = this.list.get(index);
        if (!(tag instanceof StringTag)) {
            return dfl;
        }
        StringTag stringTag = (StringTag)tag;
        return stringTag.value();
    }

    @Override
    public void setString(int index, String to) {
        this.list.set(index, StringTag.valueOf(to));
    }

    @Override
    public void addByte(byte b) {
        this.list.add(ByteTag.valueOf(b));
    }

    @Override
    public void addByte(int index, byte b) {
        this.list.add(index, ByteTag.valueOf(b));
    }

    @Override
    public void addShort(short s) {
        this.list.add(ShortTag.valueOf(s));
    }

    @Override
    public void addShort(int index, short s) {
        this.list.add(index, ShortTag.valueOf(s));
    }

    @Override
    public void addInt(int i) {
        this.list.add(IntTag.valueOf(i));
    }

    @Override
    public void addInt(int index, int i) {
        this.list.add(index, IntTag.valueOf(i));
    }

    @Override
    public void addLong(long l) {
        this.list.add(LongTag.valueOf(l));
    }

    @Override
    public void addLong(int index, long l) {
        this.list.add(index, LongTag.valueOf(l));
    }

    @Override
    public void addFloat(float f) {
        this.list.add(FloatTag.valueOf(f));
    }

    @Override
    public void addFloat(int index, float f) {
        this.list.add(index, FloatTag.valueOf(f));
    }

    @Override
    public void addDouble(double d) {
        this.list.add(DoubleTag.valueOf(d));
    }

    @Override
    public void addDouble(int index, double d) {
        this.list.add(index, DoubleTag.valueOf(d));
    }

    @Override
    public void addByteArray(byte[] arr) {
        this.list.add(new ByteArrayTag(arr));
    }

    @Override
    public void addByteArray(int index, byte[] arr) {
        this.list.add(index, new ByteArrayTag(arr));
    }

    @Override
    public void addShortArray(short[] arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addShortArray(int index, short[] arr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addIntArray(int[] arr) {
        this.list.add(new IntArrayTag(arr));
    }

    @Override
    public void addIntArray(int index, int[] arr) {
        this.list.add(index, new IntArrayTag(arr));
    }

    @Override
    public void addLongArray(long[] arr) {
        this.list.add(new LongArrayTag(arr));
    }

    @Override
    public void addLongArray(int index, long[] arr) {
        this.list.add(index, new LongArrayTag(arr));
    }

    @Override
    public void addList(ListType list) {
        this.list.add(((NBTListType)list).getTag());
    }

    @Override
    public void addList(int index, ListType list) {
        this.list.add(index, ((NBTListType)list).getTag());
    }

    @Override
    public void addMap(MapType map) {
        this.list.add(((NBTMapType)map).getTag());
    }

    @Override
    public void addMap(int index, MapType map) {
        this.list.add(index, ((NBTMapType)map).getTag());
    }

    @Override
    public void addString(String string) {
        this.list.add(StringTag.valueOf(string));
    }

    @Override
    public void addString(int index, String string) {
        this.list.add(index, StringTag.valueOf(string));
    }
}

