/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public final class EntityUtil {
    private static final ThreadLocal<DecimalFormat> THREE_DECIMAL_PLACES = ThreadLocal.withInitial(() -> new DecimalFormat("#,##0.000"));

    private static String formatVec(Vec3 vec) {
        DecimalFormat format = THREE_DECIMAL_PLACES.get();
        return "(" + format.format(vec.x) + "," + format.format(vec.y) + "," + format.format(vec.z) + ")";
    }

    private static String dumpEntityWithoutReferences(Entity entity) {
        if (entity == null) {
            return "{null}";
        }
        return "{type=" + entity.getClass().getSimpleName() + ",id=" + entity.getId() + ",uuid=" + String.valueOf(entity.getUUID()) + ",pos=" + EntityUtil.formatVec(entity.position()) + ",mot=" + EntityUtil.formatVec(entity.getDeltaMovement()) + ",aabb=" + String.valueOf(entity.getBoundingBox()) + ",removed=" + String.valueOf((Object)entity.getRemovalReason()) + ",has_vehicle=" + (entity.getVehicle() != null) + ",passenger_count=" + entity.getPassengers().size();
    }

    public static String dumpEntity(Entity entity) {
        List<Entity> passengers = entity.getPassengers();
        ArrayList<CallSite> passengerStrings = new ArrayList<CallSite>(passengers.size());
        for (Entity passenger : passengers) {
            passengerStrings.add((CallSite)((Object)("(" + EntityUtil.dumpEntityWithoutReferences(passenger) + ")")));
        }
        return "{root=[" + EntityUtil.dumpEntityWithoutReferences(entity) + "], vehicle=[" + EntityUtil.dumpEntityWithoutReferences(entity.getVehicle()) + "], passengers=[" + String.join((CharSequence)",", passengerStrings) + "]";
    }

    private EntityUtil() {
    }
}

