/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;

public class ThreadUnsafeRandom
implements BitRandomSource {
    private static final long MULTIPLIER = 25214903917L;
    private static final long ADDEND = 11L;
    private static final int BITS = 48;
    private static final long MASK = 0xFFFFFFFFFFFFL;
    private long value;
    private final MarsagliaPolarGaussian gaussianSource = new MarsagliaPolarGaussian(this);

    public ThreadUnsafeRandom(long seed) {
        this.setSeed(seed);
    }

    @Override
    public void setSeed(long seed) {
        this.value = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        this.gaussianSource.reset();
    }

    private long advanceSeed() {
        this.value = this.value * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return this.value;
    }

    @Override
    public int next(int bits) {
        return (int)(this.advanceSeed() >>> 48 - bits);
    }

    @Override
    public int nextInt() {
        long seed = this.advanceSeed();
        return (int)(seed >>> 16);
    }

    @Override
    public double nextGaussian() {
        return this.gaussianSource.nextGaussian();
    }

    @Override
    public RandomSource fork() {
        return new ThreadUnsafeRandom(this.nextLong());
    }

    @Override
    public PositionalRandomFactory forkPositional() {
        return new ThreadUnsafeRandomPositionalFactory(this.nextLong());
    }

    public static final class ThreadUnsafeRandomPositionalFactory
    implements PositionalRandomFactory {
        private final long seed;

        public ThreadUnsafeRandomPositionalFactory(long seed) {
            this.seed = seed;
        }

        public long getSeed() {
            return this.seed;
        }

        @Override
        public RandomSource fromHashOf(String string) {
            return new ThreadUnsafeRandom((long)string.hashCode() ^ this.seed);
        }

        @Override
        public RandomSource fromSeed(long seed) {
            return new ThreadUnsafeRandom(seed);
        }

        @Override
        public RandomSource at(int x, int y, int z) {
            return new ThreadUnsafeRandom(Mth.getSeed(x, y, z) ^ this.seed);
        }

        @Override
        public void parityConfigString(StringBuilder stringBuilder) {
            stringBuilder.append("ThreadUnsafeRandomPositionalFactory{").append(this.seed).append('}');
        }
    }
}

