/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.scheduling;

import ca.spottedleaf.concurrentutil.collection.MultiThreadedQueue;
import ca.spottedleaf.concurrentutil.lock.ReentrantAreaLock;
import ca.spottedleaf.concurrentutil.map.ConcurrentLong2LongChainedHashTable;
import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.PoiChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.queue.ChunkUnloadQueue;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ThreadedTicketLevelPropagator;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task.ChunkLoadTask;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task.ChunkProgressionTask;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicket;
import ca.spottedleaf.moonrise.patches.chunk_system.ticket.ChunkSystemTicketType;
import ca.spottedleaf.moonrise.patches.chunk_system.util.stream.TicketSet;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;

public final class ChunkHolderManager {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    public static final int FULL_LOADED_TICKET_LEVEL = 33;
    public static final int BLOCK_TICKING_TICKET_LEVEL = 32;
    public static final int ENTITY_TICKING_TICKET_LEVEL = 31;
    public static final int MAX_TICKET_LEVEL = ChunkLevel.MAX_LEVEL;
    public static final TicketType UNLOAD_COOLDOWN = ChunkSystemTicketType.create("chunk_system:unload_cooldown", null, 100L);
    private static final long NO_TIMEOUT_MARKER = Long.MIN_VALUE;
    public final ReentrantAreaLock ticketLockArea;
    private final ConcurrentLong2ReferenceChainedHashTable<TicketSet> tickets = new ConcurrentLong2ReferenceChainedHashTable();
    private final ConcurrentLong2ReferenceChainedHashTable<Long2IntOpenHashMap> sectionToChunkToExpireCount = new ConcurrentLong2ReferenceChainedHashTable();
    final ChunkUnloadQueue unloadQueue;
    private final ConcurrentLong2ReferenceChainedHashTable<NewChunkHolder> chunkHolders = ConcurrentLong2ReferenceChainedHashTable.createWithCapacity((int)16384, (float)0.25f);
    private final ServerLevel world;
    private final ChunkTaskScheduler taskScheduler;
    private long currentTick;
    private final ArrayDeque<NewChunkHolder> pendingFullLoadUpdate = new ArrayDeque();
    private final MultiThreadedQueue<NewChunkHolder> offThreadPendingFullLoadUpdate = new MultiThreadedQueue();
    private final ObjectRBTreeSet<NewChunkHolder> autoSaveQueue = new ObjectRBTreeSet((c1, c2) -> {
        long coord2;
        if (c1 == c2) {
            return 0;
        }
        int saveTickCompare = Long.compare(c1.lastAutoSave, c2.lastAutoSave);
        if (saveTickCompare != 0) {
            return saveTickCompare;
        }
        long coord1 = CoordinateUtils.getChunkKey(c1.chunkX, c1.chunkZ);
        if (coord1 == (coord2 = CoordinateUtils.getChunkKey(c2.chunkX, c2.chunkZ))) {
            throw new IllegalStateException("Duplicate chunkholder in auto save queue");
        }
        return Long.compare(coord1, coord2);
    });
    private final ConcurrentLong2ReferenceChainedHashTable<ConcurrentLong2LongChainedHashTable> ticketCounters = new ConcurrentLong2ReferenceChainedHashTable();
    private final ThreadedTicketLevelPropagator ticketLevelPropagator = new ThreadedTicketLevelPropagator(){

        @Override
        protected void processLevelUpdates(Long2ByteLinkedOpenHashMap updates) {
            ObjectBidirectionalIterator iterator = updates.long2ByteEntrySet().fastIterator();
            while (iterator.hasNext()) {
                int currentLevel;
                Long2ByteMap.Entry entry = (Long2ByteMap.Entry)iterator.next();
                long key = entry.getLongKey();
                int newLevel = ChunkHolderManager.convertBetweenTicketLevels(entry.getByteValue());
                NewChunkHolder current = (NewChunkHolder)ChunkHolderManager.this.chunkHolders.get(key);
                if (current == null && newLevel > MAX_TICKET_LEVEL) {
                    iterator.remove();
                    continue;
                }
                int n = currentLevel = current == null ? MAX_TICKET_LEVEL + 1 : current.getCurrentTicketLevel();
                if (currentLevel == newLevel) {
                    iterator.remove();
                    continue;
                }
                if (current == null) {
                    current = ChunkHolderManager.this.createChunkHolder(key);
                    ChunkHolderManager.this.chunkHolders.put(key, (Object)current);
                    current.updateTicketLevel(newLevel);
                    continue;
                }
                current.updateTicketLevel(newLevel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSchedulingUpdates(Long2ByteLinkedOpenHashMap updates, List<ChunkProgressionTask> scheduledTasks, List<NewChunkHolder> changedFullStatus) {
            List<ChunkProgressionTask> prev = CURRENT_TICKET_UPDATE_SCHEDULING.get();
            CURRENT_TICKET_UPDATE_SCHEDULING.set(scheduledTasks);
            try {
                LongBidirectionalIterator iterator = updates.keySet().iterator();
                while (iterator.hasNext()) {
                    long key = iterator.nextLong();
                    NewChunkHolder current = (NewChunkHolder)ChunkHolderManager.this.chunkHolders.get(key);
                    if (current == null) {
                        throw new IllegalStateException("Expected chunk holder to be created");
                    }
                    current.processTicketLevelUpdate(scheduledTasks, changedFullStatus);
                }
            }
            finally {
                CURRENT_TICKET_UPDATE_SCHEDULING.set(prev);
            }
        }
    };
    private final ThreadLocal<Boolean> BLOCK_TICKET_UPDATES = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final ThreadLocal<List<ChunkProgressionTask>> CURRENT_TICKET_UPDATE_SCHEDULING = new ThreadLocal();

    public ChunkHolderManager(ServerLevel world, ChunkTaskScheduler taskScheduler) {
        this.world = world;
        this.taskScheduler = taskScheduler;
        this.ticketLockArea = new ReentrantAreaLock(taskScheduler.getChunkSystemLockShift());
        this.unloadQueue = new ChunkUnloadQueue(world.moonrise$getRegionChunkShift());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTicketUpdates(int chunkX, int chunkZ) {
        boolean ret;
        int ticketShift = 6;
        int ticketMask = 63;
        ArrayList<ChunkProgressionTask> scheduledTasks = new ArrayList<ChunkProgressionTask>();
        ArrayList<NewChunkHolder> changedFullStatus = new ArrayList<NewChunkHolder>();
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock((chunkX >> 6) - 1 << 6, (chunkZ >> 6) - 1 << 6, (chunkX >> 6) + 1 << 6 | 0x3F, (chunkZ >> 6) + 1 << 6 | 0x3F);
        try {
            ret = this.processTicketUpdatesNoLock(chunkX >> 6, chunkZ >> 6, scheduledTasks, changedFullStatus);
        }
        finally {
            this.ticketLockArea.unlock(ticketLock);
        }
        this.addChangedStatuses(changedFullStatus);
        int len = scheduledTasks.size();
        for (int i = 0; i < len; ++i) {
            ((ChunkProgressionTask)scheduledTasks.get(i)).schedule();
        }
        return ret;
    }

    private boolean processTicketUpdatesNoLock(int sectionX, int sectionZ, List<ChunkProgressionTask> scheduledTasks, List<NewChunkHolder> changedFullStatus) {
        return this.ticketLevelPropagator.performUpdate(sectionX, sectionZ, this.taskScheduler.schedulingLockArea, scheduledTasks, changedFullStatus);
    }

    public List<ChunkHolder> getOldChunkHolders() {
        ArrayList<ChunkHolder> ret = new ArrayList<ChunkHolder>(this.chunkHolders.size() + 1);
        Iterator iterator = this.chunkHolders.valueIterator();
        while (iterator.hasNext()) {
            ret.add(((NewChunkHolder)iterator.next()).vanillaChunkHolder);
        }
        return ret;
    }

    public List<NewChunkHolder> getChunkHolders() {
        ArrayList<NewChunkHolder> ret = new ArrayList<NewChunkHolder>(this.chunkHolders.size() + 1);
        Iterator iterator = this.chunkHolders.valueIterator();
        while (iterator.hasNext()) {
            ret.add((NewChunkHolder)iterator.next());
        }
        return ret;
    }

    public int size() {
        return this.chunkHolders.size();
    }

    public Iterable<ChunkHolder> getOldChunkHoldersIterable() {
        return new Iterable<ChunkHolder>(){

            @Override
            public Iterator<ChunkHolder> iterator() {
                final Iterator iterator = ChunkHolderManager.this.chunkHolders.valueIterator();
                return new Iterator<ChunkHolder>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public ChunkHolder next() {
                        return ((NewChunkHolder)iterator.next()).vanillaChunkHolder;
                    }
                };
            }
        };
    }

    public void close(boolean save, boolean halt) {
        TickThread.ensureTickThread("Closing world off-main");
        if (halt) {
            LOGGER.info("Waiting 60s for chunk system to halt for world '" + WorldUtil.getWorldName(this.world) + "'");
            if (!this.taskScheduler.halt(true, TimeUnit.SECONDS.toNanos(60L))) {
                LOGGER.warn("Failed to halt generation/loading tasks for world '" + WorldUtil.getWorldName(this.world) + "'");
            } else {
                LOGGER.info("Halted chunk system for world '" + WorldUtil.getWorldName(this.world) + "'");
            }
        }
        if (save) {
            this.saveAllChunks(true, true, true, false);
        }
        MoonriseRegionFileIO.flush(this.world);
        if (halt) {
            LOGGER.info("Waiting 60s for chunk I/O to halt for world '" + WorldUtil.getWorldName(this.world) + "'");
            if (!this.taskScheduler.haltIO(true, TimeUnit.SECONDS.toNanos(60L))) {
                LOGGER.warn("Failed to halt I/O tasks for world '" + WorldUtil.getWorldName(this.world) + "'");
            } else {
                LOGGER.info("Halted I/O scheduler for world '" + WorldUtil.getWorldName(this.world) + "'");
            }
        }
        for (MoonriseRegionFileIO.RegionFileType type : MoonriseRegionFileIO.RegionFileType.values()) {
            try {
                MoonriseRegionFileIO.getControllerFor(this.world, type).getCache().close();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to close '" + type.name() + "' regionfile cache for world '" + WorldUtil.getWorldName(this.world) + "'", (Throwable)ex);
            }
        }
        this.taskScheduler.setShutdown(true);
    }

    void ensureInAutosave(NewChunkHolder holder) {
        if (!this.autoSaveQueue.contains((Object)holder)) {
            holder.lastAutoSave = this.currentTick;
            this.autoSaveQueue.add((Object)holder);
        }
    }

    public void autoSave() {
        ArrayList<NewChunkHolder> reschedule = new ArrayList<NewChunkHolder>();
        long currentTick = this.currentTick;
        long maxSaveTime = currentTick - Math.max(1L, PlatformHooks.get().configAutoSaveInterval(this.world));
        int maxToSave = PlatformHooks.get().configMaxAutoSavePerTick(this.world);
        int autoSaved = 0;
        while (autoSaved < maxToSave && !this.autoSaveQueue.isEmpty()) {
            NewChunkHolder holder = (NewChunkHolder)this.autoSaveQueue.first();
            if (holder.lastAutoSave > maxSaveTime) break;
            this.autoSaveQueue.remove((Object)holder);
            holder.lastAutoSave = currentTick;
            if (holder.save(false) != null) {
                ++autoSaved;
            }
            if (!holder.getChunkStatus().isOrAfter(FullChunkStatus.FULL)) continue;
            reschedule.add(holder);
        }
        for (NewChunkHolder holder : reschedule) {
            if (!holder.getChunkStatus().isOrAfter(FullChunkStatus.FULL)) continue;
            this.autoSaveQueue.add((Object)holder);
        }
    }

    public void saveAllChunks(boolean flush, boolean shutdown, boolean logProgress, boolean emergency) {
        NewChunkHolder holder;
        int i;
        int len;
        long start;
        List<NewChunkHolder> holders = this.getChunkHolders();
        if (logProgress) {
            if (emergency) {
                LOGGER.info("Emergency saving all chunkholders for world '" + WorldUtil.getWorldName(this.world) + "'");
            } else {
                LOGGER.info("Saving all chunkholders for world '" + WorldUtil.getWorldName(this.world) + "'");
            }
        }
        DecimalFormat format = new DecimalFormat("#0.00");
        int saved = 0;
        long lastLog = start = System.nanoTime();
        int flushInterval = 200;
        int lastFlush = 0;
        int savedChunk = 0;
        int savedEntity = 0;
        int savedPoi = 0;
        if (shutdown && !emergency) {
            len = holders.size();
            for (i = 0; i < len; ++i) {
                holder = holders.get(i);
                ChunkAccess chunkAccess = holder.getCurrentChunk();
                if (!(chunkAccess instanceof LevelChunk)) continue;
                LevelChunk levelChunk = (LevelChunk)chunkAccess;
                PlatformHooks.get().chunkUnloadFromWorld(levelChunk);
            }
        }
        len = holders.size();
        for (i = 0; i < len; ++i) {
            long currTime;
            holder = holders.get(i);
            try {
                NewChunkHolder.SaveStat saveStat = holder.save(shutdown);
                if (saveStat != null) {
                    if (saveStat.savedChunk()) {
                        ++savedChunk;
                        ++saved;
                    }
                    if (saveStat.savedEntityChunk()) {
                        ++savedEntity;
                        ++saved;
                    }
                    if (saveStat.savedPoiChunk()) {
                        ++savedPoi;
                        ++saved;
                    }
                }
            }
            catch (Throwable thr) {
                LOGGER.error("Failed to save chunk (" + holder.chunkX + "," + holder.chunkZ + ") in world '" + WorldUtil.getWorldName(this.world) + "'", thr);
            }
            if (flush && saved - lastFlush > 100) {
                lastFlush = saved;
                MoonriseRegionFileIO.partialFlush(this.world, 100);
            }
            if (!logProgress || (currTime = System.nanoTime()) - lastLog <= TimeUnit.SECONDS.toNanos(10L)) continue;
            lastLog = currTime;
            LOGGER.info("Saved " + savedChunk + " block chunks, " + savedEntity + " entity chunks, " + savedPoi + " poi chunks in world '" + WorldUtil.getWorldName(this.world) + "', progress: " + format.format((double)(i + 1) / (double)len * 100.0));
        }
        if (flush) {
            MoonriseRegionFileIO.flush(this.world);
            try {
                MoonriseRegionFileIO.flushRegionStorages(this.world);
            }
            catch (IOException ex) {
                LOGGER.error("Exception when flushing regions in world '" + WorldUtil.getWorldName(this.world) + "'", (Throwable)ex);
            }
        }
        if (logProgress) {
            LOGGER.info("Saved " + savedChunk + " block chunks, " + savedEntity + " entity chunks, " + savedPoi + " poi chunks in world '" + WorldUtil.getWorldName(this.world) + "' in " + format.format(1.0E-9 * (double)(System.nanoTime() - start)) + "s");
        }
    }

    public static int convertBetweenTicketLevels(int level) {
        return ChunkLevel.MAX_LEVEL - level + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTicketDebugString(long coordinate) {
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(CoordinateUtils.getChunkX(coordinate), CoordinateUtils.getChunkZ(coordinate));
        try {
            TicketSet tickets = (TicketSet)this.tickets.get(coordinate);
            String string = tickets != null ? tickets.first().toString() : "no_ticket";
            return string;
        }
        finally {
            if (ticketLock != null) {
                this.ticketLockArea.unlock(ticketLock);
            }
        }
    }

    public boolean hasTickets() {
        return !this.tickets.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> getTicketsAt(int chunkX, int chunkZ) {
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (!this.tickets.containsKey(key)) {
            return new ArrayList<Ticket>();
        }
        ReentrantAreaLock.Node lock = this.ticketLockArea.lock(chunkX, chunkZ);
        try {
            TicketSet tickets = (TicketSet)this.tickets.get(key);
            if (tickets == null) {
                ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                return arrayList;
            }
            ArrayList<Ticket> ret = new ArrayList<Ticket>(tickets.size());
            for (Ticket ticket : tickets) {
                ret.add(ticket);
            }
            ArrayList<Ticket> arrayList = ret;
            return arrayList;
        }
        finally {
            this.ticketLockArea.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long2ObjectOpenHashMap<Collection<Ticket>> getTicketsCopy() {
        Long2ObjectOpenHashMap ret = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap sections = new Long2ObjectOpenHashMap();
        int sectionShift = this.taskScheduler.getChunkSystemLockShift();
        PrimitiveIterator.OfLong iterator = this.tickets.keyIterator();
        while (iterator.hasNext()) {
            long coord = iterator.nextLong();
            ((LongArrayList)sections.computeIfAbsent(CoordinateUtils.getChunkKey(CoordinateUtils.getChunkX(coord) >> sectionShift, CoordinateUtils.getChunkZ(coord) >> sectionShift), keyInMap -> new LongArrayList())).add(coord);
        }
        iterator = sections.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long sectionKey = entry.getLongKey();
            LongArrayList coordinates = (LongArrayList)entry.getValue();
            ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(CoordinateUtils.getChunkX(sectionKey) << sectionShift, CoordinateUtils.getChunkZ(sectionKey) << sectionShift);
            try {
                LongListIterator iterator2 = coordinates.iterator();
                while (iterator2.hasNext()) {
                    long coord = iterator2.nextLong();
                    TicketSet tickets = (TicketSet)this.tickets.get(coord);
                    if (tickets == null) continue;
                    ret.put(coord, (Object)tickets.copy());
                }
            }
            finally {
                this.ticketLockArea.unlock(ticketLock);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Plugin> getPluginChunkTickets(int x, int z) {
        ImmutableList.Builder ret;
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(x, z);
        try {
            long coordinate = CoordinateUtils.getChunkKey(x, z);
            TicketSet tickets = (TicketSet)this.tickets.get(coordinate);
            if (tickets == null) {
                List<Plugin> list = Collections.emptyList();
                return list;
            }
            ret = ImmutableList.builder();
            for (Ticket ticket : tickets) {
                if (ticket.getType() != TicketType.PLUGIN_TICKET) continue;
                ret.add((Object)((Plugin)ticket.moonrise$getIdentifier()));
            }
        }
        finally {
            this.ticketLockArea.unlock(ticketLock);
        }
        return ret.build();
    }

    protected final void updateTicketLevel(long coordinate, int ticketLevel) {
        if (ticketLevel > ChunkLevel.MAX_LEVEL) {
            this.ticketLevelPropagator.removeSource(CoordinateUtils.getChunkX(coordinate), CoordinateUtils.getChunkZ(coordinate));
        } else {
            this.ticketLevelPropagator.setSource(CoordinateUtils.getChunkX(coordinate), CoordinateUtils.getChunkZ(coordinate), ChunkHolderManager.convertBetweenTicketLevels(ticketLevel));
        }
    }

    private static int getTicketLevelAt(TicketSet tickets) {
        return !tickets.isEmpty() ? tickets.first().getTicketLevel() : MAX_TICKET_LEVEL + 1;
    }

    public <T> boolean addTicketAtLevel(TicketType type, ChunkPos chunkPos, int level, T identifier) {
        return this.addTicketAtLevel(type, CoordinateUtils.getChunkKey(chunkPos), level, identifier);
    }

    public <T> boolean addTicketAtLevel(TicketType type, int chunkX, int chunkZ, int level, T identifier) {
        return this.addTicketAtLevel(type, CoordinateUtils.getChunkKey(chunkX, chunkZ), level, identifier);
    }

    private void addExpireCount(int chunkX, int chunkZ) {
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        int sectionShift = this.world.moonrise$getRegionChunkShift();
        long sectionKey = CoordinateUtils.getChunkKey(chunkX >> sectionShift, chunkZ >> sectionShift);
        ((Long2IntOpenHashMap)this.sectionToChunkToExpireCount.computeIfAbsent(sectionKey, keyInMap -> new Long2IntOpenHashMap())).addTo(chunkKey, 1);
    }

    private void removeExpireCount(int chunkX, int chunkZ) {
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        int sectionShift = this.world.moonrise$getRegionChunkShift();
        long sectionKey = CoordinateUtils.getChunkKey(chunkX >> sectionShift, chunkZ >> sectionShift);
        Long2IntOpenHashMap removeCounts = (Long2IntOpenHashMap)this.sectionToChunkToExpireCount.get(sectionKey);
        int prevCount = removeCounts.addTo(chunkKey, -1);
        if (prevCount == 1) {
            removeCounts.remove(chunkKey);
            if (removeCounts.isEmpty()) {
                this.sectionToChunkToExpireCount.remove(sectionKey);
            }
        }
    }

    public <T> boolean addTicketAtLevel(TicketType type, long chunk, int level, T identifier) {
        return this.addTicketAtLevel(type, chunk, level, identifier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> boolean addTicketAtLevel(TicketType type, long chunk, int level, T identifier, boolean lock) {
        long removeDelay;
        long l = removeDelay = type.timeout() <= 0L ? Long.MIN_VALUE : type.timeout();
        if (level > MAX_TICKET_LEVEL) {
            return false;
        }
        int chunkX = CoordinateUtils.getChunkX(chunk);
        int chunkZ = CoordinateUtils.getChunkZ(chunk);
        Ticket ticket = new Ticket(type, level, removeDelay);
        ((ChunkSystemTicket)ticket).moonrise$setIdentifier(identifier);
        ReentrantAreaLock.Node ticketLock = lock ? this.ticketLockArea.lock(chunkX, chunkZ) : null;
        try {
            TicketSet ticketsAtChunk = (TicketSet)this.tickets.computeIfAbsent(chunk, keyInMap -> new TicketSet(4));
            int levelBefore = ChunkHolderManager.getTicketLevelAt(ticketsAtChunk);
            Ticket current = ticketsAtChunk.replace(ticket);
            int levelAfter = ChunkHolderManager.getTicketLevelAt(ticketsAtChunk);
            if (current != ticket) {
                long oldRemoveDelay = ((ChunkSystemTicket)current).moonrise$getRemoveDelay();
                if (removeDelay != oldRemoveDelay) {
                    if (oldRemoveDelay != Long.MIN_VALUE && removeDelay == Long.MIN_VALUE) {
                        this.removeExpireCount(chunkX, chunkZ);
                    } else if (oldRemoveDelay == Long.MIN_VALUE) {
                        this.addExpireCount(chunkX, chunkZ);
                    }
                }
            } else {
                if (removeDelay != Long.MIN_VALUE) {
                    this.addExpireCount(chunkX, chunkZ);
                }
                this.addTicketCounter(type, chunk);
            }
            if (levelBefore != levelAfter) {
                this.updateTicketLevel(chunk, levelAfter);
            }
            boolean bl = current == ticket;
            return bl;
        }
        finally {
            if (ticketLock != null) {
                this.ticketLockArea.unlock(ticketLock);
            }
        }
    }

    private void addTicketCounter(TicketType type, long pos) {
        for (long counterType : ((ChunkSystemTicketType)type).moonrise$getCounterTypes()) {
            ((ConcurrentLong2LongChainedHashTable)this.ticketCounters.computeIfAbsent(counterType, counterId -> new ConcurrentLong2LongChainedHashTable())).addTo(pos, 1L, 1L);
        }
    }

    private void removeTicketCounter(TicketType type, long pos) {
        for (long counterType : ((ChunkSystemTicketType)type).moonrise$getCounterTypes()) {
            ((ConcurrentLong2LongChainedHashTable)this.ticketCounters.get(counterType)).decFrom(pos, 1L, 0L);
        }
    }

    public ConcurrentLong2LongChainedHashTable getTicketCounters(long counterType) {
        return (ConcurrentLong2LongChainedHashTable)this.ticketCounters.get(counterType);
    }

    public <T> boolean removeTicketAtLevel(TicketType type, ChunkPos chunkPos, int level, T identifier) {
        return this.removeTicketAtLevel(type, CoordinateUtils.getChunkKey(chunkPos), level, identifier);
    }

    public <T> boolean removeTicketAtLevel(TicketType type, int chunkX, int chunkZ, int level, T identifier) {
        return this.removeTicketAtLevel(type, CoordinateUtils.getChunkKey(chunkX, chunkZ), level, identifier);
    }

    public <T> boolean removeTicketAtLevel(TicketType type, long chunk, int level, T identifier) {
        return this.removeTicketAtLevel(type, chunk, level, identifier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> boolean removeTicketAtLevel(TicketType type, long chunk, int level, T identifier, boolean lock) {
        if (level > MAX_TICKET_LEVEL) {
            return false;
        }
        int chunkX = CoordinateUtils.getChunkX(chunk);
        int chunkZ = CoordinateUtils.getChunkZ(chunk);
        Ticket probe = new Ticket(type, level, 0L);
        ((ChunkSystemTicket)probe).moonrise$setIdentifier(identifier);
        ReentrantAreaLock.Node ticketLock = lock ? this.ticketLockArea.lock(chunkX, chunkZ) : null;
        try {
            long removeDelay;
            TicketSet ticketsAtChunk = (TicketSet)this.tickets.get(chunk);
            if (ticketsAtChunk == null) {
                boolean bl = false;
                return bl;
            }
            int oldLevel = ChunkHolderManager.getTicketLevelAt(ticketsAtChunk);
            Ticket ticket = ticketsAtChunk.removeAndGet(probe);
            if (ticket == null) {
                boolean bl = false;
                return bl;
            }
            int newLevel = ChunkHolderManager.getTicketLevelAt(ticketsAtChunk);
            if (oldLevel != newLevel) {
                Ticket unknownTicket = new Ticket(TicketType.UNKNOWN, level);
                if (ticketsAtChunk.add(unknownTicket)) {
                    this.addExpireCount(chunkX, chunkZ);
                    this.addTicketCounter(TicketType.UNKNOWN, chunk);
                } else {
                    throw new IllegalStateException("Should have been able to add " + String.valueOf(unknownTicket) + " to " + String.valueOf(ticketsAtChunk));
                }
            }
            if ((removeDelay = ((ChunkSystemTicket)ticket).moonrise$getRemoveDelay()) != Long.MIN_VALUE) {
                this.removeExpireCount(chunkX, chunkZ);
            }
            this.removeTicketCounter(type, chunk);
            boolean bl = true;
            return bl;
        }
        finally {
            if (ticketLock != null) {
                this.ticketLockArea.unlock(ticketLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V> void addAndRemoveTickets(long chunk, TicketType addType, int addLevel, T addIdentifier, TicketType removeType, int removeLevel, V removeIdentifier) {
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(CoordinateUtils.getChunkX(chunk), CoordinateUtils.getChunkZ(chunk));
        try {
            this.addTicketAtLevel(addType, chunk, addLevel, addIdentifier, false);
            this.removeTicketAtLevel(removeType, chunk, removeLevel, removeIdentifier, false);
        }
        finally {
            this.ticketLockArea.unlock(ticketLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V> boolean addIfRemovedTicket(long chunk, TicketType addType, int addLevel, T addIdentifier, TicketType removeType, int removeLevel, V removeIdentifier) {
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(CoordinateUtils.getChunkX(chunk), CoordinateUtils.getChunkZ(chunk));
        try {
            if (this.removeTicketAtLevel(removeType, chunk, removeLevel, removeIdentifier, false)) {
                this.addTicketAtLevel(addType, chunk, addLevel, addIdentifier, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.ticketLockArea.unlock(ticketLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void removeAllTicketsFor(TicketType ticketType, int ticketLevel, T ticketIdentifier) {
        if (ticketLevel > MAX_TICKET_LEVEL) {
            return;
        }
        Long2ObjectOpenHashMap sections = new Long2ObjectOpenHashMap();
        int sectionShift = this.taskScheduler.getChunkSystemLockShift();
        PrimitiveIterator.OfLong iterator = this.tickets.keyIterator();
        while (iterator.hasNext()) {
            long coord = iterator.nextLong();
            ((LongArrayList)sections.computeIfAbsent(CoordinateUtils.getChunkKey(CoordinateUtils.getChunkX(coord) >> sectionShift, CoordinateUtils.getChunkZ(coord) >> sectionShift), keyInMap -> new LongArrayList())).add(coord);
        }
        iterator = sections.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long sectionKey = entry.getLongKey();
            LongArrayList coordinates = (LongArrayList)entry.getValue();
            ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(CoordinateUtils.getChunkX(sectionKey) << sectionShift, CoordinateUtils.getChunkZ(sectionKey) << sectionShift);
            try {
                LongListIterator iterator2 = coordinates.iterator();
                while (iterator2.hasNext()) {
                    long coord = iterator2.nextLong();
                    this.removeTicketAtLevel(ticketType, coord, ticketLevel, ticketIdentifier, false);
                }
            }
            finally {
                this.ticketLockArea.unlock(ticketLock);
            }
        }
    }

    public static boolean tickTicket(Ticket ticket) {
        long removeDelay = ((ChunkSystemTicket)ticket).moonrise$getRemoveDelay();
        if (removeDelay == Long.MIN_VALUE) {
            return false;
        }
        ((ChunkSystemTicket)ticket).moonrise$setRemoveDelay(--removeDelay);
        return removeDelay <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        ++this.currentTick;
        int sectionShift = this.world.moonrise$getRegionChunkShift();
        ArrayList<ChunkProgressionTask> scheduledTasks = new ArrayList<ChunkProgressionTask>();
        ArrayList<NewChunkHolder> changedFullStatus = new ArrayList<NewChunkHolder>();
        Ticket[] removedList = new Ticket[4];
        PrimitiveIterator.OfLong iterator = this.sectionToChunkToExpireCount.keyIterator();
        while (iterator.hasNext()) {
            long sectionKey = iterator.nextLong();
            if (!this.sectionToChunkToExpireCount.containsKey(sectionKey)) continue;
            int lowerChunkX = CoordinateUtils.getChunkX(sectionKey) << sectionShift;
            int lowerChunkZ = CoordinateUtils.getChunkZ(sectionKey) << sectionShift;
            int ticketShift = 6;
            int ticketMask = 63;
            ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock((lowerChunkX >> 6) - 1 << 6, (lowerChunkZ >> 6) - 1 << 6, (lowerChunkX >> 6) + 1 << 6 | 0x3F, (lowerChunkZ >> 6) + 1 << 6 | 0x3F);
            try {
                Long2IntOpenHashMap chunkToExpireCount = (Long2IntOpenHashMap)this.sectionToChunkToExpireCount.get(sectionKey);
                if (chunkToExpireCount == null) continue;
                ObjectIterator iterator1 = chunkToExpireCount.long2IntEntrySet().fastIterator();
                while (iterator1.hasNext()) {
                    int newExpireCount;
                    Long2IntMap.Entry entry = (Long2IntMap.Entry)iterator1.next();
                    long chunkKey = entry.getLongKey();
                    int expireCount = entry.getIntValue();
                    TicketSet tickets = (TicketSet)this.tickets.get(chunkKey);
                    int levelBefore = ChunkHolderManager.getTicketLevelAt(tickets);
                    if (tickets.size() > removedList.length) {
                        removedList = new Ticket[tickets.size()];
                    }
                    int removed = tickets.expireAndRemoveInto(removedList);
                    int levelAfter = ChunkHolderManager.getTicketLevelAt(tickets);
                    if (tickets.isEmpty()) {
                        this.tickets.remove(chunkKey);
                    }
                    if (levelBefore != levelAfter) {
                        this.updateTicketLevel(chunkKey, levelAfter);
                    }
                    if ((newExpireCount = expireCount - removed) == expireCount) continue;
                    if (newExpireCount != 0) {
                        entry.setValue(newExpireCount);
                    } else {
                        iterator1.remove();
                    }
                    for (int i = 0; i < removed; ++i) {
                        this.removeTicketCounter(removedList[i].getType(), chunkKey);
                    }
                }
                if (chunkToExpireCount.isEmpty()) {
                    this.sectionToChunkToExpireCount.remove(sectionKey);
                }
                this.processTicketUpdatesNoLock(lowerChunkX >> 6, lowerChunkZ >> 6, scheduledTasks, changedFullStatus);
            }
            finally {
                this.ticketLockArea.unlock(ticketLock);
                continue;
            }
            this.addChangedStatuses(changedFullStatus);
            changedFullStatus.clear();
            int len = scheduledTasks.size();
            for (int i = 0; i < len; ++i) {
                ((ChunkProgressionTask)scheduledTasks.get(i)).schedule();
            }
            scheduledTasks.clear();
        }
        this.processTicketUpdates();
    }

    public NewChunkHolder getChunkHolder(int chunkX, int chunkZ) {
        return (NewChunkHolder)this.chunkHolders.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    public NewChunkHolder getChunkHolder(long position) {
        return (NewChunkHolder)this.chunkHolders.get(position);
    }

    public void raisePriority(int x, int z, Priority priority) {
        NewChunkHolder chunkHolder = this.getChunkHolder(x, z);
        if (chunkHolder != null) {
            chunkHolder.raisePriority(priority);
        }
    }

    public void setPriority(int x, int z, Priority priority) {
        NewChunkHolder chunkHolder = this.getChunkHolder(x, z);
        if (chunkHolder != null) {
            chunkHolder.setPriority(priority);
        }
    }

    public void lowerPriority(int x, int z, Priority priority) {
        NewChunkHolder chunkHolder = this.getChunkHolder(x, z);
        if (chunkHolder != null) {
            chunkHolder.lowerPriority(priority);
        }
    }

    private NewChunkHolder createChunkHolder(long position) {
        NewChunkHolder ret = new NewChunkHolder(this.world, CoordinateUtils.getChunkX(position), CoordinateUtils.getChunkZ(position), this.taskScheduler);
        PlatformHooks.get().onChunkHolderCreate(this.world, ret.vanillaChunkHolder);
        return ret;
    }

    private NewChunkHolder getOrCreateChunkHolder(int chunkX, int chunkZ) {
        return this.getOrCreateChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    private NewChunkHolder getOrCreateChunkHolder(long position) {
        int chunkZ;
        int chunkX = CoordinateUtils.getChunkX(position);
        if (!this.ticketLockArea.isHeldByCurrentThread(chunkX, chunkZ = CoordinateUtils.getChunkZ(position))) {
            throw new IllegalStateException("Must hold ticket level update lock!");
        }
        if (!this.taskScheduler.schedulingLockArea.isHeldByCurrentThread(chunkX, chunkZ)) {
            throw new IllegalStateException("Must hold scheduler lock!!");
        }
        NewChunkHolder current = (NewChunkHolder)this.chunkHolders.get(position);
        if (current != null) {
            return current;
        }
        current = this.createChunkHolder(position);
        this.chunkHolders.put(position, (Object)current);
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkEntitySlices getOrCreateEntityChunk(int chunkX, int chunkZ, boolean transientChunk) {
        ChunkEntitySlices ret;
        TickThread.ensureTickThread((Level)this.world, chunkX, chunkZ, "Cannot create entity chunk off-main");
        NewChunkHolder current = this.getChunkHolder(chunkX, chunkZ);
        if (current != null && (ret = current.getEntityChunk()) != null && (transientChunk || !ret.isTransient())) {
            return ret;
        }
        AtomicBoolean isCompleted = new AtomicBoolean();
        Thread waiter = Thread.currentThread();
        Long entityLoadId = ChunkTaskScheduler.getNextEntityLoadId();
        NewChunkHolder.GenericDataLoadTaskCallback loadTask = null;
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(chunkX, chunkZ);
        try {
            this.addTicketAtLevel(ChunkTaskScheduler.ENTITY_LOAD, chunkX, chunkZ, MAX_TICKET_LEVEL, entityLoadId);
            ReentrantAreaLock.Node schedulingLock = this.taskScheduler.schedulingLockArea.lock(chunkX, chunkZ);
            try {
                current = this.getOrCreateChunkHolder(chunkX, chunkZ);
                ret = current.getEntityChunk();
                if (ret != null && (transientChunk || !ret.isTransient())) {
                    this.removeTicketAtLevel(ChunkTaskScheduler.ENTITY_LOAD, chunkX, chunkZ, MAX_TICKET_LEVEL, entityLoadId);
                    ChunkEntitySlices chunkEntitySlices = ret;
                    return chunkEntitySlices;
                }
                if (!transientChunk) {
                    if (current.isEntityChunkNBTLoaded()) {
                        isCompleted.setPlain(true);
                    } else {
                        loadTask = current.getOrLoadEntityData(result -> {
                            isCompleted.set(true);
                            LockSupport.unpark(waiter);
                        });
                        ChunkLoadTask.EntityDataLoadTask entityLoad = current.getEntityDataLoadTask();
                        if (entityLoad != null) {
                            entityLoad.raisePriority(Priority.BLOCKING);
                        }
                    }
                }
            }
            finally {
                this.taskScheduler.schedulingLockArea.unlock(schedulingLock);
            }
        }
        finally {
            this.ticketLockArea.unlock(ticketLock);
        }
        if (loadTask != null) {
            loadTask.schedule();
        }
        if (!transientChunk) {
            boolean interrupted = false;
            while (!isCompleted.get()) {
                interrupted |= Thread.interrupted();
                LockSupport.park();
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        ret = current.loadInEntityChunk(transientChunk);
        this.removeTicketAtLevel(ChunkTaskScheduler.ENTITY_LOAD, chunkX, chunkZ, MAX_TICKET_LEVEL, entityLoadId);
        return ret;
    }

    public PoiChunk getPoiChunkIfLoaded(int chunkX, int chunkZ, boolean checkLoadInCallback) {
        NewChunkHolder holder = this.getChunkHolder(chunkX, chunkZ);
        if (holder != null) {
            PoiChunk ret = holder.getPoiChunk();
            return ret == null || checkLoadInCallback && !ret.isLoaded() ? null : ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoiChunk loadPoiChunk(int chunkX, int chunkZ) {
        PoiChunk ret;
        TickThread.ensureTickThread((Level)this.world, chunkX, chunkZ, "Cannot create poi chunk off-main");
        NewChunkHolder current = this.getChunkHolder(chunkX, chunkZ);
        if (current != null && (ret = current.getPoiChunk()) != null) {
            ret.load();
            return ret;
        }
        AtomicReference completed = new AtomicReference();
        AtomicBoolean isCompleted = new AtomicBoolean();
        Thread waiter = Thread.currentThread();
        Long poiLoadId = ChunkTaskScheduler.getNextPoiLoadId();
        NewChunkHolder.GenericDataLoadTaskCallback loadTask = null;
        ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(chunkX, chunkZ);
        try {
            this.addTicketAtLevel(ChunkTaskScheduler.POI_LOAD, chunkX, chunkZ, MAX_TICKET_LEVEL, poiLoadId);
            ReentrantAreaLock.Node schedulingLock = this.taskScheduler.schedulingLockArea.lock(chunkX, chunkZ);
            try {
                current = this.getOrCreateChunkHolder(chunkX, chunkZ);
                ret = current.getPoiChunk();
                if (null == ret) {
                    loadTask = current.getOrLoadPoiData(result -> {
                        completed.setPlain((PoiChunk)result.left());
                        isCompleted.set(true);
                        LockSupport.unpark(waiter);
                    });
                    ChunkLoadTask.PoiDataLoadTask poiLoad = current.getPoiDataLoadTask();
                    if (poiLoad != null) {
                        poiLoad.raisePriority(Priority.BLOCKING);
                    }
                }
            }
            finally {
                this.taskScheduler.schedulingLockArea.unlock(schedulingLock);
            }
        }
        finally {
            this.ticketLockArea.unlock(ticketLock);
        }
        if (loadTask != null) {
            loadTask.schedule();
            boolean interrupted = false;
            while (!isCompleted.get()) {
                interrupted |= Thread.interrupted();
                LockSupport.park();
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            ret = (PoiChunk)completed.getPlain();
        }
        ret.load();
        this.removeTicketAtLevel(ChunkTaskScheduler.POI_LOAD, chunkX, chunkZ, MAX_TICKET_LEVEL, poiLoadId);
        return ret;
    }

    void addChangedStatuses(List<NewChunkHolder> changedFullStatus) {
        if (changedFullStatus.isEmpty()) {
            return;
        }
        if (!TickThread.isTickThread()) {
            this.offThreadPendingFullLoadUpdate.addAll(changedFullStatus);
        } else {
            ArrayDeque<NewChunkHolder> pendingFullLoadUpdate = this.pendingFullLoadUpdate;
            int len = changedFullStatus.size();
            for (int i = 0; i < len; ++i) {
                pendingFullLoadUpdate.add(changedFullStatus.get(i));
            }
        }
    }

    private void removeChunkHolder(NewChunkHolder holder) {
        holder.onUnload();
        this.autoSaveQueue.remove((Object)holder);
        PlatformHooks.get().onChunkHolderDelete(this.world, holder.vanillaChunkHolder);
        this.chunkHolders.remove(CoordinateUtils.getChunkKey(holder.chunkX, holder.chunkZ));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUnloads() {
        TickThread.ensureTickThread("Cannot unload chunks off-main");
        if (this.BLOCK_TICKET_UPDATES.get() == Boolean.TRUE) {
            throw new IllegalStateException("Cannot unload chunks recursively");
        }
        int sectionShift = this.unloadQueue.coordinateShift;
        List<ChunkUnloadQueue.SectionToUnload> unloadSectionsForRegion = this.unloadQueue.retrieveForAllRegions();
        int unloadCountTentative = 0;
        for (ChunkUnloadQueue.SectionToUnload sectionRef : unloadSectionsForRegion) {
            ChunkUnloadQueue.UnloadSection section = this.unloadQueue.getSectionUnsynchronized(sectionRef.sectionX(), sectionRef.sectionZ());
            if (section == null) continue;
            unloadCountTentative += section.chunks.size();
        }
        if (unloadCountTentative <= 0) {
            return;
        }
        this.processTicketUpdates();
        int toUnloadCount = Math.max(50, (int)((double)unloadCountTentative * 0.05));
        int processedCount = 0;
        for (ChunkUnloadQueue.SectionToUnload sectionRef : unloadSectionsForRegion) {
            NewChunkHolder holder;
            int i;
            int len;
            ArrayList<NewChunkHolder> stage1 = new ArrayList<NewChunkHolder>();
            ArrayList<NewChunkHolder.UnloadState> stage2 = new ArrayList<NewChunkHolder.UnloadState>();
            int sectionLowerX = sectionRef.sectionX() << sectionShift;
            int sectionLowerZ = sectionRef.sectionZ() << sectionShift;
            ReentrantAreaLock.Node ticketLock = this.ticketLockArea.lock(sectionLowerX, sectionLowerZ);
            try {
                ReentrantAreaLock.Node scheduleLock = this.taskScheduler.schedulingLockArea.lock(sectionLowerX, sectionLowerZ);
                try {
                    ChunkUnloadQueue.UnloadSection section = this.unloadQueue.getSectionUnsynchronized(sectionRef.sectionX(), sectionRef.sectionZ());
                    if (section == null) continue;
                    int sectionCount = section.chunks.size();
                    if (sectionCount + processedCount <= toUnloadCount) {
                        LongListIterator iterator = section.chunks.iterator();
                        while (iterator.hasNext()) {
                            NewChunkHolder holder2 = (NewChunkHolder)this.chunkHolders.get(iterator.nextLong());
                            if (holder2 == null) {
                                throw new IllegalStateException();
                            }
                            stage1.add(holder2);
                        }
                        this.unloadQueue.removeSection(sectionRef.sectionX(), sectionRef.sectionZ());
                    } else {
                        len = toUnloadCount - processedCount;
                        for (i = 0; i < len; ++i) {
                            holder = (NewChunkHolder)this.chunkHolders.get(section.chunks.removeFirstLong());
                            if (holder == null) {
                                throw new IllegalStateException();
                            }
                            stage1.add(holder);
                        }
                    }
                    int len2 = stage1.size();
                    for (i = 0; i < len2; ++i) {
                        NewChunkHolder chunkHolder = (NewChunkHolder)stage1.get(i);
                        chunkHolder.removeFromUnloadQueue();
                        if (chunkHolder.isSafeToUnload() != null) {
                            LOGGER.error("Chunkholder " + String.valueOf(chunkHolder) + " is not safe to unload but is inside the unload queue?");
                            continue;
                        }
                        NewChunkHolder.UnloadState state = chunkHolder.unloadStage1();
                        if (state == null) {
                            this.removeChunkHolder(chunkHolder);
                            continue;
                        }
                        stage2.add(state);
                    }
                }
                finally {
                    this.taskScheduler.schedulingLockArea.unlock(scheduleLock);
                    continue;
                }
            }
            finally {
                this.ticketLockArea.unlock(ticketLock);
                continue;
            }
            ArrayList<NewChunkHolder> stage3 = new ArrayList<NewChunkHolder>(stage2.size());
            Boolean before = this.blockTicketUpdates();
            try {
                int len3 = stage2.size();
                for (int i2 = 0; i2 < len3; ++i2) {
                    NewChunkHolder.UnloadState state = (NewChunkHolder.UnloadState)stage2.get(i2);
                    holder = state.holder();
                    holder.unloadStage2(state);
                    stage3.add(holder);
                }
            }
            finally {
                this.unblockTicketUpdates(before);
            }
            ticketLock = this.ticketLockArea.lock(sectionLowerX, sectionLowerZ);
            try {
                ReentrantAreaLock.Node scheduleLock = this.taskScheduler.schedulingLockArea.lock(sectionLowerX, sectionLowerZ);
                try {
                    len = stage3.size();
                    for (i = 0; i < len; ++i) {
                        holder = (NewChunkHolder)stage3.get(i);
                        if (holder.unloadStage3()) {
                            this.removeChunkHolder(holder);
                            continue;
                        }
                        this.addTicketAtLevel(UNLOAD_COOLDOWN, CoordinateUtils.getChunkKey(holder.chunkX, holder.chunkZ), MAX_TICKET_LEVEL, null, false);
                    }
                }
                finally {
                    this.taskScheduler.schedulingLockArea.unlock(scheduleLock);
                }
            }
            finally {
                this.ticketLockArea.unlock(ticketLock);
            }
            if ((processedCount += stage1.size()) < toUnloadCount) continue;
            break;
        }
    }

    private <T, V> boolean processTicketOp(TicketOperation<T, V> operation) {
        boolean ret = false;
        switch (operation.op.ordinal()) {
            case 0: {
                ret |= this.addTicketAtLevel(operation.ticketType, operation.chunkCoord, operation.ticketLevel, operation.identifier);
                break;
            }
            case 1: {
                ret |= this.removeTicketAtLevel(operation.ticketType, operation.chunkCoord, operation.ticketLevel, operation.identifier);
                break;
            }
            case 2: {
                ret |= this.addIfRemovedTicket(operation.chunkCoord, operation.ticketType, operation.ticketLevel, operation.identifier, operation.ticketType2, operation.ticketLevel2, operation.identifier2);
                break;
            }
            case 3: {
                ret = true;
                this.addAndRemoveTickets(operation.chunkCoord, operation.ticketType, operation.ticketLevel, operation.identifier, operation.ticketType2, operation.ticketLevel2, operation.identifier2);
            }
        }
        return ret;
    }

    public void performTicketUpdates(Collection<TicketOperation<?, ?>> operations) {
        for (TicketOperation<?, ?> operation : operations) {
            this.processTicketOp(operation);
        }
    }

    public Boolean blockTicketUpdates() {
        Boolean ret = this.BLOCK_TICKET_UPDATES.get();
        this.BLOCK_TICKET_UPDATES.set(Boolean.TRUE);
        return ret;
    }

    public void unblockTicketUpdates(Boolean before) {
        this.BLOCK_TICKET_UPDATES.set(before);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTicketUpdates() {
        if (this.BLOCK_TICKET_UPDATES.get() == Boolean.TRUE) {
            throw new IllegalStateException("Cannot update ticket level while unloading chunks or updating entity manager");
        }
        boolean isTickThread = TickThread.isTickThread();
        if (!PlatformHooks.get().allowAsyncTicketUpdates() && isTickThread) {
            TickThread.ensureTickThread("Cannot asynchronously process ticket updates");
        }
        boolean ret = false;
        if (this.ticketLevelPropagator.hasPendingUpdates()) {
            ArrayList<ChunkProgressionTask> scheduledTasks = new ArrayList<ChunkProgressionTask>();
            ArrayList<NewChunkHolder> changedFullStatus = new ArrayList<NewChunkHolder>();
            this.blockTicketUpdates();
            try {
                ret |= this.ticketLevelPropagator.performUpdates(this.ticketLockArea, this.taskScheduler.schedulingLockArea, scheduledTasks, changedFullStatus);
            }
            finally {
                this.unblockTicketUpdates(Boolean.FALSE);
            }
            this.addChangedStatuses(changedFullStatus);
            int len = scheduledTasks.size();
            for (int i = 0; i < len; ++i) {
                ((ChunkProgressionTask)scheduledTasks.get(i)).schedule();
            }
        }
        if (isTickThread) {
            ret |= this.processPendingFullUpdate();
        }
        return ret;
    }

    static List<ChunkProgressionTask> getCurrentTicketUpdateScheduling() {
        return CURRENT_TICKET_UPDATE_SCHEDULING.get();
    }

    private void processOffThreadFullUpdates() {
        NewChunkHolder toUpdate;
        ArrayDeque<NewChunkHolder> pendingFullLoadUpdate = this.pendingFullLoadUpdate;
        MultiThreadedQueue<NewChunkHolder> offThreadPendingFullLoadUpdate = this.offThreadPendingFullLoadUpdate;
        while ((toUpdate = (NewChunkHolder)offThreadPendingFullLoadUpdate.poll()) != null) {
            pendingFullLoadUpdate.add(toUpdate);
        }
    }

    private boolean processPendingFullUpdate() {
        NewChunkHolder holder;
        this.processOffThreadFullUpdates();
        ArrayDeque<NewChunkHolder> pendingFullLoadUpdate = this.pendingFullLoadUpdate;
        boolean ret = false;
        if (pendingFullLoadUpdate.isEmpty()) {
            return ret;
        }
        ArrayList<NewChunkHolder> changedFullStatus = new ArrayList<NewChunkHolder>();
        while ((holder = pendingFullLoadUpdate.poll()) != null) {
            ret |= holder.handleFullStatusChange(changedFullStatus);
            if (changedFullStatus.isEmpty()) continue;
            int len = changedFullStatus.size();
            for (int i = 0; i < len; ++i) {
                pendingFullLoadUpdate.add((NewChunkHolder)changedFullStatus.get(i));
            }
            changedFullStatus.clear();
        }
        return ret;
    }

    public CompletableFuture<?> addTicketAndLoadWithRadius(TicketType ticketType, ChunkPos chunkPos, int radius, ChunkStatus status, Priority priority) {
        CompletableFuture future = new CompletableFuture();
        this.world.moonrise$loadChunksAsync(chunkPos.getMiddleBlockPosition(0), radius << 4, status, priority, holders -> future.complete(null));
        return future;
    }

    public JsonObject getDebugJson() {
        JsonObject ret = new JsonObject();
        ret.add("unload_queue", this.unloadQueue.toDebugJson());
        JsonArray holders = new JsonArray();
        ret.add("chunkholders", (JsonElement)holders);
        for (NewChunkHolder holder : this.getChunkHolders()) {
            holders.add((JsonElement)holder.getDebugJson());
        }
        JsonArray allTicketsJson = new JsonArray();
        ret.add("tickets", (JsonElement)allTicketsJson);
        Iterator iterator = this.tickets.entryIterator();
        while (iterator.hasNext()) {
            ConcurrentLong2ReferenceChainedHashTable.TableEntry coordinateTickets = (ConcurrentLong2ReferenceChainedHashTable.TableEntry)iterator.next();
            long coordinate = coordinateTickets.getKey();
            TicketSet tickets = (TicketSet)coordinateTickets.getValue();
            JsonObject coordinateJson = new JsonObject();
            allTicketsJson.add((JsonElement)coordinateJson);
            coordinateJson.addProperty("chunkX", (Number)CoordinateUtils.getChunkX(coordinate));
            coordinateJson.addProperty("chunkZ", (Number)CoordinateUtils.getChunkZ(coordinate));
            JsonArray ticketsSerialized = new JsonArray();
            coordinateJson.add("tickets", (JsonElement)ticketsSerialized);
            for (Ticket ticket : tickets.copyBackingArray()) {
                if (ticket == null) continue;
                JsonObject ticketSerialized = new JsonObject();
                ticketsSerialized.add((JsonElement)ticketSerialized);
                ticketSerialized.addProperty("type", ticket.getType().toString());
                ticketSerialized.addProperty("level", (Number)ticket.getTicketLevel());
                ticketSerialized.addProperty("identifier", Objects.toString(((ChunkSystemTicket)ticket).moonrise$getIdentifier()));
                ticketSerialized.addProperty("remove_tick", (Number)((ChunkSystemTicket)ticket).moonrise$getRemoveDelay());
            }
        }
        return ret;
    }

    public record TicketOperation<T, V>(TicketOperationType op, long chunkCoord, TicketType ticketType, int ticketLevel, T identifier, TicketType ticketType2, int ticketLevel2, V identifier2) {
        private TicketOperation(TicketOperationType op, long chunkCoord, TicketType ticketType, int ticketLevel, T identifier) {
            this(op, chunkCoord, ticketType, ticketLevel, identifier, null, 0, null);
        }

        public static <T> TicketOperation<T, T> addOp(ChunkPos chunk, TicketType type, int ticketLevel, T identifier) {
            return TicketOperation.addOp(CoordinateUtils.getChunkKey(chunk), type, ticketLevel, identifier);
        }

        public static <T> TicketOperation<T, T> addOp(int chunkX, int chunkZ, TicketType type, int ticketLevel, T identifier) {
            return TicketOperation.addOp(CoordinateUtils.getChunkKey(chunkX, chunkZ), type, ticketLevel, identifier);
        }

        public static <T> TicketOperation<T, T> addOp(long chunk, TicketType type, int ticketLevel, T identifier) {
            return new TicketOperation(TicketOperationType.ADD, chunk, type, ticketLevel, identifier);
        }

        public static <T> TicketOperation<T, T> removeOp(ChunkPos chunk, TicketType type, int ticketLevel, T identifier) {
            return TicketOperation.removeOp(CoordinateUtils.getChunkKey(chunk), type, ticketLevel, identifier);
        }

        public static <T> TicketOperation<T, T> removeOp(int chunkX, int chunkZ, TicketType type, int ticketLevel, T identifier) {
            return TicketOperation.removeOp(CoordinateUtils.getChunkKey(chunkX, chunkZ), type, ticketLevel, identifier);
        }

        public static <T> TicketOperation<T, T> removeOp(long chunk, TicketType type, int ticketLevel, T identifier) {
            return new TicketOperation(TicketOperationType.REMOVE, chunk, type, ticketLevel, identifier);
        }

        public static <T, V> TicketOperation<T, V> addIfRemovedOp(long chunk, TicketType addType, int addLevel, T addIdentifier, TicketType removeType, int removeLevel, V removeIdentifier) {
            return new TicketOperation<T, V>(TicketOperationType.ADD_IF_REMOVED, chunk, addType, addLevel, addIdentifier, removeType, removeLevel, removeIdentifier);
        }

        public static <T, V> TicketOperation<T, V> addAndRemove(long chunk, TicketType addType, int addLevel, T addIdentifier, TicketType removeType, int removeLevel, V removeIdentifier) {
            return new TicketOperation<T, V>(TicketOperationType.ADD_AND_REMOVE, chunk, addType, addLevel, addIdentifier, removeType, removeLevel, removeIdentifier);
        }
    }

    public static enum TicketOperationType {
        ADD,
        REMOVE,
        ADD_IF_REMOVED,
        ADD_AND_REMOVE;

    }
}

