/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.util.stream;

import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.server.level.Ticket;

public final class TicketSet
extends AbstractSet<Ticket> {
    private Ticket[] tickets;
    private int size;

    public TicketSet(int initialCapacity) {
        this.tickets = new Ticket[initialCapacity];
    }

    private TicketSet(Ticket[] tickets, int size) {
        this.tickets = tickets;
        this.size = size;
    }

    private static int binarySearch(Ticket[] tickets, int start, int end, Ticket key) {
        Objects.checkFromToIndex(start, end, tickets.length);
        --end;
        while (start <= end) {
            int middle = start + end >>> 1;
            Ticket ticket = tickets[middle];
            int cmp = ticket.compareTo(key);
            if (cmp < 0) {
                start = middle + 1;
                continue;
            }
            if (cmp > 0) {
                end = middle - 1;
                continue;
            }
            return middle;
        }
        return ~start;
    }

    private void expand() {
        int newSize = this.tickets.length + (this.tickets.length >> 1);
        if (newSize < 0 && (newSize = Integer.MAX_VALUE) == this.tickets.length) {
            throw new IllegalStateException("Cannot service more than Integer.MAX_VALUE elements!");
        }
        newSize = Math.max(4, newSize);
        this.tickets = Arrays.copyOf(this.tickets, newSize);
    }

    private void checkCapacity(int size) {
        if (size <= this.tickets.length) {
            return;
        }
        this.expand();
    }

    private void addAt(int index, Ticket ticket) {
        this.checkCapacity(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.tickets, index, this.tickets, index + 1, this.size - index);
        }
        ++this.size;
        this.tickets[index] = ticket;
    }

    private void removeAt(int index) {
        if (index != --this.size) {
            System.arraycopy(this.tickets, index + 1, this.tickets, index, this.size - index);
        }
        this.tickets[this.size] = null;
    }

    public TicketSet copy() {
        int size = this.size;
        return new TicketSet(Arrays.copyOf(this.tickets, size), size);
    }

    public Ticket[] copyBackingArray() {
        return (Ticket[])this.tickets.clone();
    }

    public Ticket replace(Ticket object) {
        int index = TicketSet.binarySearch(this.tickets, 0, this.size, object);
        if (index >= 0) {
            Ticket old = this.tickets[index];
            this.tickets[index] = object;
            return old;
        }
        this.addAt(~index, object);
        return object;
    }

    public Ticket removeAndGet(Ticket object) {
        int idx = TicketSet.binarySearch(this.tickets, 0, this.size, object);
        if (idx < 0) {
            return null;
        }
        Ticket ret = this.tickets[idx];
        this.removeAt(idx);
        return ret;
    }

    public Ticket first() {
        Objects.checkIndex(0, this.size);
        return this.tickets[0];
    }

    public Ticket last() {
        Objects.checkIndex(this.size - 1, this.size);
        return this.tickets[this.size - 1];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean add(Ticket ticket) {
        int index = TicketSet.binarySearch(this.tickets, 0, this.size, ticket);
        if (index >= 0) {
            return false;
        }
        this.addAt(~index, ticket);
        return true;
    }

    @Override
    public boolean remove(Object value) {
        int idx = TicketSet.binarySearch(this.tickets, 0, this.size, (Ticket)value);
        if (idx < 0) {
            return false;
        }
        this.removeAt(idx);
        return true;
    }

    public int expireAndRemoveInto(Ticket[] array) {
        Ticket ticket;
        Objects.checkFromIndexSize(0, this.size, array.length);
        int removed = 0;
        int i = 0;
        int len = this.size;
        Object[] tickets = this.tickets;
        do {
            if (i < len) continue;
            return removed;
        } while (!ChunkHolderManager.tickTicket(ticket = tickets[i++]));
        array[removed++] = ticket;
        int lastIndex = i - 1;
        while (i < len) {
            Ticket curr = tickets[i];
            if (!ChunkHolderManager.tickTicket(curr)) {
                tickets[lastIndex++] = curr;
            } else {
                array[removed++] = curr;
            }
            ++i;
        }
        Arrays.fill(tickets, lastIndex, len, null);
        this.size = lastIndex;
        return removed;
    }

    @Override
    public Iterator<Ticket> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<Ticket> {
        private static final int REMOVED = -1;
        private int index;
        private int lastReturned = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.index < TicketSet.this.size;
        }

        @Override
        public Ticket next() {
            if (this.index >= TicketSet.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.index++;
            return TicketSet.this.tickets[this.lastReturned];
        }

        @Override
        public void remove() {
            int lastReturned = this.lastReturned;
            if (lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.lastReturned = -1;
            this.index = lastReturned;
            TicketSet.this.removeAt(lastReturned);
        }

        @Override
        public void forEachRemaining(Consumer<? super Ticket> action) {
            Objects.requireNonNull(action);
            while (this.hasNext()) {
                action.accept(this.next());
            }
        }
    }
}

