/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.destroystokyo.paper.VersionHistoryManager;
import com.destroystokyo.paper.util.VersionFetcher;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import io.papermc.paper.ServerBuildInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.OptionalInt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.slf4j.Logger;

@DefaultQualifier(value=NonNull.class)
public class PaperVersionFetcher
implements VersionFetcher {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private static final int DISTANCE_ERROR = -1;
    private static final int DISTANCE_UNKNOWN = -2;
    private static final String DOWNLOAD_PAGE = "https://purpurmc.org/downloads";
    private static int distance = -2;

    public int distance() {
        return distance;
    }

    public long getCacheTime() {
        return 720000L;
    }

    public Component getVersionMessage() {
        ServerBuildInfo build = ServerBuildInfo.buildInfo();
        Object updateMessage = build.buildNumber().isEmpty() && build.gitCommit().isEmpty() ? Component.text((String)"You are running a development version without access to version information", (TextColor)TextColor.color((int)16732928)) : PaperVersionFetcher.getUpdateStatusMessage("PurpurMC/Purpur", build);
        @Nullable Component history = this.getHistory();
        return history != null ? Component.textOfChildren((ComponentLike[])new ComponentLike[]{updateMessage, Component.newline(), history}) : updateMessage;
    }

    private static Component getUpdateStatusMessage(String repo, ServerBuildInfo build) {
        OptionalInt buildNumber = build.buildNumber();
        if (buildNumber.isPresent()) {
            distance = PaperVersionFetcher.fetchDistanceFromSiteApi(build, buildNumber.getAsInt());
        } else {
            Optional gitBranch = build.gitBranch();
            Optional gitCommit = build.gitCommit();
            if (gitBranch.isPresent() && gitCommit.isPresent()) {
                distance = PaperVersionFetcher.fetchDistanceFromGitHub(repo, (String)gitBranch.get(), (String)gitCommit.get());
            }
        }
        return switch (distance) {
            case -1 -> Component.text((String)"* Error obtaining version information", (TextColor)NamedTextColor.RED);
            case 0 -> Component.text((String)"* You are running the latest version", (TextColor)NamedTextColor.GREEN);
            case -2 -> Component.text((String)"* Unknown version", (TextColor)NamedTextColor.YELLOW);
            default -> (TextComponent)((TextComponent)Component.text((String)("* You are " + distance + " version(s) behind"), (TextColor)NamedTextColor.YELLOW).append((Component)Component.newline())).append(Component.text((String)"Download the new version at: ").append(((TextComponent)Component.text((String)DOWNLOAD_PAGE, (TextColor)NamedTextColor.GOLD).hoverEvent((HoverEventSource)Component.text((String)"Click to open", (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.openUrl((String)DOWNLOAD_PAGE))));
        };
    }

    private static int fetchDistanceFromSiteApi(ServerBuildInfo build, int jenkinsBuild) {
        int n;
        block10: {
            BufferedReader reader = Resources.asCharSource((URL)URI.create("https://api.purpurmc.org/v2/purpur/" + build.minecraftVersionId()).toURL(), (Charset)StandardCharsets.UTF_8).openBufferedStream();
            try {
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                int latest = json.getAsJsonObject("builds").getAsJsonPrimitive("latest").getAsInt();
                n = latest - jenkinsBuild;
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonSyntaxException ex) {
                        LOGGER.error("Error parsing json from Purpur's downloads API", (Throwable)ex);
                        return -1;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error while parsing version", (Throwable)e);
                    return -1;
                }
            }
            reader.close();
        }
        return n;
    }

    private static int fetchDistanceFromGitHub(String repo, String branch, String hash) {
        int n;
        HttpURLConnection connection = (HttpURLConnection)URI.create("https://api.github.com/repos/%s/compare/%s...%s".formatted(repo, branch, hash)).toURL().openConnection();
        connection.connect();
        if (connection.getResponseCode() == 404) {
            return -2;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        try {
            String status;
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            n = switch (status = obj.get("status").getAsString()) {
                case "identical" -> 0;
                case "behind" -> obj.get("behind_by").getAsInt();
                default -> -1;
            };
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException | NumberFormatException e) {
                    LOGGER.error("Error parsing json from GitHub's API", e);
                    return -1;
                }
            }
            catch (IOException e) {
                LOGGER.error("Error while parsing version", (Throwable)e);
                return -1;
            }
        }
        reader.close();
        return n;
    }

    private @Nullable Component getHistory() {
        @Nullable VersionHistoryManager.VersionData data = VersionHistoryManager.INSTANCE.getVersionData();
        if (data == null) {
            return null;
        }
        @Nullable String oldVersion = data.getOldVersion();
        if (oldVersion == null) {
            return null;
        }
        return Component.text((String)("Previous: " + oldVersion), (TextColor)NamedTextColor.GRAY);
    }
}

