/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.console;

import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.console.BrigadierCommandHighlighter;
import io.papermc.paper.console.BrigadierCompletionMatcher;
import io.papermc.paper.console.BrigadierConsoleParser;
import java.nio.file.Paths;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecrell.terminalconsole.SimpleTerminalConsole;
import org.bukkit.craftbukkit.command.ConsoleCommandCompleter;
import org.jline.reader.Completer;
import org.jline.reader.CompletionMatcher;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;

public final class PaperConsole
extends SimpleTerminalConsole {
    private final DedicatedServer server;

    public PaperConsole(DedicatedServer server) {
        this.server = server;
    }

    protected LineReader buildReader(LineReaderBuilder builder) {
        builder.appName("Purpur").variable("history-file", (Object)Paths.get(".console_history", new String[0])).completer((Completer)new ConsoleCommandCompleter(this.server)).option(LineReader.Option.COMPLETE_IN_WORD, true);
        if (GlobalConfiguration.get().console.enableBrigadierHighlighting) {
            builder.highlighter((Highlighter)new BrigadierCommandHighlighter(this.server));
        }
        if (GlobalConfiguration.get().console.enableBrigadierCompletions) {
            System.setProperty("org.jline.reader.support.parsedline", "true");
            builder.parser((Parser)new BrigadierConsoleParser(this.server));
            builder.completionMatcher((CompletionMatcher)new BrigadierCompletionMatcher());
        }
        return super.buildReader(builder);
    }

    protected boolean isRunning() {
        return !this.server.isStopped() && this.server.isRunning();
    }

    protected void runCommand(String command) {
        this.server.handleConsoleInput(command, this.server.createCommandSourceStack());
    }

    protected void shutdown() {
        this.server.halt(false);
    }
}

