/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.profile;

import com.destroystokyo.paper.event.profile.LookupProfileEvent;
import com.destroystokyo.paper.event.profile.PreLookupProfileEvent;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.collect.Sets;
import com.mojang.authlib.Environment;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.YggdrasilGameProfileRepository;
import com.mojang.authlib.yggdrasil.response.NameAndId;
import java.net.Proxy;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;

public class PaperGameProfileRepository
extends YggdrasilGameProfileRepository {
    public PaperGameProfileRepository(Proxy proxy, Environment environment) {
        super(proxy, environment);
    }

    @Override
    public void findProfilesByNames(String[] names, ProfileLookupCallback callback) {
        HashSet unfoundNames = Sets.newHashSet();
        for (String name : names) {
            PreLookupProfileEvent event = new PreLookupProfileEvent(name);
            event.callEvent();
            if (event.getUUID() != null) {
                callback.onProfileLookupSucceeded(name, event.getUUID());
                continue;
            }
            unfoundNames.add(name);
        }
        if (!unfoundNames.isEmpty()) {
            String[] namesArr = unfoundNames.toArray(new String[unfoundNames.size()]);
            super.findProfilesByNames(namesArr, new PreProfileLookupCallback(callback));
        }
    }

    @Override
    public Optional<NameAndId> findProfileByName(String name) {
        PreLookupProfileEvent event = new PreLookupProfileEvent(name);
        event.callEvent();
        if (event.getUUID() != null) {
            return Optional.of(new NameAndId(event.getUUID(), name));
        }
        return super.findProfileByName(name);
    }

    private record PreProfileLookupCallback(ProfileLookupCallback callback) implements ProfileLookupCallback
    {
        public void onProfileLookupSucceeded(String profileName, UUID profileId) {
            CraftPlayerProfile from = new CraftPlayerProfile(profileId, profileName);
            new LookupProfileEvent((PlayerProfile)from).callEvent();
            this.callback.onProfileLookupSucceeded(profileName, profileId);
        }

        public void onProfileLookupFailed(String profileName, Exception exception) {
            this.callback.onProfileLookupFailed(profileName, exception);
        }
    }
}

