/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.mapping;

import io.leangen.geantyref.GenericTypeReflector;
import io.papermc.paper.configuration.ConfigurationPart;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.mapping.Definition;
import io.papermc.paper.configuration.mapping.DeserializedFieldInfo;
import io.papermc.paper.configuration.mapping.FieldProcessor;
import io.papermc.paper.configuration.mapping.InnerClassInstanceFactory;
import io.papermc.paper.configuration.mapping.InnerClassInstanceSupplier;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.objectmapping.FieldDiscoverer;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.util.CheckedFunction;

public final class InnerClassFieldDiscoverer
implements FieldDiscoverer<Map<Field, DeserializedFieldInfo<?>>> {
    private final InnerClassInstanceSupplier instanceSupplier;
    private final FieldDiscoverer<Map<Field, Object>> delegate;
    private final Map<Class<? extends Annotation>, List<Definition<?, ?, ? extends FieldProcessor.Factory<?, ?>>>> fieldProcessors;

    private InnerClassFieldDiscoverer(InnerClassInstanceSupplier instanceSupplier, FieldDiscoverer<Map<Field, Object>> delegate, Map<Class<? extends Annotation>, List<Definition<?, ?, ? extends FieldProcessor.Factory<?, ?>>>> fieldProcessors) {
        this.instanceSupplier = instanceSupplier;
        this.delegate = delegate;
        this.fieldProcessors = fieldProcessors;
    }

    public <V> // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable FieldDiscoverer.InstanceFactory<Map<Field, DeserializedFieldInfo<?>>> discover(AnnotatedType target, FieldDiscoverer.FieldCollector<Map<Field, DeserializedFieldInfo<?>>, V> collector) throws SerializationException {
        Class clazz = GenericTypeReflector.erase((Type)target.getType());
        if (ConfigurationPart.class.isAssignableFrom(clazz)) {
            FieldDiscoverer.InstanceFactory dummyInstance = this.delegate.discover(target, (name, fieldType, container, deserializer, serializer) -> {
                if (!GenericTypeReflector.erase((Type)fieldType.getType()).equals(clazz.getEnclosingClass())) {
                    FieldProcessor<?> processor = null;
                    block0: for (Annotation annotation : container.getAnnotations()) {
                        List<Definition<?, ?, FieldProcessor.Factory<?, ?>>> definitions = this.fieldProcessors.get(annotation.annotationType());
                        if (definitions == null) continue;
                        for (Definition<?, ?, FieldProcessor.Factory<?, ?>> def : definitions) {
                            if (!GenericTypeReflector.isSuperType((Type)def.type().getType(), (Type)GenericTypeReflector.box((Type)fieldType.getType()))) continue;
                            processor = def.factory().make(annotation, fieldType);
                            break block0;
                        }
                    }
                    FieldProcessor<?> finalProcessor = processor;
                    collector.accept(name, fieldType, container, (intermediate, newValue, implicitInitializer) -> {
                        LinkedHashMap map = new LinkedHashMap();
                        deserializer.accept(map, newValue, implicitInitializer);
                        Object deserializedValue = Objects.requireNonNullElseGet(newValue, () -> InnerClassFieldDiscoverer.lambda$discover$0((Supplier)implicitInitializer));
                        intermediate.put((Field)map.firstEntry().getKey(), new DeserializedFieldInfo(fieldType, deserializedValue, finalProcessor));
                    }, serializer);
                }
            });
            if (dummyInstance == null) {
                return null;
            }
            return new InnerClassInstanceFactory(this.instanceSupplier, target);
        }
        return null;
    }

    private static InnerClassFieldDiscoverer create(Map<Class<?>, Object> overrides, List<Definition<?, ?, ? extends FieldProcessor.Factory<?, ?>>> fieldProcessors) {
        LinkedHashMap processors = new LinkedHashMap();
        for (Definition<?, ?, FieldProcessor.Factory<?, ?>> definition : fieldProcessors) {
            processors.computeIfAbsent(definition.annotation(), k -> new ArrayList()).add(definition);
        }
        InnerClassInstanceSupplier instanceSupplier = new InnerClassInstanceSupplier(overrides);
        return new InnerClassFieldDiscoverer(instanceSupplier, (FieldDiscoverer<Map<Field, Object>>)FieldDiscoverer.object((CheckedFunction)instanceSupplier), processors);
    }

    public static FieldDiscoverer<?> worldConfig(WorldConfiguration worldConfiguration, List<Definition<?, ?, ? extends FieldProcessor.Factory<?, ?>>> fieldProcessors) {
        Map<Class<?>, Object> overrides = Map.of(WorldConfiguration.class, worldConfiguration);
        return InnerClassFieldDiscoverer.create(overrides, fieldProcessors);
    }

    public static FieldDiscoverer<?> globalConfig(List<Definition<?, ?, ? extends FieldProcessor.Factory<?, ?>>> fieldProcessors) {
        return InnerClassFieldDiscoverer.create(Collections.emptyMap(), fieldProcessors);
    }

    private static /* synthetic */ Object lambda$discover$0(Supplier implicitInitializer) {
        return new ImplicitProvider(implicitInitializer);
    }

    record ImplicitProvider(Supplier<Object> provider) {
    }
}

