/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.serializer.collection;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import io.leangen.geantyref.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class TableSerializer
implements TypeSerializer.Annotated<Table<?, ?, ?>> {
    private static final int ROW_TYPE_ARGUMENT_INDEX = 0;
    private static final int COLUMN_TYPE_ARGUMENT_INDEX = 1;
    private static final int VALUE_TYPE_ARGUMENT_INDEX = 2;

    public Table<?, ?, ?> deserialize(AnnotatedType type, ConfigurationNode node) throws SerializationException {
        HashBasedTable table = HashBasedTable.create();
        if (!node.empty() && node.isMap()) {
            this.deserialize0((Table)table, (AnnotatedParameterizedType)type, node);
        }
        return table;
    }

    private <R, C, V> void deserialize0(Table<R, C, V> table, AnnotatedParameterizedType type, ConfigurationNode node) throws SerializationException {
        AnnotatedType rowType = type.getAnnotatedActualTypeArguments()[0];
        AnnotatedType columnType = type.getAnnotatedActualTypeArguments()[1];
        AnnotatedType valueType = type.getAnnotatedActualTypeArguments()[2];
        TypeSerializer rowKeySerializer = node.options().serializers().get(rowType);
        if (rowKeySerializer == null) {
            throw new SerializationException("Could not find serializer for table row type " + String.valueOf(rowType));
        }
        ParameterizedType mapType = (ParameterizedType)TypeFactory.parameterizedClass(Map.class, (Type[])new Type[]{columnType.getType(), valueType.getType()});
        AnnotatedParameterizedType annotatedMapType = TypeFactory.parameterizedAnnotatedType((ParameterizedType)mapType, (Annotation[])type.getAnnotations(), (Annotation[][])new Annotation[][]{columnType.getAnnotations(), valueType.getAnnotations()});
        TypeSerializer columnValueSerializer = node.options().serializers().get((AnnotatedType)annotatedMapType);
        if (columnValueSerializer == null) {
            throw new SerializationException("Could not find serializer for table column-value map " + String.valueOf(type));
        }
        BasicConfigurationNode rowKeyNode = BasicConfigurationNode.root((ConfigurationOptions)node.options());
        for (Object key : node.childrenMap().keySet()) {
            Object rowKey = rowKeySerializer.deserialize(rowType, (ConfigurationNode)rowKeyNode.set(key));
            Map map = (Map)columnValueSerializer.deserialize((Type)mapType, node.node(new Object[]{rowKeyNode.raw()}));
            map.forEach((column, value) -> table.put(rowKey, column, value));
        }
    }

    public void serialize(AnnotatedType type, @Nullable Table<?, ?, ?> obj, ConfigurationNode node) throws SerializationException {
        if (obj != null) {
            this.serialize0(obj, (AnnotatedParameterizedType)type, node);
        }
    }

    private <R, C, V> void serialize0(Table<R, C, V> table, AnnotatedParameterizedType type, ConfigurationNode node) throws SerializationException {
        AnnotatedType rowType = type.getAnnotatedActualTypeArguments()[0];
        AnnotatedType columnType = type.getAnnotatedActualTypeArguments()[1];
        AnnotatedType valueType = type.getAnnotatedActualTypeArguments()[2];
        TypeSerializer rowKeySerializer = node.options().serializers().get(rowType);
        if (rowKeySerializer == null) {
            throw new SerializationException("Could not find a serializer for table row type " + String.valueOf(rowType));
        }
        BasicConfigurationNode rowKeyNode = BasicConfigurationNode.root((ConfigurationOptions)node.options());
        for (Object key : table.rowKeySet()) {
            rowKeySerializer.serialize(rowType, key, (ConfigurationNode)rowKeyNode.set(key));
            Object keyObj = Objects.requireNonNull(rowKeyNode.raw());
            ParameterizedType mapType = (ParameterizedType)TypeFactory.parameterizedClass(Map.class, (Type[])new Type[]{columnType.getType(), valueType.getType()});
            AnnotatedParameterizedType annotatedMapType = TypeFactory.parameterizedAnnotatedType((ParameterizedType)mapType, (Annotation[])type.getAnnotations(), (Annotation[][])new Annotation[][]{columnType.getAnnotations(), valueType.getAnnotations()});
            node.node(new Object[]{keyObj}).set((AnnotatedType)annotatedMapType, (Object)table.row(key));
        }
    }

    public @Nullable Table<?, ?, ?> emptyValue(Type specificType, ConfigurationOptions options) {
        return ImmutableTable.of();
    }
}

