/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.transformation.global.versioned;

import java.util.Properties;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;

public class V31_AllowNetherPropertiesToConfig
implements ConfigurationTransformation {
    public static final V31_AllowNetherPropertiesToConfig INSTANCE = new V31_AllowNetherPropertiesToConfig();
    private static final int VERSION = 31;

    public static void apply(ConfigurationTransformation.VersionedBuilder builder) {
        builder.addVersion(31, (ConfigurationTransformation)INSTANCE);
    }

    public void apply(ConfigurationNode root) throws ConfigurateException {
        DedicatedServer server = (DedicatedServer)MinecraftServer.getServer();
        String raw = server.settings.getProperties().properties.getProperty("allow-nether");
        if (raw != null) {
            ConfigurationNode node = root.node(new Object[]{"misc", "enable-nether"});
            node.set((Object)raw.equals("true"));
            server.settings.update(config -> {
                Properties newProps = new Properties(config.properties);
                newProps.remove("allow-nether");
                return config.reload(server.registryAccess(), newProps, server.options);
            });
        }
    }
}

