/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent;

import io.papermc.paper.datacomponent.DataComponentAdapter;
import io.papermc.paper.datacomponent.DataComponentAdapters;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.registry.HolderableBase;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.Registries;
import org.bukkit.craftbukkit.CraftRegistry;
import org.jspecify.annotations.Nullable;

public abstract class PaperDataComponentType<T, NMS>
extends HolderableBase<net.minecraft.core.component.DataComponentType<NMS>>
implements DataComponentType {
    private final DataComponentAdapter<NMS, T> adapter;

    public static <T> net.minecraft.core.component.DataComponentType<T> bukkitToMinecraft(DataComponentType type) {
        return (net.minecraft.core.component.DataComponentType)CraftRegistry.bukkitToMinecraft(type);
    }

    public static DataComponentType minecraftToBukkit(net.minecraft.core.component.DataComponentType<?> type) {
        return (DataComponentType)CraftRegistry.minecraftToBukkit(type, Registries.DATA_COMPONENT_TYPE);
    }

    public static Set<DataComponentType> minecraftToBukkit(Set<net.minecraft.core.component.DataComponentType<?>> nmsTypes) {
        HashSet<DataComponentType> types = new HashSet<DataComponentType>(nmsTypes.size());
        for (net.minecraft.core.component.DataComponentType<?> nmsType : nmsTypes) {
            types.add(PaperDataComponentType.minecraftToBukkit(nmsType));
        }
        return Collections.unmodifiableSet(types);
    }

    public static <B, M> @Nullable B convertDataComponentValue(DataComponentMap map, ValuedImpl<B, M> type) {
        net.minecraft.core.component.DataComponentType nms = PaperDataComponentType.bukkitToMinecraft(type);
        Object nmsValue = map.get(nms);
        if (nmsValue == null) {
            return null;
        }
        return (B)type.getAdapter().fromVanilla(nmsValue);
    }

    private PaperDataComponentType(Holder<net.minecraft.core.component.DataComponentType<NMS>> holder, DataComponentAdapter<NMS, T> adapter) {
        super(holder);
        this.adapter = adapter;
    }

    public boolean isPersistent() {
        return !((net.minecraft.core.component.DataComponentType)this.getHandle()).isTransient();
    }

    public DataComponentAdapter<NMS, T> getAdapter() {
        return this.adapter;
    }

    public static <NMS> DataComponentType of(Holder<?> holder) {
        DataComponentAdapter<?, ?> adapter = DataComponentAdapters.ADAPTERS.get(holder.unwrapKey().orElseThrow());
        if (adapter == null) {
            throw new IllegalArgumentException("No adapter found for " + String.valueOf(holder));
        }
        if (adapter.isUnimplemented()) {
            return new Unimplemented(holder, adapter);
        }
        if (adapter.isValued()) {
            return new ValuedImpl(holder, adapter);
        }
        return new NonValuedImpl(holder, adapter);
    }

    static {
        DataComponentAdapters.bootstrap();
    }

    public static final class ValuedImpl<T, NMS>
    extends PaperDataComponentType<T, NMS>
    implements DataComponentType.Valued<T> {
        ValuedImpl(Holder<net.minecraft.core.component.DataComponentType<NMS>> holder, DataComponentAdapter<NMS, T> adapter) {
            super(holder, adapter);
        }
    }

    public static final class Unimplemented<T, NMS>
    extends PaperDataComponentType<T, NMS> {
        public Unimplemented(Holder<net.minecraft.core.component.DataComponentType<NMS>> holder, DataComponentAdapter<NMS, T> adapter) {
            super(holder, adapter);
        }
    }

    public static final class NonValuedImpl<T, NMS>
    extends PaperDataComponentType<T, NMS>
    implements DataComponentType.NonValued {
        NonValuedImpl(Holder<net.minecraft.core.component.DataComponentType<NMS>> holder, DataComponentAdapter<NMS, T> adapter) {
            super(holder, adapter);
        }
    }
}

