/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.craftbukkit.util.Handleable;

public record PaperCustomModelData(net.minecraft.world.item.component.CustomModelData impl) implements CustomModelData,
Handleable<net.minecraft.world.item.component.CustomModelData>
{
    @Override
    public net.minecraft.world.item.component.CustomModelData getHandle() {
        return this.impl;
    }

    public List<Float> floats() {
        return Collections.unmodifiableList(this.impl.floats());
    }

    public List<Boolean> flags() {
        return Collections.unmodifiableList(this.impl.flags());
    }

    public List<String> strings() {
        return Collections.unmodifiableList(this.impl.strings());
    }

    public List<Color> colors() {
        return MCUtil.transformUnmodifiable(this.impl.colors(), color -> Color.fromRGB((int)(color & 0xFFFFFF)));
    }

    static final class BuilderImpl
    implements CustomModelData.Builder {
        private final FloatList floats = new FloatArrayList();
        private final BooleanList flags = new BooleanArrayList();
        private final List<String> strings = new ObjectArrayList();
        private final IntList colors = new IntArrayList();

        BuilderImpl() {
        }

        public CustomModelData.Builder addFloat(float f) {
            this.floats.add(f);
            return this;
        }

        public CustomModelData.Builder addFloats(List<Float> floats) {
            for (Float f : floats) {
                Preconditions.checkArgument((f != null ? 1 : 0) != 0, (Object)"Float cannot be null");
            }
            this.floats.addAll(floats);
            return this;
        }

        public CustomModelData.Builder addFlag(boolean flag) {
            this.flags.add(flag);
            return this;
        }

        public CustomModelData.Builder addFlags(List<Boolean> flags) {
            for (Boolean flag : flags) {
                Preconditions.checkArgument((flag != null ? 1 : 0) != 0, (Object)"Flag cannot be null");
            }
            this.flags.addAll(flags);
            return this;
        }

        public CustomModelData.Builder addString(String string) {
            Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"String cannot be null");
            this.strings.add(string);
            return this;
        }

        public CustomModelData.Builder addStrings(List<String> strings) {
            strings.forEach(this::addString);
            return this;
        }

        public CustomModelData.Builder addColor(Color color) {
            Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"Color cannot be null");
            this.colors.add(color.asRGB());
            return this;
        }

        public CustomModelData.Builder addColors(List<Color> colors) {
            colors.forEach(this::addColor);
            return this;
        }

        public CustomModelData build() {
            return new PaperCustomModelData(new net.minecraft.world.item.component.CustomModelData((List<Float>)new FloatArrayList(this.floats), (List<Boolean>)new BooleanArrayList(this.flags), (List<String>)new ObjectArrayList(this.strings), (List<Integer>)new IntArrayList(this.colors)));
        }
    }
}

