/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.destroystokyo.paper.profile.SharedPlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.profile.MutablePropertyMap;
import io.papermc.paper.util.MCUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.minecraft.core.ClientAsset;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.component.ResolvableProfile;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

public record PaperResolvableProfile(net.minecraft.world.item.component.ResolvableProfile impl) implements ResolvableProfile,
Handleable<net.minecraft.world.item.component.ResolvableProfile>
{
    static PaperResolvableProfile toApi(PlayerProfile profile) {
        return new PaperResolvableProfile(((SharedPlayerProfile)profile).buildResolvableProfile());
    }

    @Override
    public net.minecraft.world.item.component.ResolvableProfile getHandle() {
        return this.impl;
    }

    public @Nullable UUID uuid() {
        return this.impl.unpack().map(GameProfile::id, p -> p.id().orElse(null));
    }

    public @Nullable String name() {
        return this.impl.unpack().map(GameProfile::name, p -> p.name().orElse(null));
    }

    public @Unmodifiable Collection<ProfileProperty> properties() {
        return MCUtil.transformUnmodifiable(this.impl.unpack().map(GameProfile::properties, ResolvableProfile.Partial::properties).values(), input -> new ProfileProperty(input.name(), input.value(), input.signature()));
    }

    public boolean dynamic() {
        return this.impl instanceof ResolvableProfile.Dynamic;
    }

    public CompletableFuture<PlayerProfile> resolve() {
        return this.impl.resolveProfile(MinecraftServer.getServer().services().profileResolver()).thenApply(CraftPlayerProfile::asBukkitCopy);
    }

    public ResolvableProfile.SkinPatch skinPatch() {
        return PaperSkinPatch.asPaper(this.getHandle().skinPatch());
    }

    public void applySkinToPlayerHeadContents(PlayerHeadObjectContents.Builder builder) {
        if (this.dynamic()) {
            if (this.uuid() != null) {
                builder.id(this.uuid());
            } else {
                builder.name(this.name());
            }
            return;
        }
        builder.id(this.uuid()).name(this.name()).profileProperties(this.impl.unpack().map(GameProfile::properties, ResolvableProfile.Partial::properties).values().stream().map(prop -> PlayerHeadObjectContents.property((String)prop.name(), (String)prop.value(), (String)prop.signature())).toList()).texture((Key)this.impl.skinPatch().body().map(ClientAsset.ResourceTexture::id).map(PaperAdventure::asAdventure).orElse(null));
    }

    record PaperSkinPatch(@Nullable Key body, @Nullable Key cape, @Nullable Key elytra, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable PlayerTextures.SkinModel model) implements ResolvableProfile.SkinPatch
    {
        static PaperSkinPatch asPaper(PlayerSkin.Patch patch) {
            if (patch == PlayerSkin.Patch.EMPTY) {
                return (PaperSkinPatch)ResolvableProfile.SkinPatch.empty();
            }
            return new PaperSkinPatch(patch.body().map(ClientAsset.ResourceTexture::id).map(PaperAdventure::asAdventure).orElse(null), patch.cape().map(ClientAsset.ResourceTexture::id).map(PaperAdventure::asAdventure).orElse(null), patch.elytra().map(ClientAsset.ResourceTexture::id).map(PaperAdventure::asAdventure).orElse(null), patch.model().map(m -> m == PlayerModelType.SLIM ? PlayerTextures.SkinModel.SLIM : PlayerTextures.SkinModel.CLASSIC).orElse(null));
        }

        PlayerSkin.Patch asVanilla() {
            return PlayerSkin.Patch.create(Optional.ofNullable(this.body).map(key -> new ClientAsset.ResourceTexture(PaperAdventure.asVanilla(key))), Optional.ofNullable(this.cape).map(key -> new ClientAsset.ResourceTexture(PaperAdventure.asVanilla(key))), Optional.ofNullable(this.elytra).map(key -> new ClientAsset.ResourceTexture(PaperAdventure.asVanilla(key))), Optional.ofNullable(this.model).map(m -> m == PlayerTextures.SkinModel.SLIM ? PlayerModelType.SLIM : PlayerModelType.WIDE));
        }
    }

    static final class BuilderImpl
    implements ResolvableProfile.Builder {
        private final PropertyMap propertyMap = new MutablePropertyMap();
        private @Nullable String name;
        private @Nullable UUID uuid;
        private PaperSkinPatch skinPatch = (PaperSkinPatch)ResolvableProfile.SkinPatch.empty();

        BuilderImpl() {
        }

        public ResolvableProfile.Builder name(@Nullable String name) {
            if (name != null) {
                Preconditions.checkArgument((name.length() <= 16 ? 1 : 0) != 0, (String)"name cannot be more than 16 characters, was %s", (int)name.length());
                Preconditions.checkArgument((boolean)StringUtil.isValidPlayerName(name), (String)"name cannot include invalid characters, was %s", (Object)name);
            }
            this.name = name;
            return this;
        }

        public ResolvableProfile.Builder uuid(@Nullable UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public ResolvableProfile.Builder addProperty(ProfileProperty property) {
            Property newProperty = new Property(property.getName(), property.getValue(), property.getSignature());
            if (!this.propertyMap.containsEntry((Object)property.getName(), (Object)newProperty)) {
                int newSize = this.propertyMap.size() + 1;
                Preconditions.checkArgument((newSize <= 16 ? 1 : 0) != 0, (String)"Cannot have more than 16 properties, was %s", (int)newSize);
            }
            this.propertyMap.put((Object)property.getName(), (Object)newProperty);
            return this;
        }

        public ResolvableProfile.Builder addProperties(Collection<ProfileProperty> properties) {
            properties.forEach(this::addProperty);
            return this;
        }

        public ResolvableProfile.Builder skinPatch(ResolvableProfile.SkinPatch patch) {
            Preconditions.checkArgument((patch != null ? 1 : 0) != 0, (Object)"patch cannot be null");
            this.skinPatch = (PaperSkinPatch)patch;
            return this;
        }

        public ResolvableProfile.Builder skinPatch(Consumer<ResolvableProfile.SkinPatchBuilder> configure) {
            Preconditions.checkArgument((configure != null ? 1 : 0) != 0, (Object)"configure cannot be null");
            ResolvableProfile.SkinPatchBuilder builder = ResolvableProfile.SkinPatch.skinPatch();
            builder.body(this.skinPatch.body());
            builder.cape(this.skinPatch.cape());
            builder.elytra(this.skinPatch.elytra());
            builder.model(this.skinPatch.model());
            configure.accept(builder);
            this.skinPatch = (PaperSkinPatch)builder.build();
            return this;
        }

        public ResolvableProfile build() {
            if (this.propertyMap.isEmpty() && this.uuid == null != (this.name == null)) {
                return new PaperResolvableProfile(new ResolvableProfile.Dynamic(this.name != null ? Either.left(this.name) : Either.right(this.uuid), this.skinPatch.asVanilla()));
            }
            return new PaperResolvableProfile(new ResolvableProfile.Static(Either.right(new ResolvableProfile.Partial(Optional.ofNullable(this.name), Optional.ofNullable(this.uuid), new PropertyMap((Multimap)this.propertyMap))), this.skinPatch.asVanilla()));
        }
    }

    static final class SkinPatchBuilderImpl
    implements ResolvableProfile.SkinPatchBuilder {
        private @Nullable Key body;
        private @Nullable Key cape;
        private @Nullable Key elytra;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable PlayerTextures.SkinModel model;

        SkinPatchBuilderImpl() {
        }

        public ResolvableProfile.SkinPatchBuilder body(@Nullable Key body) {
            this.body = body;
            return this;
        }

        public ResolvableProfile.SkinPatchBuilder cape(@Nullable Key cape) {
            this.cape = cape;
            return this;
        }

        public ResolvableProfile.SkinPatchBuilder elytra(@Nullable Key elytra) {
            this.elytra = elytra;
            return this;
        }

        public ResolvableProfile.SkinPatchBuilder model(// Could not load outer class - annotation placement on inner may be incorrect
         @Nullable PlayerTextures.SkinModel model) {
            this.model = model;
            return this;
        }

        public ResolvableProfile.SkinPatch build() {
            if (this.body == null && this.cape == null && this.elytra == null && this.model == null) {
                return ResolvableProfile.SkinPatch.empty();
            }
            return new PaperSkinPatch(this.body, this.cape, this.elytra, this.model);
        }
    }
}

