/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.entity.Shearable;
import net.kyori.adventure.sound.Sound;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public interface PaperShearable
extends Shearable {
    public net.minecraft.world.entity.Shearable getHandle();

    default public boolean readyToBeSheared() {
        return this.getHandle().readyForShearing();
    }

    default public void shear(@NotNull Sound.Source source) {
        Level level = this.getHandle().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.getHandle().shear(serverLevel, PaperAdventure.asVanilla(source), new ItemStack(Items.SHEARS));
    }
}

