/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.player;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.connection.PlayerCommonConnection;
import io.papermc.paper.dialog.DialogResponseView;
import io.papermc.paper.dialog.PaperDialogResponseView;
import io.papermc.paper.event.player.PlayerCustomClickEvent;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jspecify.annotations.Nullable;

public class PaperPlayerCustomClickEvent
extends PlayerCustomClickEvent {
    private final @Nullable Tag payload;
    private @Nullable BinaryTagHolder apiPayload;
    private @Nullable DialogResponseView rawResponse;

    public PaperPlayerCustomClickEvent(Key key, PlayerCommonConnection commonConnection, @Nullable Tag payload) {
        super(key, commonConnection);
        this.payload = payload;
    }

    public @Nullable BinaryTagHolder getTag() {
        if (this.apiPayload == null && this.payload != null) {
            this.apiPayload = BinaryTagHolder.encode((Object)this.payload, PaperAdventure.NBT_CODEC);
        }
        return this.apiPayload;
    }

    public @Nullable DialogResponseView getDialogResponseView() {
        Tag tag;
        if (this.payload == null || !((tag = this.payload) instanceof CompoundTag)) {
            return null;
        }
        CompoundTag compoundPayload = (CompoundTag)tag;
        if (this.rawResponse == null) {
            this.rawResponse = PaperDialogResponseView.createUnvalidatedResponse(compoundPayload);
        }
        return this.rawResponse;
    }
}

