/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.source;

import com.mojang.logging.LogUtils;
import io.papermc.paper.plugin.entrypoint.EntrypointHandler;
import io.papermc.paper.plugin.provider.source.FileProviderSource;
import io.papermc.paper.plugin.provider.source.ProviderSource;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class FileArrayProviderSource
implements ProviderSource<File[], List<Path>> {
    public static final FileArrayProviderSource INSTANCE = new FileArrayProviderSource();
    private static final FileProviderSource FILE_PROVIDER_SOURCE = new FileProviderSource(arg_0 -> FileArrayProviderSource.lambda$static$0("File '%s'", arg_0));
    private static final Logger LOGGER = LogUtils.getClassLogger();

    @Override
    public List<Path> prepareContext(File[] context) {
        ArrayList<Path> files = new ArrayList<Path>();
        for (File file : context) {
            try {
                files.add(FILE_PROVIDER_SOURCE.prepareContext(file.toPath()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception e) {
                LOGGER.error("Error preparing plugin context: " + e.getMessage(), (Throwable)e);
            }
        }
        return files;
    }

    @Override
    public void registerProviders(EntrypointHandler entrypointHandler, List<Path> context) {
        for (Path path : context) {
            try {
                FILE_PROVIDER_SOURCE.registerProviders(entrypointHandler, path);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception e) {
                LOGGER.error("Error loading plugin: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static /* synthetic */ String lambda$static$0(String rec$, Object xva$0) {
        return "File '%s'".formatted(xva$0);
    }
}

