/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.storage;

import com.mojang.logging.LogUtils;
import io.papermc.paper.plugin.entrypoint.dependency.DependencyContextHolder;
import io.papermc.paper.plugin.entrypoint.strategy.ProviderConfiguration;
import io.papermc.paper.plugin.manager.PaperPluginManagerImpl;
import io.papermc.paper.plugin.provider.PluginProvider;
import io.papermc.paper.plugin.provider.entrypoint.DependencyContext;
import io.papermc.paper.plugin.provider.type.paper.PaperPluginParent;
import io.papermc.paper.plugin.storage.ConfiguredProviderStorage;
import java.util.List;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.slf4j.Logger;

public class ServerPluginProviderStorage
extends ConfiguredProviderStorage<JavaPlugin> {
    private static final Logger LOGGER = LogUtils.getClassLogger();

    public ServerPluginProviderStorage() {
        super(new ProviderConfiguration<JavaPlugin>(){

            @Override
            public void applyContext(PluginProvider<JavaPlugin> provider, DependencyContext dependencyContext) {
                Plugin alreadyLoadedPlugin = PaperPluginManagerImpl.getInstance().getPlugin(provider.getMeta().getName());
                if (alreadyLoadedPlugin != null) {
                    throw new IllegalStateException("Provider " + String.valueOf(provider) + " attempted to add duplicate plugin identifier " + String.valueOf(alreadyLoadedPlugin) + " THIS WILL CREATE BUGS!!!");
                }
                if (provider instanceof DependencyContextHolder) {
                    DependencyContextHolder contextHolder = (DependencyContextHolder)((Object)provider);
                    contextHolder.setContext(dependencyContext);
                }
            }

            @Override
            public boolean load(PluginProvider<JavaPlugin> provider, JavaPlugin provided) {
                PaperPluginManagerImpl.getInstance().loadPlugin((Plugin)provided);
                return true;
            }
        });
    }

    @Override
    protected void filterLoadingProviders(List<PluginProvider<JavaPlugin>> pluginProviders) {
        pluginProviders.removeIf(provider -> {
            PaperPluginParent.PaperServerPluginProvider pluginProvider;
            return provider instanceof PaperPluginParent.PaperServerPluginProvider && (pluginProvider = (PaperPluginParent.PaperServerPluginProvider)provider).shouldSkipCreation();
        });
    }

    @Override
    public void processProvided(PluginProvider<JavaPlugin> provider, JavaPlugin provided) {
        try {
            provided.getLogger().info(String.format("Loading server plugin %s", provided.getPluginMeta().getDisplayName()));
            provided.onLoad();
        }
        catch (Throwable ex) {
            provided.getSLF4JLogger().error("Error initializing plugin '%s' in folder '%s' (Is it up to date?)".formatted(provider.getFileName(), provider.getParentSource()), ex);
        }
    }

    @Override
    public String toString() {
        return "PLUGIN:" + super.toString();
    }
}

