/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.ChickenVariantRegistryEntry;
import io.papermc.paper.registry.data.client.ClientTextureAsset;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import net.minecraft.core.ClientAsset;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import org.bukkit.entity.Chicken;
import org.jspecify.annotations.Nullable;

public class PaperChickenVariantRegistryEntry
implements ChickenVariantRegistryEntry {
    protected @Nullable ChickenVariant.ModelType model;
    protected @Nullable ClientAsset.ResourceTexture clientTextureAsset;
    protected SpawnPrioritySelectors spawnConditions;
    protected final Conversions conversions;

    public PaperChickenVariantRegistryEntry(Conversions conversions, @Nullable ChickenVariant internal) {
        this.conversions = conversions;
        if (internal == null) {
            this.spawnConditions = SpawnPrioritySelectors.EMPTY;
            return;
        }
        this.clientTextureAsset = internal.modelAndTexture().asset();
        this.model = internal.modelAndTexture().model();
        this.spawnConditions = internal.spawnConditions();
    }

    public ClientTextureAsset clientTextureAsset() {
        return this.conversions.asBukkit(Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset"));
    }

    public ChickenVariantRegistryEntry.Model model() {
        return switch (Checks.asConfigured(this.model, "model")) {
            default -> throw new MatchException(null, null);
            case ChickenVariant.ModelType.NORMAL -> ChickenVariantRegistryEntry.Model.NORMAL;
            case ChickenVariant.ModelType.COLD -> ChickenVariantRegistryEntry.Model.COLD;
        };
    }

    public static final class PaperBuilder
    extends PaperChickenVariantRegistryEntry
    implements ChickenVariantRegistryEntry.Builder,
    PaperRegistryBuilder<ChickenVariant, Chicken.Variant> {
        public PaperBuilder(Conversions conversions, @Nullable ChickenVariant internal) {
            super(conversions, internal);
        }

        public ChickenVariantRegistryEntry.Builder clientTextureAsset(ClientTextureAsset clientTextureAsset) {
            this.clientTextureAsset = this.conversions.asVanilla(Checks.asArgument(clientTextureAsset, "clientTextureAsset"));
            return this;
        }

        public ChickenVariantRegistryEntry.Builder model(ChickenVariantRegistryEntry.Model model) {
            this.model = switch (Checks.asArgument(model, "model")) {
                default -> throw new MatchException(null, null);
                case ChickenVariantRegistryEntry.Model.NORMAL -> ChickenVariant.ModelType.NORMAL;
                case ChickenVariantRegistryEntry.Model.COLD -> ChickenVariant.ModelType.COLD;
            };
            return this;
        }

        @Override
        public ChickenVariant build() {
            return new ChickenVariant(new ModelAndTexture<ChickenVariant.ModelType>(Checks.asConfigured(this.model, "model"), Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset")), Checks.asConfigured(this.spawnConditions, "spawnConditions"));
        }
    }
}

