/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.CowVariantRegistryEntry;
import io.papermc.paper.registry.data.client.ClientTextureAsset;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import net.minecraft.core.ClientAsset;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import org.bukkit.entity.Cow;
import org.jspecify.annotations.Nullable;

public class PaperCowVariantRegistryEntry
implements CowVariantRegistryEntry {
    protected @Nullable CowVariant.ModelType model = null;
    protected @Nullable ClientAsset.ResourceTexture clientTextureAsset = null;
    protected SpawnPrioritySelectors spawnConditions;
    protected final Conversions conversions;

    public PaperCowVariantRegistryEntry(Conversions conversions, @Nullable CowVariant internal) {
        this.conversions = conversions;
        if (internal == null) {
            this.spawnConditions = SpawnPrioritySelectors.EMPTY;
            return;
        }
        this.clientTextureAsset = internal.modelAndTexture().asset();
        this.model = internal.modelAndTexture().model();
        this.spawnConditions = internal.spawnConditions();
    }

    public ClientTextureAsset clientTextureAsset() {
        return this.conversions.asBukkit(Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset"));
    }

    public CowVariantRegistryEntry.Model model() {
        return switch (Checks.asConfigured(this.model, "model")) {
            default -> throw new MatchException(null, null);
            case CowVariant.ModelType.NORMAL -> CowVariantRegistryEntry.Model.NORMAL;
            case CowVariant.ModelType.COLD -> CowVariantRegistryEntry.Model.COLD;
            case CowVariant.ModelType.WARM -> CowVariantRegistryEntry.Model.WARM;
        };
    }

    public static final class PaperBuilder
    extends PaperCowVariantRegistryEntry
    implements CowVariantRegistryEntry.Builder,
    PaperRegistryBuilder<CowVariant, Cow.Variant> {
        public PaperBuilder(Conversions conversions, @Nullable CowVariant internal) {
            super(conversions, internal);
        }

        public CowVariantRegistryEntry.Builder clientTextureAsset(ClientTextureAsset clientTextureAsset) {
            this.clientTextureAsset = this.conversions.asVanilla(Checks.asArgument(clientTextureAsset, "clientTextureAsset"));
            return this;
        }

        public CowVariantRegistryEntry.Builder model(CowVariantRegistryEntry.Model model) {
            this.model = switch (Checks.asArgument(model, "model")) {
                default -> throw new MatchException(null, null);
                case CowVariantRegistryEntry.Model.NORMAL -> CowVariant.ModelType.NORMAL;
                case CowVariantRegistryEntry.Model.COLD -> CowVariant.ModelType.COLD;
                case CowVariantRegistryEntry.Model.WARM -> CowVariant.ModelType.WARM;
            };
            return this;
        }

        @Override
        public CowVariant build() {
            return new CowVariant(new ModelAndTexture<CowVariant.ModelType>(Checks.asConfigured(this.model, "model"), Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset")), this.spawnConditions);
        }
    }
}

