/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog;

import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.PaperDialogCodecs;
import io.papermc.paper.registry.data.dialog.type.ConfirmationType;
import io.papermc.paper.registry.data.dialog.type.DialogListType;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import io.papermc.paper.registry.data.dialog.type.MultiActionType;
import io.papermc.paper.registry.data.dialog.type.NoticeType;
import io.papermc.paper.registry.data.dialog.type.ServerLinksType;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistrySet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.dialog.CommonDialogData;
import net.minecraft.server.dialog.ConfirmationDialog;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.DialogListDialog;
import net.minecraft.server.dialog.MultiActionDialog;
import net.minecraft.server.dialog.NoticeDialog;
import net.minecraft.server.dialog.ServerLinksDialog;

public final class PaperDialogs {
    private PaperDialogs() {
    }

    public static DialogType extractType(Dialog nmsDialog, Conversions conversions) {
        Function<net.minecraft.server.dialog.ActionButton, ActionButton> convertButton = button -> conversions.convert(button, PaperDialogCodecs.ACTION_BUTTON_CODEC, net.minecraft.server.dialog.ActionButton.CODEC);
        Dialog dialog = nmsDialog;
        Objects.requireNonNull(dialog);
        Dialog dialog2 = dialog;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConfirmationDialog.class, DialogListDialog.class, MultiActionDialog.class, NoticeDialog.class, ServerLinksDialog.class}, (Object)dialog2, n)) {
            case 0 -> {
                ConfirmationDialog conf = (ConfirmationDialog)dialog2;
                yield DialogType.confirmation((ActionButton)convertButton.apply(conf.yesButton()), (ActionButton)convertButton.apply(conf.noButton()));
            }
            case 1 -> {
                DialogListDialog list = (DialogListDialog)dialog2;
                RegistrySet apiSet = PaperRegistrySets.convertToApiWithDirects(RegistryKey.DIALOG, list.dialogs());
                yield DialogType.dialogList(apiSet, (ActionButton)list.exitAction().map(convertButton).orElse(null), (int)list.columns(), (int)list.buttonWidth());
            }
            case 2 -> {
                MultiActionDialog multi = (MultiActionDialog)dialog2;
                yield DialogType.multiAction(multi.actions().stream().map(convertButton).toList(), (ActionButton)multi.exitAction().map(convertButton).orElse(null), (int)multi.columns());
            }
            case 3 -> {
                NoticeDialog notice = (NoticeDialog)dialog2;
                yield DialogType.notice((ActionButton)convertButton.apply(notice.action()));
            }
            case 4 -> {
                ServerLinksDialog links = (ServerLinksDialog)dialog2;
                yield DialogType.serverLinks((ActionButton)links.exitAction().map(convertButton).orElse(null), (int)links.columns(), (int)links.buttonWidth());
            }
            default -> throw new IllegalArgumentException("Unsupported dialog type: " + nmsDialog.getClass().getName());
        };
    }

    public static Dialog constructDialog(DialogBase dialogBase, DialogType dialogType, Conversions conversions) {
        Function<ActionButton, net.minecraft.server.dialog.ActionButton> convertButton = button -> conversions.convert(button, net.minecraft.server.dialog.ActionButton.CODEC, PaperDialogCodecs.ACTION_BUTTON_CODEC);
        CommonDialogData common = (CommonDialogData)conversions.convert(dialogBase, CommonDialogData.MAP_CODEC.codec(), PaperDialogCodecs.DIALOG_BASE_CODEC);
        DialogType dialogType2 = dialogType;
        Objects.requireNonNull(dialogType2);
        DialogType dialogType3 = dialogType2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConfirmationType.class, DialogListType.class, MultiActionType.class, NoticeType.class, ServerLinksType.class}, (Object)dialogType3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ConfirmationType conf = (ConfirmationType)dialogType3;
                return new ConfirmationDialog(common, convertButton.apply(conf.yesButton()), convertButton.apply(conf.noButton()));
            }
            case 1: {
                DialogListType list = (DialogListType)dialogType3;
                return new DialogListDialog(common, PaperRegistrySets.convertToNmsWithDirects(Registries.DIALOG, conversions.lookup(), list.dialogs()), Optional.ofNullable(list.exitAction()).map(convertButton), list.columns(), list.buttonWidth());
            }
            case 2: {
                MultiActionType multi = (MultiActionType)dialogType3;
                return new MultiActionDialog(common, multi.actions().stream().map(convertButton).toList(), Optional.ofNullable(multi.exitAction()).map(convertButton), multi.columns());
            }
            case 3: {
                NoticeType notice = (NoticeType)dialogType3;
                return new NoticeDialog(common, convertButton.apply(notice.action()));
            }
            case 4: 
        }
        ServerLinksType links = (ServerLinksType)dialogType3;
        return new ServerLinksDialog(common, Optional.ofNullable(links.exitAction()).map(convertButton), links.columns(), links.buttonWidth());
    }
}

